/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.hosted.image.ImageHeapConnectedComponentsFeature;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class ImageHeapConnectedComponentsFeature_Options_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(ImageHeapConnectedComponentsFeature.Options.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "PrintImageHeapConnectedComponents": {
                return OptionDescriptor.create((String)"PrintImageHeapConnectedComponents", (OptionType)OptionType.Debug, Boolean.class, (String)"A native-image run with the flag `-H:+PrintImageHeapConnectedComponents` will create reports that can help us debug which objects got into the native image heap and why. A component represents a set of objects in the image heap.\nThe reports divide components into two kinds:\n* Special components: Code metadata, Class data, Interned strings table, and Resources\n* Connected components: These components consist of objects that refer to one another and are not of special components kind.\n\nWhen `PrintImageHeapConnectedComponents` flag is enabled, a native-image run will generate three reports with the following names:\n* connected_components_{image-name}_{timestamp}.txt\n* summary_info_for_every_object_in_connected_components_{image-name}_{timestamp}.json\n* access_points_for_connected_components_{image-name}_{timestamp}.json\n\nConnected components are listed in the body of a connected_components_{image-name}_{timestamp}.txt report sorted\nin descending order by their sizes.\n\nHere is an example of a connected component summary info in a .connected_components_{image-name}_{timestamp}.txt report:\n```\n==============================================================================================================================================\n================================ ComponentId=21 | Size=3.05KiB | Percentage of total image heap size=0.0866% =================================\n   Count     Size   Size%    Cum% Class\n      52     1664  53.33%  53.33% java.math.BigInteger\n      37      720  23.08%  76.41% java.math.BigInteger[]\n      36      576  18.46%  94.87% int[]\n       1      160   5.13% 100.00% java.math.BigInteger[][]\n\nStatic fields accessing component 21:\n\tjava.math.BigInteger#powerCache\n\nMethods accessing connected component 21:\n\tjava.math.BigInteger#valueOf(long)\n\tjava.math.BigInteger#shiftRightImpl(int)\n\tjava.math.BigInteger#valueOf(long)\n\tjava.math.BigInteger#pow(int)\n\tjava.math.BigInteger#pow(int)\n```\nWe can see that the component size is 3.05KiB and\nthat it takes 0.0866% of the total image heap size.\nBelow the connected component summary is the histogram of objects in that connected component. For example, we see\nthat the component has 52 BigInteger objects, 37 BigInteger[] objects, 36 int[] objects, and 1 BigInteger[][] object.\n`Static fields accessing Component 21` segment contains the list of static fields referencing an object from the connected component.\nMethods accessing connected components is the list of methods referencing one or more objects from the connected component.\n\nSometimes too many methods and static fields reference a single component to be displayed in the\n`access_points_for_connected_components_{image-name}_{timestamp}.json` report.\nFor that reason, the report `access_points_for_connected_components_{image-name}_{timestamp}.json` contains, for each\ncomponent, a list of method and static field names that reference objects inside a given component.\n\nReport `summary_info_for_every_object_in_connected_components_{image-name}_{timestamp}.json` gives a short summary info\nfor all objects in the connected_components_{image-name}_{timestamp}.txt report.\n`summary_info_for_every_object_in_connected_components_{image-name}_{timestamp}.json` is a json file with the following\nstructure:\n```\n{\n    \"connectedComponents\":[\n        \"componentId\":0,\n        \"sizeInBytes\":95920,\n        \"objects\":[\n            {\n                \"className\":\"[B\",\n                \"identityHashCode\":\"1118440229\",\n                \"constantValue\":\"byte[21]{40, 76, 106, 97, 118, ...}\",\n                \"reason\":{\n                    \"kind\":\"object\",\n                    \"value\":\"2126035551\"\n                }\n            },\n            ...\n    ],\n    \"classData\":{\n        \"sizeInBytes\":1245240,\n        \"objects\":[{...},...]\n    },\n    \"codeMetadata\":{\n        \"sizeInBytes\":914200,\n        \"objects\":[{...},...]\n    },\n    \"internedStringsTable\":{\n        \"sizeInBytes\":17400,\n        \"objects\":[{...},...]\n    }\n    \"resources\":{\n        \"sizeInBytes\":0,\n        \"objects\":[]\n    }\n}\n```\nField `connectedComponents` array contains for each component the following fields:\n    `componentId` - id from the connected_components_{image-name}_{timestamp}.txt report\n    `sizeInBytes` - total size of the component in bytes\n    `reason` - is why an object was added to the image heap. The field `kind` can have one of the following values: \"object\", \"method\", \"staticField\", \"svmInternal\".\n                \"object\" means that another object referenced the object in the image heap, and in that case, the field \"value\" holds the identityHashCode of that object\n                \"method\" means that the object was added because some method has a reference to it, and in that case, the field \"value\" holds the method name\n                \"staticField\" means that the object was added because a static field is referencing it and, in that case, the field \"value\" holds the name of that static field\n                \"svmInternal\" means that the object was added by the internal infrastructure of the native-image\n    `objects` - an array of summary info for every object in the component. `identityHashCode` is the objects unique\n                identifier. We can use `identityHashCode` to identify why the object was added.\n                In the example above we can see that the `reason` that object with an `identityHashCode` value of\n                1118440229 was added because it was referenced by another object whose `identityHashCode` value is 2126035551.\n\nFields `classData`, `codeMetadata`, `resources`, and 'internedStringTable' each contain an array of `objects` that are in these\nspecial component groups and the field `sizeInBytes` which is the total size of the objects in that special group.", (Object)this.getContainer(), ImageHeapConnectedComponentsFeature.Options.PrintImageHeapConnectedComponents, (String)"PrintImageHeapConnectedComponents", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 1;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return ImageHeapConnectedComponentsFeature_Options_OptionDescriptors.this.get("PrintImageHeapConnectedComponents");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

