/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.imagelayer.LayeredDispatchTableFeature;
import com.oracle.svm.hosted.meta.HostedMethod;
import org.graalvm.nativeimage.ImageSingletons;

public class MethodPointerRelocationProvider {
    private final boolean imageLayer = ImageLayerBuildingSupport.buildingImageLayer();

    public static MethodPointerRelocationProvider singleton() {
        return (MethodPointerRelocationProvider)ImageSingletons.lookup(MethodPointerRelocationProvider.class);
    }

    public void markMethodPointerRelocation(ObjectFile.ProgbitsSectionImpl section, int offset, ObjectFile.RelocationKind relocationKind, HostedMethod target, long addend, MethodPointer methodPointer, boolean isInjectedNotCompiled) {
        String symbolName = this.imageLayer ? LayeredDispatchTableFeature.singleton().getSymbolName(methodPointer, target, isInjectedNotCompiled) : NativeImage.localSymbolNameForMethod(target);
        section.markRelocationSite(offset, relocationKind, symbolName, addend);
    }
}

