/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.heap.ImageHeapObjectArray;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.nodes.SubstrateCompressionNode;
import com.oracle.svm.core.graal.nodes.SubstrateNarrowOopStamp;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.imagelayer.ImageHeapRelocatableConstantSupport;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class ImageHeapRelocatableConstantFeature
extends ImageHeapRelocatableConstantSupport
implements InternalFeature {
    final Map<ImageHeapRelocatableConstant, Integer> constantToInfoMap = new ConcurrentHashMap<ImageHeapRelocatableConstant, Integer>();
    final AtomicInteger nextIndex = new AtomicInteger();
    JavaConstant finalizedImageHeapRelocatableConstantsArray;
    boolean sealed = false;

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return ImageLayerBuildingSupport.buildingImageLayer();
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ImageSingletons.add(ImageHeapRelocatableConstantSupport.class, (Object)this);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
        FeatureImpl.AfterAnalysisAccessImpl config = (FeatureImpl.AfterAnalysisAccessImpl)access;
        Object[] elements = new JavaConstant[this.constantToInfoMap.size()];
        this.constantToInfoMap.forEach((arg_0, arg_1) -> ImageHeapRelocatableConstantFeature.lambda$afterAnalysis$0((JavaConstant[])elements, arg_0, arg_1));
        this.finalizedImageHeapRelocatableConstantsArray = ImageHeapObjectArray.createUnbackedImageHeapArray((AnalysisType)config.getMetaAccess().lookupJavaType(Object[].class), (Object[])elements);
    }

    private JavaConstant getImageHeapRelocatableConstantsArray() {
        assert (this.finalizedImageHeapRelocatableConstantsArray != null);
        return this.finalizedImageHeapRelocatableConstantsArray;
    }

    private int getAssignedIndex(ImageHeapRelocatableConstant constant) {
        assert (this.constantToInfoMap.containsKey(constant));
        return this.constantToInfoMap.get(constant);
    }

    @Override
    void registerLoadableConstant(ImageHeapRelocatableConstant constant) {
        this.constantToInfoMap.computeIfAbsent(constant, key -> {
            assert (!this.sealed);
            return this.nextIndex.getAndIncrement();
        });
    }

    @Override
    FloatingNode emitLoadConstant(StructuredGraph graph, MetaAccessProvider metaAccess, ImageHeapRelocatableConstant constant) {
        long arrayOffset = ConfigurationValues.getObjectLayout().getArrayElementOffset(JavaKind.Object, this.getAssignedIndex(constant));
        JavaConstant array = this.getImageHeapRelocatableConstantsArray();
        OffsetAddressNode address = new OffsetAddressNode((ValueNode)ConstantNode.forConstant((JavaConstant)array, (MetaAccessProvider)metaAccess, (StructuredGraph)graph), (ValueNode)ConstantNode.forLong((long)arrayOffset));
        CompressEncoding compressEncoding = ReferenceAccess.singleton().getCompressEncoding();
        AbstractObjectStamp compressedStamp = SubstrateNarrowOopStamp.compressed((AbstractObjectStamp)StampFactory.forConstant((JavaConstant)constant, (MetaAccessProvider)metaAccess), compressEncoding);
        FloatingReadNode read = new FloatingReadNode((AddressNode)address, NamedLocationIdentity.FINAL_LOCATION, (MemoryKill)graph.start(), (Stamp)compressedStamp);
        return SubstrateCompressionNode.uncompress(graph, (ValueNode)graph.addOrUniqueWithInputs((Node)read), compressEncoding);
    }

    private static /* synthetic */ void lambda$afterAnalysis$0(JavaConstant[] elements, ImageHeapRelocatableConstant constantValue, Integer index) {
        assert (elements[index] == null) : elements[index];
        elements[index.intValue()] = constantValue;
    }
}

