/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionKind;
import com.oracle.svm.core.graal.nodes.LoweredDeadEndNode;
import com.oracle.svm.core.jni.JNIJavaCallWrapperHolder;
import com.oracle.svm.core.nodes.SubstrateIndirectCallTargetNode;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.jni.JNIGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.util.List;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.ObjectEqualsNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public class JNIJavaCallWrapperMethod
extends NonBytecodeMethod {
    private static final Constructor<InstantiationException> INSTANTIATION_EXCEPTION_CONSTRUCTOR = ReflectionUtil.lookupConstructor(InstantiationException.class, (Class[])new Class[0]);
    private final Signature targetSignature;

    public static ResolvedSignature<ResolvedJavaType> getGeneralizedSignatureForTarget(ResolvedJavaMethod targetMethod, MetaAccessProvider originalMetaAccess) {
        JavaKind[] paramKinds = targetMethod.getSignature().toParameterKinds(false);
        JavaKind returnKind = targetMethod.getSignature().getReturnKind();
        if (targetMethod.isConstructor()) {
            returnKind = JavaKind.Object;
        } else if (returnKind.isNumericInteger() || returnKind == JavaKind.Void) {
            returnKind = JavaKind.Long;
        }
        return ResolvedSignature.fromKinds((JavaKind[])paramKinds, (JavaKind)returnKind, (MetaAccessProvider)originalMetaAccess);
    }

    protected JNIJavaCallWrapperMethod(ResolvedSignature<ResolvedJavaType> targetSignature, MetaAccessProvider metaAccess, WordTypes wordTypes) {
        super("invoke_" + JNIGraphKit.signatureToIdentifier(targetSignature), true, metaAccess.lookupJavaType(JNIJavaCallWrapperHolder.class), (Signature)JNIJavaCallWrapperMethod.createSignature(targetSignature, metaAccess, wordTypes), JNIJavaCallWrapperHolder.getConstantPool(metaAccess));
        this.targetSignature = targetSignature;
    }

    private static ResolvedSignature<ResolvedJavaType> createSignature(Signature targetSignature, MetaAccessProvider originalMetaAccess, WordTypes wordTypes) {
        JavaKind wordKind = wordTypes.getWordKind();
        int count = targetSignature.getParameterCount(false);
        JavaKind[] args = new JavaKind[3 + count];
        args[0] = wordKind;
        args[1] = wordKind;
        args[2] = JavaKind.Boolean.getStackKind();
        for (int i = 0; i < count; ++i) {
            JavaKind kind = targetSignature.getParameterKind(i);
            if (kind.isObject()) {
                kind = wordKind;
            }
            args[3 + i] = kind.getStackKind();
        }
        JavaKind returnKind = targetSignature.getReturnKind();
        if (returnKind.isObject()) {
            returnKind = wordKind;
        }
        return ResolvedSignature.fromKinds((JavaKind[])args, (JavaKind)returnKind, (MetaAccessProvider)originalMetaAccess);
    }

    public ResolvedSignature<ResolvedJavaType> getSignature() {
        return (ResolvedSignature)super.getSignature();
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ValueNode[] args;
        JNIGraphKit kit = new JNIGraphKit(debug, providers, (ResolvedJavaMethod)method);
        ResolvedSignature invokeSignature = kit.getMetaAccess().getUniverse().lookup(this.targetSignature, this.getDeclaringClass());
        JavaKind wordKind = kit.getWordTypes().getWordKind();
        int slotIndex = 0;
        ValueNode receiverOrClassHandle = kit.loadLocal(slotIndex, wordKind);
        InvokeWithExceptionNode receiverOrClass = kit.invokeUnboxHandle(receiverOrClassHandle);
        ValueNode methodId = kit.loadLocal(slotIndex += wordKind.getSlotCount(), wordKind);
        slotIndex += wordKind.getSlotCount();
        ValueNode nonVirtual = kit.loadLocal(slotIndex, JavaKind.Boolean.getStackKind());
        ValueNode returnValue = this.createCall(kit, (ResolvedSignature<AnalysisType>)invokeSignature, methodId, (ValueNode)receiverOrClass, nonVirtual, args = JNIJavaCallWrapperMethod.loadAndUnboxArguments(kit, (ResolvedSignature<AnalysisType>)invokeSignature, slotIndex += JavaKind.Boolean.getStackKind().getSlotCount()));
        JavaKind returnKind = returnValue.getStackKind();
        if (returnKind.isObject()) {
            returnValue = kit.invokeBoxObjectInLocalHandle(returnValue);
        }
        kit.createReturn(returnValue, returnKind);
        return kit.finalizeGraph();
    }

    private ValueNode createCall(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, ValueNode methodId, ValueNode receiverOrClass, ValueNode nonVirtual, ValueNode[] args) {
        ValueNode declaringClass = kit.invokeGetDeclaringClassForMethod(methodId);
        if (!invokeSignature.getReturnKind().isObject()) {
            return JNIJavaCallWrapperMethod.createRegularMethodCall(kit, invokeSignature, methodId, receiverOrClass, nonVirtual, args);
        }
        InvokeWithExceptionNode newObjectAddress = kit.invokeGetNewObjectAddress(methodId);
        kit.startIf(IntegerEqualsNode.create((ValueNode)newObjectAddress, (ValueNode)kit.createWord(0L), (NodeView)NodeView.DEFAULT), ProfileData.BranchProbabilityData.unknown());
        kit.thenPart();
        ValueNode methodReturnValue = JNIJavaCallWrapperMethod.createRegularMethodCall(kit, invokeSignature, methodId, receiverOrClass, nonVirtual, args);
        kit.elsePart();
        ValueNode receiverOrCreatedObject = this.createNewObjectOrConstructorCall(kit, invokeSignature, methodId, declaringClass, (ValueNode)newObjectAddress, receiverOrClass, args);
        AbstractMergeNode merge = kit.endIf();
        return JNIJavaCallWrapperMethod.mergeValues(kit, merge, kit.bci(), methodReturnValue, receiverOrCreatedObject);
    }

    private static ValueNode createRegularMethodCall(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, ValueNode methodId, ValueNode receiverOrClass, ValueNode nonVirtual, ValueNode[] args) {
        InvokeWithExceptionNode methodAddress = kit.invokeGetJavaCallAddress(methodId, receiverOrClass, nonVirtual);
        InvokeWithExceptionNode isStatic = kit.invokeIsStaticMethod(methodId);
        kit.startIf(IntegerEqualsNode.create((ValueNode)isStatic, (ValueNode)kit.createInt(0), (NodeView)NodeView.DEFAULT), ProfileData.BranchProbabilityData.unknown());
        kit.thenPart();
        ValueNode nonstaticResult = JNIJavaCallWrapperMethod.createMethodCallWithReceiver(kit, invokeSignature, (ValueNode)methodAddress, receiverOrClass, args);
        kit.elsePart();
        ValueNode staticResult = JNIJavaCallWrapperMethod.createMethodCall(kit, (JavaType)invokeSignature.getReturnType(), invokeSignature.toParameterTypes(null), (ValueNode)methodAddress, args);
        AbstractMergeNode merge = kit.endIf();
        return JNIJavaCallWrapperMethod.mergeValues(kit, merge, kit.bci(), nonstaticResult, staticResult);
    }

    protected ValueNode createNewObjectOrConstructorCall(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, ValueNode methodId, ValueNode declaringClass, ValueNode newObjectAddress, ValueNode receiverOrClass, ValueNode[] args) {
        ObjectEqualsNode isNewObjectCall = (ObjectEqualsNode)kit.unique((FloatingNode)new ObjectEqualsNode(receiverOrClass, declaringClass));
        kit.startIf((LogicNode)isNewObjectCall, BranchProbabilityNode.FAST_PATH_PROFILE);
        kit.thenPart();
        ValueNode createdObject = JNIJavaCallWrapperMethod.createNewObjectCall(kit, invokeSignature, newObjectAddress, args);
        kit.elsePart();
        this.createConstructorCall(kit, invokeSignature, methodId, declaringClass, receiverOrClass, args);
        AbstractMergeNode merge = kit.endIf();
        return JNIJavaCallWrapperMethod.mergeValues(kit, merge, kit.bci(), createdObject, receiverOrClass);
    }

    protected ValueNode createConstructorCall(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, ValueNode methodId, ValueNode declaringClass, ValueNode receiverOrClass, ValueNode[] args) {
        InvokeWithExceptionNode methodAddress = kit.invokeGetJavaCallAddress(methodId, receiverOrClass, (ValueNode)kit.createInt(1));
        return JNIJavaCallWrapperMethod.createMethodCallWithReceiver(kit, invokeSignature, (ValueNode)methodAddress, receiverOrClass, args);
    }

    private static ValueNode createMethodCallWithReceiver(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, ValueNode methodAddress, ValueNode receiver, ValueNode[] args) {
        ValueNode[] argsWithReceiver = new ValueNode[1 + args.length];
        argsWithReceiver[0] = kit.maybeCreateExplicitNullCheck(receiver);
        System.arraycopy(args, 0, argsWithReceiver, 1, args.length);
        JavaType[] paramTypes = invokeSignature.toParameterTypes((JavaType)kit.getMetaAccess().lookupJavaType(Object.class));
        return JNIJavaCallWrapperMethod.createMethodCall(kit, (JavaType)invokeSignature.getReturnType(), paramTypes, methodAddress, argsWithReceiver);
    }

    private static ValueNode createNewObjectCall(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, ValueNode newObjectAddress, ValueNode[] args) {
        ConstantNode abstractTypeSentinel = kit.createWord(-1L);
        kit.startIf(IntegerEqualsNode.create((ValueNode)newObjectAddress, (ValueNode)abstractTypeSentinel, (NodeView)NodeView.DEFAULT), BranchProbabilityNode.SLOW_PATH_PROFILE);
        kit.thenPart();
        AnalysisMethod exceptionCtor = kit.getMetaAccess().lookupJavaMethod(INSTANTIATION_EXCEPTION_CONSTRUCTOR);
        AnalysisMethod throwMethod = FactoryMethodSupport.singleton().lookup(kit.getMetaAccess(), exceptionCtor, true);
        kit.createInvokeWithExceptionAndUnwind((ResolvedJavaMethod)throwMethod, CallTargetNode.InvokeKind.Static, kit.getFrameState(), kit.bci(), new ValueNode[0]);
        kit.append((Node)new LoweredDeadEndNode());
        kit.endIf();
        return JNIJavaCallWrapperMethod.createMethodCall(kit, (JavaType)invokeSignature.getReturnType(), invokeSignature.toParameterTypes(null), newObjectAddress, args);
    }

    private static ValueNode createMethodCall(JNIGraphKit kit, JavaType returnType, JavaType[] paramTypes, ValueNode methodAddress, ValueNode[] args) {
        StampPair returnStamp = StampFactory.forDeclaredType((Assumptions)kit.getAssumptions(), (JavaType)returnType, (boolean)false);
        SubstrateIndirectCallTargetNode callTarget = new SubstrateIndirectCallTargetNode(methodAddress, args, returnStamp, paramTypes, null, SubstrateCallingConventionKind.Java.toType(true), CallTargetNode.InvokeKind.Static);
        InvokeWithExceptionNode invoke = kit.startInvokeWithException((CallTargetNode)callTarget, kit.getFrameState(), kit.bci());
        kit.exceptionPart();
        ExceptionObjectNode exception = kit.exceptionObject();
        kit.append((Node)new UnwindNode((ValueNode)exception));
        kit.endInvokeWithException();
        return invoke;
    }

    private static ValueNode mergeValues(JNIGraphKit kit, AbstractMergeNode merge, int bci, ValueNode ... values) {
        Stamp stamp = StampTool.meet(List.of(values));
        ValueNode returnValue = (ValueNode)kit.getGraph().addWithoutUnique((Node)new ValuePhiNode(stamp, merge, values));
        JavaKind returnKind = returnValue.getStackKind();
        kit.getFrameState().push(returnKind, returnValue);
        merge.setStateAfter(kit.getFrameState().create(bci, (StateSplit)merge));
        kit.getFrameState().pop(returnKind);
        return returnValue;
    }

    private static ValueNode[] loadAndUnboxArguments(JNIGraphKit kit, ResolvedSignature<AnalysisType> invokeSignature, int firstSlotIndex) {
        int slotIndex = firstSlotIndex;
        int count = invokeSignature.getParameterCount(false);
        ValueNode[] args = new ValueNode[count];
        for (int i = 0; i < args.length; ++i) {
            JavaKind kind;
            AnalysisType type = (AnalysisType)invokeSignature.getParameterType(i);
            JavaKind loadKind = kind = type.getJavaKind();
            if (kind.isObject()) {
                loadKind = kit.getWordTypes().getWordKind();
            } else if (kind != kind.getStackKind()) {
                loadKind = kind.getStackKind();
            }
            ValueNode value = kit.loadLocal(slotIndex, loadKind);
            if (kind.isObject()) {
                value = kit.invokeUnboxHandle(value);
                value = kit.checkObjectType(value, (ResolvedJavaType)type, false);
            } else if (kind != loadKind) {
                value = kit.maskNumericIntBytes(value, kind);
            }
            args[i] = value;
            slotIndex += loadKind.getSlotCount();
        }
        return args;
    }

    public static class Factory {
        public JNIJavaCallWrapperMethod create(ResolvedSignature<ResolvedJavaType> targetSignature, MetaAccessProvider originalMetaAccess, WordTypes wordTypes) {
            return new JNIJavaCallWrapperMethod(targetSignature, originalMetaAccess, wordTypes);
        }

        public boolean canInvokeConstructorOnObject(ResolvedJavaMethod constructor, MetaAccessProvider originalMetaAccess) {
            return true;
        }
    }
}

