/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.hosted.DynamicAccessDetectionFeature;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.invoke.ConstantBootstraps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleProxies;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public class DynamicAccessDetectionPhase
extends BasePhase<CoreProviders> {
    private static final EconomicMap<Class<?>, Set<MethodSignature>> reflectionMethodSignatures = EconomicMap.create();
    private static final EconomicMap<Class<?>, Set<MethodSignature>> resourceMethodSignatures = EconomicMap.create();
    private static final EconomicMap<Class<?>, Set<MethodSignature>> foreignMethodSignatures = EconomicMap.create();
    private final DynamicAccessDetectionFeature dynamicAccessDetectionFeature = DynamicAccessDetectionFeature.instance();

    protected void run(StructuredGraph graph, CoreProviders context) {
        List callTargetNodes = graph.getNodes(MethodCallTargetNode.TYPE).snapshot();
        for (MethodCallTargetNode callTarget : callTargetNodes) {
            NodeSourcePosition nspToShow;
            AnalysisType callerClass = (AnalysisType)graph.method().getDeclaringClass();
            String sourceEntry = DynamicAccessDetectionPhase.getSourceEntry(callerClass);
            MethodInfo methodInfo = DynamicAccessDetectionPhase.getMethodInfo(callTarget.targetMethod());
            if (methodInfo == null || sourceEntry == null || (nspToShow = DynamicAccessDetectionPhase.getRootSourcePosition(callTarget.getNodeSourcePosition())) == null || this.dynamicAccessDetectionFeature.containsFoldEntry(nspToShow.getBCI(), nspToShow.getMethod())) continue;
            String callLocation = nspToShow.getMethod().asStackTraceElement(nspToShow.getBCI()).toString();
            this.dynamicAccessDetectionFeature.addCall(sourceEntry, methodInfo.accessKind(), methodInfo.signature(), callLocation);
        }
    }

    private static MethodInfo getMethodInfo(ResolvedJavaMethod method) {
        Class declaringClass = OriginalClassProvider.getJavaClass((JavaType)method.getDeclaringClass());
        if (!(reflectionMethodSignatures.containsKey((Object)declaringClass) || resourceMethodSignatures.containsKey((Object)declaringClass) || foreignMethodSignatures.containsKey((Object)declaringClass))) {
            return null;
        }
        String methodName = method.getName();
        Signature signature = method.getSignature();
        ArrayList<Class> paramList = new ArrayList<Class>();
        for (int i = 0; i < signature.getParameterCount(false); ++i) {
            JavaType type = signature.getParameterType(i, method.getDeclaringClass());
            paramList.add(OriginalClassProvider.getJavaClass((JavaType)type));
        }
        Class[] paramTypes = paramList.toArray(new Class[0]);
        MethodSignature methodSignature = new MethodSignature(methodName, paramTypes);
        if (reflectionMethodSignatures.containsKey((Object)declaringClass) && ((Set)reflectionMethodSignatures.get((Object)declaringClass)).contains(methodSignature)) {
            return new MethodInfo(DynamicAccessKind.Reflection, DynamicAccessDetectionPhase.getClassName(declaringClass) + "#" + String.valueOf(methodSignature));
        }
        if (resourceMethodSignatures.containsKey((Object)declaringClass) && ((Set)resourceMethodSignatures.get((Object)declaringClass)).contains(methodSignature)) {
            return new MethodInfo(DynamicAccessKind.Resource, DynamicAccessDetectionPhase.getClassName(declaringClass) + "#" + String.valueOf(methodSignature));
        }
        if (foreignMethodSignatures.containsKey((Object)declaringClass) && ((Set)foreignMethodSignatures.get((Object)declaringClass)).contains(methodSignature)) {
            return new MethodInfo(DynamicAccessKind.Foreign, DynamicAccessDetectionPhase.getClassName(declaringClass) + "#" + String.valueOf(methodSignature));
        }
        return null;
    }

    private static String getClassName(Class<?> clazz) {
        return clazz.getName().replace('$', '.');
    }

    private static String getSourceEntry(AnalysisType callerClass) {
        EconomicSet<String> sourceEntries = DynamicAccessDetectionFeature.instance().getSourceEntries();
        try {
            String moduleName;
            URL entryPathURL;
            CodeSource entryPathSource = callerClass.getJavaClass().getProtectionDomain().getCodeSource();
            if (entryPathSource != null && (entryPathURL = entryPathSource.getLocation()) != null) {
                String classPathEntry = entryPathURL.toURI().getPath();
                if (classPathEntry.endsWith(File.separator)) {
                    classPathEntry = classPathEntry.substring(0, classPathEntry.length() - 1);
                }
                if (sourceEntries.contains((Object)classPathEntry)) {
                    return classPathEntry;
                }
            }
            if ((moduleName = callerClass.getJavaClass().getModule().getName()) != null && sourceEntries.contains((Object)moduleName)) {
                return moduleName;
            }
            String packageName = callerClass.getJavaClass().getPackageName();
            if (sourceEntries.contains((Object)packageName)) {
                return packageName;
            }
            return null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static NodeSourcePosition getRootSourcePosition(NodeSourcePosition nodeSourcePosition) {
        NodeSourcePosition rootNodeSourcePosition;
        for (rootNodeSourcePosition = nodeSourcePosition; rootNodeSourcePosition != null && rootNodeSourcePosition.getCaller() != null; rootNodeSourcePosition = rootNodeSourcePosition.getCaller()) {
        }
        return rootNodeSourcePosition;
    }

    public static void clearMethodSignatures() {
        reflectionMethodSignatures.clear();
        resourceMethodSignatures.clear();
        foreignMethodSignatures.clear();
    }

    static {
        reflectionMethodSignatures.put(Class.class, Set.of(new MethodSignature("forName", String.class), new MethodSignature("forName", String.class, Boolean.TYPE, ClassLoader.class), new MethodSignature("forName", Module.class, String.class), new MethodSignature("getClasses", new Class[0]), new MethodSignature("getDeclaredClasses", new Class[0]), new MethodSignature("getConstructor", Class[].class), new MethodSignature("getConstructors", new Class[0]), new MethodSignature("getDeclaredConstructor", Class[].class), new MethodSignature("getDeclaredConstructors", new Class[0]), new MethodSignature("getField", String.class), new MethodSignature("getFields", new Class[0]), new MethodSignature("getDeclaredField", String.class), new MethodSignature("getDeclaredFields", new Class[0]), new MethodSignature("getMethod", String.class, Class[].class), new MethodSignature("getMethods", new Class[0]), new MethodSignature("getDeclaredMethod", String.class, Class[].class), new MethodSignature("getDeclaredMethods", new Class[0]), new MethodSignature("getNestMembers", new Class[0]), new MethodSignature("getPermittedSubclasses", new Class[0]), new MethodSignature("getRecordComponents", new Class[0]), new MethodSignature("getSigners", new Class[0]), new MethodSignature("arrayType", new Class[0]), new MethodSignature("newInstance", new Class[0])));
        reflectionMethodSignatures.put(Field.class, Set.of(new MethodSignature("get", Object.class), new MethodSignature("set", Object.class, Object.class), new MethodSignature("getBoolean", Object.class), new MethodSignature("setBoolean", Object.class, Boolean.TYPE), new MethodSignature("getByte", Object.class), new MethodSignature("setByte", Object.class, Byte.TYPE), new MethodSignature("getShort", Object.class), new MethodSignature("setShort", Object.class, Short.TYPE), new MethodSignature("getChar", Object.class), new MethodSignature("setChar", Object.class, Character.TYPE), new MethodSignature("getInt", Object.class), new MethodSignature("setInt", Object.class, Integer.TYPE), new MethodSignature("getLong", Object.class), new MethodSignature("setLong", Object.class, Long.TYPE), new MethodSignature("getFloat", Object.class), new MethodSignature("setFloat", Object.class, Float.TYPE), new MethodSignature("getDouble", Object.class), new MethodSignature("setDouble", Object.class, Double.TYPE)));
        reflectionMethodSignatures.put(Method.class, Set.of(new MethodSignature("invoke", Object.class, Object[].class)));
        reflectionMethodSignatures.put(MethodHandles.Lookup.class, Set.of(new MethodSignature("findClass", String.class), new MethodSignature("findVirtual", Class.class, String.class, MethodType.class), new MethodSignature("findStatic", Class.class, String.class, MethodType.class), new MethodSignature("findConstructor", Class.class, MethodType.class), new MethodSignature("findSpecial", Class.class, String.class, MethodType.class, Class.class), new MethodSignature("findGetter", Class.class, String.class, Class.class), new MethodSignature("findSetter", Class.class, String.class, Class.class), new MethodSignature("findStaticGetter", Class.class, String.class, Class.class), new MethodSignature("findStaticSetter", Class.class, String.class, Class.class), new MethodSignature("findVarHandle", Class.class, String.class, Class.class), new MethodSignature("findStaticVarHandle", Class.class, String.class, Class.class), new MethodSignature("unreflect", Method.class), new MethodSignature("unreflectSpecial", Method.class, Class.class), new MethodSignature("unreflectConstructor", Constructor.class), new MethodSignature("unreflectGetter", Field.class), new MethodSignature("unreflectSetter", Field.class), new MethodSignature("unreflectVarHandle", Field.class)));
        reflectionMethodSignatures.put(ClassLoader.class, Set.of(new MethodSignature("loadClass", String.class), new MethodSignature("findLoadedClass", String.class), new MethodSignature("findSystemClass", String.class), new MethodSignature("findBootstrapClassOrNull", String.class)));
        reflectionMethodSignatures.put(Array.class, Set.of(new MethodSignature("newInstance", Class.class, Integer.TYPE), new MethodSignature("newInstance", Class.class, int[].class)));
        reflectionMethodSignatures.put(Constructor.class, Set.of(new MethodSignature("newInstance", Object[].class)));
        reflectionMethodSignatures.put(ConstantBootstraps.class, Set.of(new MethodSignature("getStaticFinal", MethodHandles.Lookup.class, String.class, Class.class, Class.class), new MethodSignature("getStaticFinal", MethodHandles.Lookup.class, String.class, Class.class), new MethodSignature("fieldVarHandle", MethodHandles.Lookup.class, String.class, Class.class, Class.class, Class.class), new MethodSignature("staticFieldVarHandle", MethodHandles.Lookup.class, String.class, Class.class, Class.class, Class.class)));
        reflectionMethodSignatures.put(VarHandle.VarHandleDesc.class, Set.of(new MethodSignature("resolveConstantDesc", MethodHandles.Lookup.class)));
        reflectionMethodSignatures.put(MethodHandleProxies.class, Set.of(new MethodSignature("asInterfaceInstance", Class.class, MethodHandle.class)));
        reflectionMethodSignatures.put(ObjectOutputStream.class, Set.of(new MethodSignature("writeObject", Object.class), new MethodSignature("writeUnshared", Object.class)));
        reflectionMethodSignatures.put(ObjectInputStream.class, Set.of(new MethodSignature("resolveClass", ObjectStreamClass.class), new MethodSignature("resolveProxyClass", String[].class), new MethodSignature("readObject", new Class[0]), new MethodSignature("readUnshared", new Class[0])));
        reflectionMethodSignatures.put(ObjectStreamClass.class, Set.of(new MethodSignature("lookup", Class.class)));
        reflectionMethodSignatures.put(Proxy.class, Set.of(new MethodSignature("getProxyClass", ClassLoader.class, Class[].class), new MethodSignature("newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class)));
        resourceMethodSignatures.put(ClassLoader.class, Set.of(new MethodSignature("getResource", String.class), new MethodSignature("getResources", String.class), new MethodSignature("getResourceAsStream", String.class), new MethodSignature("getSystemResource", String.class), new MethodSignature("getSystemResources", String.class), new MethodSignature("getSystemResourceAsStream", String.class)));
        resourceMethodSignatures.put(Module.class, Set.of(new MethodSignature("getResourceAsStream", String.class)));
        resourceMethodSignatures.put(Class.class, Set.of(new MethodSignature("getResource", String.class), new MethodSignature("getResourceAsStream", String.class)));
        foreignMethodSignatures.put(Linker.class, Set.of(new MethodSignature("downcallHandle", MemorySegment.class, FunctionDescriptor.class, Linker.Option[].class), new MethodSignature("downcallHandle", FunctionDescriptor.class, Linker.Option[].class), new MethodSignature("upcallStub", MethodHandle.class, FunctionDescriptor.class, Arena.class, Linker.Option[].class)));
    }

    public record MethodInfo(DynamicAccessKind accessKind, String signature) {
    }

    public static enum DynamicAccessKind {
        Reflection("reflection-calls.json"),
        Resource("resource-calls.json"),
        Foreign("foreign-calls.json");

        public final String fileName;

        private DynamicAccessKind(String fileName) {
            this.fileName = fileName;
        }
    }

    private static class MethodSignature {
        private final String name;
        private final Class<?>[] paramTypes;

        MethodSignature(String name, Class<?> ... paramTypes) {
            this.name = name;
            this.paramTypes = paramTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodSignature)) {
                return false;
            }
            MethodSignature that = (MethodSignature)o;
            return this.name.equals(that.name) && Arrays.equals(this.paramTypes, that.paramTypes);
        }

        public int hashCode() {
            return Objects.hash(this.name, Arrays.hashCode(this.paramTypes));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append("(");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                Class<?> param;
                if (i > 0) {
                    sb.append(", ");
                }
                if ((param = this.paramTypes[i]).isArray()) {
                    sb.append(param.getComponentType().getName()).append("[]");
                } else {
                    sb.append(param.getName());
                }
                if (!param.getTypeName().contains("?")) continue;
                sb.append("<?>");
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

