/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.BoxedRelocatedPointer;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.code.SubstrateCompilationIdentifier;
import com.oracle.svm.core.graal.replacements.SubstrateGraphKit;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.UnwindNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.IsNullNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HostedGraphKit
extends SubstrateGraphKit {
    public HostedGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method) {
        super(debug, method, (Providers)providers, providers.getGraphBuilderPlugins(), new SubstrateCompilationIdentifier(), ((AnalysisMetaAccess)providers.getMetaAccess()).getUniverse().hostVM().recordInlinedMethods((AnalysisMethod)method));
    }

    public AnalysisMetaAccess getMetaAccess() {
        return (AnalysisMetaAccess)super.getMetaAccess();
    }

    public void emitEnsureInitializedCall(ResolvedJavaType type) {
        boolean requiresInitializationForTypeReached = ClassInitializationSupport.singleton().requiresInitializationNodeForTypeReached(type);
        if (requiresInitializationForTypeReached || EnsureClassInitializedNode.needsRuntimeInitialization(this.graph.method().getDeclaringClass(), type)) {
            ConstantNode hub = this.createConstant((Constant)this.getConstantReflection().asJavaClass(type), JavaKind.Object);
            this.appendWithUnwind(new EnsureClassInitializedNode((ValueNode)hub));
        }
    }

    public <T extends WithExceptionNode> T appendWithUnwind(T withExceptionNode) {
        return this.appendWithUnwind(withExceptionNode, this.bci());
    }

    public LoadFieldNode createLoadFieldNode(ConstantNode receiver, Class<BoxedRelocatedPointer> clazz, String fieldName) {
        try {
            AnalysisField field = this.getMetaAccess().lookupJavaField(clazz.getDeclaredField(fieldName));
            return LoadFieldNode.createOverrideStamp((StampPair)StampPair.createSingle((Stamp)this.wordStamp((ResolvedJavaType)field.getType())), (ValueNode)receiver, (ResolvedJavaField)field);
        }
        catch (NoSuchFieldException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public GuardingNode createCheckThrowingBytecodeException(LogicNode condition, boolean failOnTrue, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        ProfileData.BranchProbabilityData trueProbability = failOnTrue ? BranchProbabilityNode.SLOW_PATH_PROFILE : BranchProbabilityNode.FAST_PATH_PROFILE;
        IfNode ifNode = this.startIf(condition, trueProbability);
        if (failOnTrue) {
            this.thenPart();
        } else {
            this.elsePart();
        }
        BytecodeExceptionNode exception = this.createBytecodeExceptionObjectNode(exceptionKind, true, arguments);
        this.append((Node)new UnwindNode((ValueNode)exception));
        AbstractMergeNode merge = this.endIf();
        assert (merge == null);
        return failOnTrue ? ifNode.falseSuccessor() : ifNode.trueSuccessor();
    }

    public BytecodeExceptionNode createBytecodeExceptionObjectNode(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, boolean rethrow, ValueNode ... arguments) {
        BytecodeExceptionNode exception = (BytecodeExceptionNode)this.append((Node)new BytecodeExceptionNode((MetaAccessProvider)this.getMetaAccess(), exceptionKind, arguments));
        this.setStateAfterException(this.getFrameState(), this.bci(), (StateSplit)exception, rethrow);
        return exception;
    }

    public ValueNode maybeCreateExplicitNullCheck(ValueNode object) {
        assert (object.stamp(NodeView.DEFAULT).isPointerStamp());
        if (StampTool.isPointerNonNull((ValueNode)object)) {
            return object;
        }
        this.createCheckThrowingBytecodeException(IsNullNode.create((ValueNode)object), true, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ValueNode[0]);
        return (ValueNode)this.append((Node)PiNode.create((ValueNode)object, (Stamp)StampFactory.objectNonNull()));
    }

    public List<ValueNode> loadArrayElements(ValueNode array, JavaKind[] elementKinds, int length) {
        assert (elementKinds.length == length);
        ArrayList<ValueNode> result = new ArrayList<ValueNode>();
        for (int i = 0; i < length; ++i) {
            ValueNode load = this.createLoadIndexed(array, i, elementKinds[i], null);
            this.append((Node)load);
            result.add(load);
        }
        return result;
    }

    public List<ValueNode> loadArrayElements(ValueNode array, JavaKind elementKind, int length) {
        Object[] elementKinds = new JavaKind[length];
        Arrays.fill(elementKinds, elementKind);
        return this.loadArrayElements(array, (JavaKind[])elementKinds, length);
    }
}

