/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.objectfile.BasicProgbitsSectionImpl;
import com.oracle.objectfile.ObjectFile;
import com.oracle.objectfile.SectionName;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.hosted.image.NativeImage;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.pltgot.PLTStubGenerator;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public class PLTSectionSupport {
    public static final SectionName SVM_PLT_SECTION_NAME = new SectionName.ProgbitsSectionName("svm_plt");
    private final Map<SharedMethod, Integer> methodPLTStubStart = new HashMap<SharedMethod, Integer>();
    private final Map<SharedMethod, Integer> methodPLTStubResolverOffset = new HashMap<SharedMethod, Integer>();
    private ObjectFile.ProgbitsSectionImpl pltBufferImpl;
    private PLTStubGenerator stubGenerator;

    public static String pltSymbolNameForMethod(ResolvedJavaMethod method) {
        return "svm_plt_" + NativeImage.localSymbolNameForMethod(method);
    }

    public PLTSectionSupport(PLTStubGenerator stubGenerator) {
        this.stubGenerator = stubGenerator;
    }

    void createPLTSection(SharedMethod[] got, ObjectFile objectFile, SubstrateBackend substrateBackend) {
        byte[] pltCode = this.stubGenerator.generatePLT(got, substrateBackend);
        int pltSectionSize = pltCode.length;
        RelocatableBuffer pltBuffer = new RelocatableBuffer(pltSectionSize, objectFile.getByteOrder());
        this.pltBufferImpl = new BasicProgbitsSectionImpl(pltBuffer.getBackingArray());
        String name = SVM_PLT_SECTION_NAME.getFormatDependentName(objectFile.getFormat());
        ObjectFile.Section pltSection = objectFile.newProgbitsSection(name, objectFile.getPageSize(), false, true, this.pltBufferImpl);
        pltBuffer.getByteBuffer().put(pltCode, 0, pltSectionSize);
        objectFile.createDefinedSymbol(pltSection.getName(), (ObjectFile.Element)pltSection, 0L, 0, true, false);
        for (SharedMethod method : got) {
            HostedMethod m = (HostedMethod)method;
            int offset = this.getMethodPLTStubStart(m);
            objectFile.createDefinedSymbol(PLTSectionSupport.pltSymbolNameForMethod(m), (ObjectFile.Element)pltSection, (long)offset, ConfigurationValues.getTarget().wordSize, true, SubstrateOptions.InternalSymbolsAreGlobal.getValue().booleanValue());
        }
    }

    void markRelocationToPLTStub(ObjectFile.ProgbitsSectionImpl section, int offset, ObjectFile.RelocationKind relocationKind, SharedMethod target, long addend) {
        section.markRelocationSite(offset, relocationKind, PLTSectionSupport.pltSymbolNameForMethod(target), addend);
    }

    void markRelocationToPLTResolverJump(ObjectFile.ProgbitsSectionImpl section, int offset, ObjectFile.RelocationKind relocationKind, SharedMethod target) {
        assert (this.methodPLTStubResolverOffset.get(target) != null) : "Trying to mark a relocation to the `resolver-jump` part of the plt stub for a target that doesn't have a plt stub: " + String.valueOf(target);
        section.markRelocationSite(offset, relocationKind, PLTSectionSupport.pltSymbolNameForMethod(target), (long)this.methodPLTStubResolverOffset.get(target).intValue());
    }

    void markResolverMethodPatch(HostedMethod resolverMethod) {
        this.stubGenerator.markResolverMethodPatch(this.pltBufferImpl, resolverMethod);
    }

    public void recordMethodPLTStubStart(SharedMethod method, int offset) {
        this.methodPLTStubStart.put(method, offset);
    }

    public void recordMethodPLTStubResolverOffset(SharedMethod method, int resolverOffset) {
        this.methodPLTStubResolverOffset.put(method, resolverOffset);
    }

    private int getMethodPLTStubStart(SharedMethod method) {
        return this.methodPLTStubStart.get(method);
    }
}

