/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class DynamicHubPlugin
implements NodePlugin {
    public boolean handleNewInstance(GraphBuilderContext b, ResolvedJavaType type) {
        if (b.getMetaAccess().lookupJavaType(DynamicHub.class).isAssignableFrom(type)) {
            // empty if block
        }
        return false;
    }

    public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
        ResolvedJavaType dynamicHubType = b.getMetaAccess().lookupJavaType(DynamicHub.class);
        if (dynamicHubType.isAssignableFrom(field.getDeclaringClass())) {
            throw VMError.shouldNotReachHere("Stores to DynamicHub are not permitted, see documentation of DynamicHub.");
        }
        return false;
    }
}

