/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.aarch64.AArch64InterpreterStubs;
import com.oracle.svm.core.graal.amd64.AMD64InterpreterStubs;
import com.oracle.svm.core.graal.code.InterpreterAccessStubData;
import com.oracle.svm.core.interpreter.InterpreterSupport;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.interpreter.AArch64InterpreterStubSection;
import com.oracle.svm.interpreter.AMD64InterpreterStubSection;
import com.oracle.svm.interpreter.BuildTimeInterpreterUniverse;
import com.oracle.svm.interpreter.Interpreter;
import com.oracle.svm.interpreter.InterpreterDirectives;
import com.oracle.svm.interpreter.InterpreterDirectivesSupport;
import com.oracle.svm.interpreter.InterpreterDirectivesSupportImpl;
import com.oracle.svm.interpreter.InterpreterMethodPointerHolder;
import com.oracle.svm.interpreter.InterpreterStubSection;
import com.oracle.svm.interpreter.InterpreterSupportImpl;
import com.oracle.svm.interpreter.debug.DebuggerEventsFeature;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugin;
import jdk.graal.compiler.nodes.graphbuilderconf.InvocationPlugins;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.Local;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.AnnotationAccess;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class InterpreterFeature
implements InternalFeature {
    private AnalysisMethod leaveStub;

    static boolean executableByInterpreter(AnalysisMethod m) {
        if (AnnotationAccess.getAnnotation((AnnotatedElement)m, CFunction.class) != null) {
            return false;
        }
        if (AnnotationAccess.getAnnotation((AnnotatedElement)m, CEntryPoint.class) != null) {
            return false;
        }
        Uninterruptible uninterruptible = (Uninterruptible)AnnotationAccess.getAnnotation((AnnotatedElement)m, Uninterruptible.class);
        return uninterruptible == null || uninterruptible.mayBeInlined() && !uninterruptible.callerMustBe();
        {
        }
    }

    public static boolean callableByInterpreter(ResolvedJavaMethod m, MetaAccessProvider metaAccess) {
        if (AnnotationAccess.getAnnotation((AnnotatedElement)m, Fold.class) != null) {
            return false;
        }
        ResolvedJavaType wordBaseType = metaAccess.lookupJavaType(WordBase.class);
        if (wordBaseType.isAssignableFrom(m.getDeclaringClass())) {
            return false;
        }
        Signature signature = m.getSignature();
        if (wordBaseType.isAssignableFrom(signature.getReturnType(m.getDeclaringClass()).resolve(m.getDeclaringClass()))) {
            return false;
        }
        for (int i = 0; i < signature.getParameterCount(false); ++i) {
            if (!wordBaseType.isAssignableFrom(signature.getParameterType(i, null).resolve(m.getDeclaringClass()))) continue;
            return false;
        }
        return true;
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(DebuggerEventsFeature.class);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), InterpreterDirectives.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin(this, "inInterpreter", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, (ValueNode)new InInterpreterNode());
                return true;
            }
        });
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (Platform.includedIn(Platform.AARCH64.class)) {
            ImageSingletons.add(InterpreterStubSection.class, (Object)new AArch64InterpreterStubSection());
            ImageSingletons.add(InterpreterAccessStubData.class, (Object)new AArch64InterpreterStubs.AArch64InterpreterAccessStubData());
        } else if (Platform.includedIn(Platform.AMD64.class)) {
            ImageSingletons.add(InterpreterStubSection.class, (Object)new AMD64InterpreterStubSection());
            ImageSingletons.add(InterpreterAccessStubData.class, (Object)new AMD64InterpreterStubs.AMD64InterpreterAccessStubData());
        } else {
            throw VMError.unsupportedFeature("Platform not supported yet: " + String.valueOf(ImageSingletons.lookup(Platform.class)));
        }
    }

    private static int findLocalSlotByName(String localName, Local[] locals) {
        for (Local local : locals) {
            if (!localName.equals(local.getName())) continue;
            return local.getSlot();
        }
        throw new NoSuchElementException(localName);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl accessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        BuildTimeInterpreterUniverse.freshSingletonInstance();
        AnalysisMethod interpreterRoot = accessImpl.getMetaAccess().lookupJavaType(Interpreter.Root.class).getDeclaredMethods(false)[0];
        accessImpl.registerAsRoot(interpreterRoot, true, "interpreter main loop", new MultiMethod.MultiMethodKey[0]);
        LocalVariableTable interpreterVariableTable = interpreterRoot.getLocalVariableTable();
        int interpretedMethodSlot = InterpreterFeature.findLocalSlotByName("method", interpreterVariableTable.getLocalsAt(0));
        int interpreterFrameSlot = InterpreterFeature.findLocalSlotByName("frame", interpreterVariableTable.getLocalsAt(0));
        int bciSlot = InterpreterFeature.findLocalSlotByName("curBCI", interpreterVariableTable.getLocals());
        ImageSingletons.add(InterpreterSupport.class, (Object)new InterpreterSupportImpl(bciSlot, interpretedMethodSlot, interpreterFrameSlot));
        ImageSingletons.add(InterpreterDirectivesSupport.class, (Object)new InterpreterDirectivesSupportImpl());
        ImageSingletons.add(InterpreterMethodPointerHolder.class, (Object)new InterpreterMethodPointerHolder());
        SubstrateCompilationDirectives.singleton().registerFrameInformationRequired(interpreterRoot);
        Method leaveMethod = ReflectionUtil.lookupMethod(InterpreterStubSection.class, (String)"leaveInterpreterStub", (Class[])new Class[]{CFunctionPointer.class, Pointer.class, Long.TYPE, Long.TYPE});
        this.leaveStub = accessImpl.getMetaAccess().lookupJavaMethod((Executable)leaveMethod);
        accessImpl.registerAsRoot(this.leaveStub, true, "low level entry point", new MultiMethod.MultiMethodKey[0]);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        FeatureImpl.BeforeCompilationAccessImpl accessImpl = (FeatureImpl.BeforeCompilationAccessImpl)access;
        accessImpl.registerAsImmutable(InterpreterMethodPointerHolder.singleton());
        accessImpl.registerAsImmutable(InterpreterSupport.singleton());
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl accessImpl = (FeatureImpl.AfterCompilationAccessImpl)access;
        HostedMethod hLeaveStub = accessImpl.getUniverse().lookup((JavaMethod)this.leaveStub);
        int leaveStubLength = accessImpl.getCompilations().get((Object)hLeaveStub).result.getTargetCodeSize();
        InterpreterSupport.setLeaveStubPointer(new MethodPointer(hLeaveStub), leaveStubLength);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    public static final class InInterpreterNode
    extends FloatingNode
    implements Lowerable {
        public static final NodeClass<InInterpreterNode> TYPE = NodeClass.create(InInterpreterNode.class);

        public InInterpreterNode() {
            super(TYPE, StampFactory.forKind((JavaKind)JavaKind.Boolean));
        }

        public void lower(LoweringTool tool) {
            this.replaceAtUsagesAndDelete(this.graph().unique((Node)ConstantNode.forBoolean((boolean)false)));
        }
    }
}

