/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.InterpreterConstantPool;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaField;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaMethod;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedJavaType;
import com.oracle.svm.interpreter.metadata.InterpreterResolvedObjectType;
import com.oracle.svm.interpreter.metadata.InterpreterUniverse;
import com.oracle.svm.interpreter.metadata.Lazy;
import com.oracle.svm.interpreter.metadata.ReferenceConstant;
import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.CRC32C;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class InterpreterUniverseImpl
implements InterpreterUniverse {
    static final int MAGIC = -443030192;
    private static final boolean LOGGING = false;
    private final List<InterpreterResolvedJavaType> types;
    private final List<InterpreterResolvedJavaField> fields;
    private final List<InterpreterResolvedJavaMethod> methods;
    private final Lazy<Map<Class<?>, InterpreterResolvedJavaType>> classToType = Lazy.of(() -> this.getTypes().stream().collect(Collectors.toMap(InterpreterResolvedJavaType::getJavaClass, Function.identity())));
    private final Lazy<Map<InterpreterResolvedJavaType, List<InterpreterResolvedJavaField>>> allDeclaredFields = Lazy.of(() -> this.getFields().stream().collect(Collectors.groupingBy(InterpreterResolvedJavaField::getDeclaringClass)));
    private final Lazy<Map<InterpreterResolvedJavaType, List<InterpreterResolvedJavaMethod>>> allDeclaredMethods = Lazy.of(() -> this.getMethods().stream().collect(Collectors.groupingBy(InterpreterResolvedJavaMethod::getDeclaringClass)));
    private final Lazy<InterpreterResolvedJavaMethod[]> methodESTOffsetTable = Lazy.of(() -> InterpreterUniverseImpl.createMethodTable(this.getMethods()));
    private final Lazy<Map<InterpreterResolvedJavaMethod, Integer>> methodInverseTable = Lazy.of(() -> InterpreterUniverseImpl.createInverseTable(this.getMethods()));
    private final Lazy<Map<InterpreterResolvedJavaType, Integer>> typeInverseTable = Lazy.of(() -> InterpreterUniverseImpl.createInverseTable(this.getTypes()));
    private final Lazy<Map<InterpreterResolvedJavaField, Integer>> fieldInverseTable = Lazy.of(() -> InterpreterUniverseImpl.createInverseTable(this.getFields()));
    private final Lazy<InterpreterResolvedJavaMethod[]> methodIdMapping = Lazy.of(() -> InterpreterUniverseImpl.createMethodIdMapping((List<InterpreterResolvedJavaMethod>)this.getMethods()));

    public InterpreterUniverseImpl(Collection<InterpreterResolvedJavaType> types, Collection<InterpreterResolvedJavaField> fields, Collection<InterpreterResolvedJavaMethod> methods) {
        this.types = List.copyOf(types);
        this.fields = List.copyOf(fields);
        this.methods = List.copyOf(methods);
    }

    private static void consumeMagic(DataInput in) throws IOException {
        int header = in.readInt();
        if (header != -443030192) {
            throw new IllegalStateException("Invalid header");
        }
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void saveTo(SerializationContext.Builder builder, Path filePath) throws IOException {
        int totalBytesWritten = 0;
        long startNanos = System.nanoTime();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(filePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING)));){
            out.writeInt(-443030192);
            SerializationContext.Writer writer = builder.buildWriter();
            for (InterpreterResolvedJavaType type : this.getTypes()) {
                writer.writeValue(out, type);
            }
            for (InterpreterResolvedJavaField field : this.getFields()) {
                writer.writeValue(out, field);
            }
            for (InterpreterResolvedJavaMethod method : this.getMethods()) {
                writer.writeValue(out, method);
            }
            for (InterpreterResolvedJavaMethod method : this.getMethods()) {
                writer.writeValue(out, method.inlinedBy);
                InterpreterResolvedJavaMethod oneImplementation = method.getOneImplementation();
                writer.writeReference(out, oneImplementation);
            }
            for (InterpreterResolvedJavaType type : this.getTypes()) {
                if (!(type instanceof InterpreterResolvedObjectType)) continue;
                InterpreterResolvedObjectType objectType = (InterpreterResolvedObjectType)type;
                if (type.isArray()) continue;
                writer.writeValue(out, objectType.getConstantPool());
                if (objectType.getVtableHolder() == null) continue;
                writer.writeValue(out, objectType.getVtableHolder());
            }
            totalBytesWritten = out.size();
        }
        long elapsedNanos = System.nanoTime() - startNanos;
    }

    public static String toHexString(int value) {
        String result = Integer.toHexString(value);
        return "0".repeat(8 - result.length()) + result;
    }

    public static int computeCRC32(Path filePath) throws IOException {
        CRC32C checksum = new CRC32C();
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(filePath, StandardOpenOption.READ));){
            byte[] buf = new byte[16384];
            int bytesRead = 0;
            while ((bytesRead = ((InputStream)in).read(buf)) > 0) {
                checksum.update(buf, 0, bytesRead);
            }
        }
        return (int)checksum.getValue();
    }

    public static InterpreterUniverseImpl loadFrom(SerializationContext.Builder builder, boolean opaqueConstants, String hashString, Path filePath) throws IOException {
        long startNanos = System.nanoTime();
        if (hashString != null) {
            String[] parts = hashString.split(":");
            String algorithm = parts[0];
            String expectedHexChecksum = parts[1];
            if ("crc32".equalsIgnoreCase(algorithm)) {
                int crc32 = InterpreterUniverseImpl.computeCRC32(filePath);
                String actualHexChecksum = InterpreterUniverseImpl.toHexString(crc32);
                if (!expectedHexChecksum.equals(actualHexChecksum)) {
                    throw new IllegalArgumentException("Invalid " + algorithm + " verification for metadata file: " + String.valueOf(filePath) + " expected: " + expectedHexChecksum + " actual: " + actualHexChecksum);
                }
            } else {
                throw VMError.unimplemented("Metadata verification with: " + algorithm);
            }
        }
        try (DataInputStream dataInput = new DataInputStream(new BufferedInputStream(Files.newInputStream(filePath, StandardOpenOption.READ)));){
            ArrayList<InterpreterResolvedJavaType> types = new ArrayList<InterpreterResolvedJavaType>();
            ArrayList<InterpreterResolvedJavaField> fields = new ArrayList<InterpreterResolvedJavaField>();
            ArrayList<InterpreterResolvedJavaMethod> methods = new ArrayList<InterpreterResolvedJavaMethod>();
            InterpreterUniverseImpl.consumeMagic(dataInput);
            SerializationContext.Reader reader = opaqueConstants ? builder.registerReader(true, ReferenceConstant.class, (context, in) -> {
                boolean inNativeHeap = in.readBoolean();
                if (inNativeHeap) {
                    long nativeHeapOffset = in.readLong();
                    return ReferenceConstant.createFromHeapOffset(nativeHeapOffset);
                }
                Object ref = context.readReference(in);
                return ReferenceConstant.createFromReference(ref);
            }).buildReader() : builder.buildReader();
            try {
                while (true) {
                    Object holder;
                    Object value;
                    if ((value = reader.readValue(dataInput)) instanceof InterpreterResolvedJavaType) {
                        InterpreterResolvedJavaType type = (InterpreterResolvedJavaType)value;
                        types.add(type);
                        continue;
                    }
                    if (value instanceof InterpreterResolvedJavaField) {
                        InterpreterResolvedJavaField field = (InterpreterResolvedJavaField)value;
                        fields.add(field);
                        continue;
                    }
                    if (value instanceof InterpreterResolvedJavaMethod) {
                        InterpreterResolvedJavaMethod method = (InterpreterResolvedJavaMethod)value;
                        methods.add(method);
                        continue;
                    }
                    if (value instanceof InterpreterConstantPool) {
                        InterpreterConstantPool constantPool = (InterpreterConstantPool)value;
                        holder = constantPool.getHolder();
                        VMError.guarantee(!holder.isArray());
                        ((InterpreterResolvedObjectType)holder).setConstantPool(constantPool);
                        continue;
                    }
                    if (value instanceof InterpreterResolvedObjectType.VTableHolder) {
                        InterpreterResolvedObjectType.VTableHolder vTableHolder = (InterpreterResolvedObjectType.VTableHolder)value;
                        holder = vTableHolder.holder;
                        ((InterpreterResolvedObjectType)holder).setVtable(vTableHolder.vtable);
                        continue;
                    }
                    if (!(value instanceof InterpreterResolvedJavaMethod.InlinedBy)) continue;
                    InterpreterResolvedJavaMethod.InlinedBy inlinedBy = (InterpreterResolvedJavaMethod.InlinedBy)value;
                    holder = inlinedBy.holder;
                    for (InterpreterResolvedJavaMethod m : inlinedBy.inliners) {
                        ((InterpreterResolvedJavaMethod)holder).addInliner(m);
                    }
                    Object oneImpl = reader.readReference(dataInput);
                    if (oneImpl instanceof InterpreterResolvedJavaMethod) {
                        InterpreterResolvedJavaMethod interpreterResolvedJavaMethod = (InterpreterResolvedJavaMethod)oneImpl;
                        ((InterpreterResolvedJavaMethod)holder).setOneImplementation(interpreterResolvedJavaMethod);
                        continue;
                    }
                    VMError.guarantee(oneImpl == null);
                }
            }
            catch (EOFException e) {
                InterpreterUniverseImpl universe = new InterpreterUniverseImpl(types, fields, methods);
                long elapsedNanos = System.nanoTime() - startNanos;
                InterpreterUniverseImpl interpreterUniverseImpl = universe;
                return interpreterUniverseImpl;
            }
        }
    }

    public List<InterpreterResolvedJavaType> getTypes() {
        return this.types;
    }

    public List<InterpreterResolvedJavaField> getFields() {
        return this.fields;
    }

    public List<InterpreterResolvedJavaMethod> getMethods() {
        return this.methods;
    }

    @Override
    public Class<?> lookupClass(ResolvedJavaType type) {
        return ((InterpreterResolvedJavaType)type).getJavaClass();
    }

    @Override
    public InterpreterResolvedJavaType lookupType(Class<?> clazz) {
        Map<Class<?>, InterpreterResolvedJavaType> map = this.classToType.get();
        InterpreterResolvedJavaType type = map.get(clazz);
        assert (type != null);
        return type;
    }

    public Collection<InterpreterResolvedJavaField> getAllDeclaredFields(ResolvedJavaType type) {
        InterpreterResolvedJavaType interpreterType = (InterpreterResolvedJavaType)type;
        return this.allDeclaredFields.get().getOrDefault(interpreterType, List.of());
    }

    public Collection<InterpreterResolvedJavaMethod> getAllDeclaredMethods(ResolvedJavaType type) {
        InterpreterResolvedJavaType interpreterType = (InterpreterResolvedJavaType)type;
        return this.allDeclaredMethods.get().getOrDefault(interpreterType, List.of());
    }

    private static InterpreterResolvedJavaMethod[] createMethodTable(Collection<InterpreterResolvedJavaMethod> methods) {
        int maxOffset = -1;
        for (InterpreterResolvedJavaMethod m : methods) {
            int methodOffset = m.getEnterStubOffset();
            if (methodOffset == -5) continue;
            VMError.guarantee(methodOffset >= 0);
            maxOffset = Math.max(maxOffset, methodOffset);
        }
        InterpreterResolvedJavaMethod[] result = new InterpreterResolvedJavaMethod[maxOffset + 1];
        for (InterpreterResolvedJavaMethod m : methods) {
            int methodOffset = m.getEnterStubOffset();
            if (methodOffset == -5) continue;
            VMError.guarantee(result[methodOffset] == null, "duplicated interpreter method entry");
            result[methodOffset] = m;
        }
        return result;
    }

    @Override
    public InterpreterResolvedJavaMethod getMethodForESTOffset(int methodIndex) {
        InterpreterResolvedJavaMethod method = this.methodESTOffsetTable.get()[methodIndex];
        VMError.guarantee(method != null);
        return method;
    }

    private static <T> Map<T, Integer> createInverseTable(Collection<T> list) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        int counter = 0;
        for (T e : list) {
            map.put(e, counter++);
        }
        return map;
    }

    private static InterpreterResolvedJavaMethod[] createMethodIdMapping(List<InterpreterResolvedJavaMethod> methods) {
        int maxMethodId = 0;
        for (InterpreterResolvedJavaMethod method : methods) {
            int methodId = method.getMethodId();
            assert (methodId >= 0);
            maxMethodId = Math.max(maxMethodId, methodId);
        }
        InterpreterResolvedJavaMethod[] mapping = new InterpreterResolvedJavaMethod[maxMethodId + 1];
        for (InterpreterResolvedJavaMethod method : methods) {
            int methodId = method.getMethodId();
            if (methodId == 0) continue;
            mapping[methodId] = method;
        }
        return mapping;
    }

    @Override
    public ResolvedJavaMethod getMethodAtIndex(int index) {
        return this.methods.get(index);
    }

    @Override
    public ResolvedJavaType getTypeAtIndex(int index) {
        return this.types.get(index);
    }

    @Override
    public ResolvedJavaField getFieldAtIndex(int index) {
        return this.fields.get(index);
    }

    @Override
    public OptionalInt getMethodIndexFor(ResolvedJavaMethod method) {
        Integer index = this.methodInverseTable.get().get(method);
        if (index == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index);
    }

    @Override
    public OptionalInt getTypeIndexFor(ResolvedJavaType type) {
        Integer index = this.typeInverseTable.get().get(type);
        if (index == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index);
    }

    @Override
    public OptionalInt getFieldIndexFor(ResolvedJavaField field) {
        Integer index = this.fieldInverseTable.get().get(field);
        if (index == null) {
            return OptionalInt.empty();
        }
        return OptionalInt.of(index);
    }

    @Override
    public InterpreterResolvedJavaMethod getMethodFromMethodId(int methodId) {
        if (methodId == 0) {
            return null;
        }
        InterpreterResolvedJavaMethod[] mapping = this.methodIdMapping.get();
        if (0 <= methodId && methodId < mapping.length) {
            return mapping[methodId];
        }
        return null;
    }
}

