/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.interpreter.metadata.InterpreterResolvedPrimitiveType;
import com.oracle.svm.interpreter.metadata.MetadataUtil;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class InterpreterUnresolvedSignature
implements Signature {
    private final JavaType returnType;
    private final JavaType[] parameterTypes;
    @Platforms(value={Platform.HOSTED_ONLY.class})
    private Signature originalSignature;

    private static boolean primitiveOrUnresolved(JavaType ... types) {
        for (JavaType type : types) {
            if (type instanceof InterpreterResolvedPrimitiveType || type instanceof UnresolvedJavaType) continue;
            return false;
        }
        return true;
    }

    private InterpreterUnresolvedSignature(JavaType returnType, JavaType[] parameterTypes) {
        assert (InterpreterUnresolvedSignature.primitiveOrUnresolved(returnType));
        assert (parameterTypes.getClass() == JavaType[].class);
        assert (InterpreterUnresolvedSignature.primitiveOrUnresolved(parameterTypes));
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private InterpreterUnresolvedSignature(Signature originalSignature, JavaType returnType, JavaType[] parameterTypes) {
        this(returnType, parameterTypes);
        this.originalSignature = originalSignature;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static InterpreterUnresolvedSignature create(Signature originalSignature, JavaType returnType, JavaType[] parameterTypes) {
        return new InterpreterUnresolvedSignature(originalSignature, returnType, parameterTypes);
    }

    public static InterpreterUnresolvedSignature create(JavaType returnType, JavaType[] parameterTypes) {
        return new InterpreterUnresolvedSignature(returnType, parameterTypes);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Signature getOriginalSignature() {
        return this.originalSignature;
    }

    public int getParameterCount(boolean receiver) {
        int count = this.parameterTypes.length;
        if (receiver) {
            ++count;
        }
        return count;
    }

    public int slotsForParameters(boolean receiver) {
        int slots = 0;
        if (receiver) {
            ++slots;
        }
        for (JavaType parameterType : this.parameterTypes) {
            slots += parameterType.getJavaKind().getSlotCount();
        }
        return slots;
    }

    public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
        return this.parameterTypes[index];
    }

    public JavaType getReturnType(ResolvedJavaType accessingClass) {
        return this.returnType;
    }

    public String toString() {
        return "InterpreterUnresolvedSignature<" + this.toMethodDescriptor() + ">";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof InterpreterUnresolvedSignature) {
            InterpreterUnresolvedSignature that = (InterpreterUnresolvedSignature)other;
            return this.returnType.equals((Object)that.returnType) && MetadataUtil.arrayEquals(this.parameterTypes, that.parameterTypes);
        }
        return false;
    }

    public int hashCode() {
        int result = MetadataUtil.hashCode(this.returnType);
        result = 31 * result + MetadataUtil.arrayHashCode(this.parameterTypes);
        return result;
    }
}

