/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.interpreter.metadata.BytecodeStream;

public final class TableSwitch {
    private static final int OFFSET_TO_LOW_KEY = 4;
    private static final int OFFSET_TO_HIGH_KEY = 8;
    private static final int OFFSET_TO_FIRST_JUMP_OFFSET = 12;
    private static final int JUMP_OFFSET_SIZE = 4;

    public static int getAlignedBci(int bci) {
        return bci + 4 & 0xFFFFFFFC;
    }

    private TableSwitch() {
        throw VMError.shouldNotReachHereAtRuntime();
    }

    public static int keyAt(byte[] code, int bci, int i) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return TableSwitch.lowKey(code, bci) + i;
    }

    public static int offsetAt(byte[] code, int bci, int i) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci) + 12 + 4 * i);
    }

    public static int numberOfCases(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return TableSwitch.highKey(code, bci) - TableSwitch.lowKey(code, bci) + 1;
    }

    public static int size(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return TableSwitch.getAlignedBci(bci) + 12 + 4 * TableSwitch.numberOfCases(code, bci) - bci;
    }

    public static int targetAt(byte[] code, int bci, int i) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return bci + TableSwitch.offsetAt(code, bci, i);
    }

    public static int defaultTarget(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return bci + TableSwitch.defaultOffset(code, bci);
    }

    public static int defaultOffset(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci));
    }

    public static int lowKey(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci) + 4);
    }

    public static int highKey(byte[] code, int bci) {
        assert (BytecodeStream.opcode(code, bci) == 170);
        return BytecodeStream.readInt(code, TableSwitch.getAlignedBci(bci) + 8);
    }
}

