/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.interpreter.metadata.serialization;

import com.oracle.svm.interpreter.metadata.serialization.SerializationContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class Serialization {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void serializeSingle(SerializationContext.Builder builder, DataOutput out, Object object) throws IOException {
        SerializationContext.Writer context = builder.buildWriter();
        context.writeValue(out, object);
    }

    public static Object deserializeSingle(SerializationContext.Builder builder, DataInput in) throws IOException {
        SerializationContext.Reader context = builder.buildReader();
        Object latest = null;
        try {
            while (true) {
                latest = context.readValue(in);
            }
        }
        catch (EOFException e) {
            return latest;
        }
    }
}

