/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.SymbolicRefs;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public final class CheckedReader {
    private final SymbolicRefs symbolicRefs;

    public CheckedReader(SymbolicRefs symbolicRefs) {
        this.symbolicRefs = symbolicRefs;
    }

    public ResolvedJavaType readTypeRef(Packet.Reader input) throws JDWPException {
        return this.readTypeRef(input, false);
    }

    public long readTypeRefId(Packet.Reader input, boolean allowNull) throws JDWPException {
        long typeRefId = input.readLong();
        if (typeRefId == 0L) {
            if (!allowNull) {
                throw JDWPException.raise(ErrorCode.INVALID_CLASS);
            }
            return 0L;
        }
        this.symbolicRefs.toResolvedJavaType(typeRefId);
        return typeRefId;
    }

    public long readMethodRefId(Packet.Reader input, boolean allowNull) throws JDWPException {
        long methodRefId = input.readLong();
        if (methodRefId == 0L) {
            if (!allowNull) {
                throw JDWPException.raise(ErrorCode.INVALID_METHODID);
            }
            return 0L;
        }
        this.symbolicRefs.toResolvedJavaMethod(methodRefId);
        return methodRefId;
    }

    public long readFieldRefId(Packet.Reader input, boolean allowNull) throws JDWPException {
        long fieldRefId = input.readLong();
        if (fieldRefId == 0L) {
            if (!allowNull) {
                throw JDWPException.raise(ErrorCode.INVALID_FIELDID);
            }
            return 0L;
        }
        this.symbolicRefs.toResolvedJavaField(fieldRefId);
        return fieldRefId;
    }

    public ResolvedJavaType readTypeRef(Packet.Reader input, boolean allowNull) throws JDWPException {
        long typeRefId = this.readTypeRefId(input, allowNull);
        if (typeRefId == 0L && allowNull) {
            return null;
        }
        return this.symbolicRefs.toResolvedJavaType(typeRefId);
    }

    public ResolvedJavaMethod readMethodRef(Packet.Reader input) throws JDWPException {
        return this.readMethodRef(input, false);
    }

    public ResolvedJavaMethod readMethodRef(Packet.Reader input, boolean allowNull) throws JDWPException {
        long methodRefId = this.readMethodRefId(input, allowNull);
        if (methodRefId == 0L) {
            return null;
        }
        return this.symbolicRefs.toResolvedJavaMethod(methodRefId);
    }

    public ResolvedJavaField readFieldRef(Packet.Reader input, boolean allowNull) throws JDWPException {
        long fieldRefId = this.readTypeRefId(input, allowNull);
        if (fieldRefId == 0L) {
            return null;
        }
        return this.symbolicRefs.toResolvedJavaField(fieldRefId);
    }

    public ResolvedJavaField readFieldRef(Packet.Reader input) throws JDWPException {
        return this.readFieldRef(input, false);
    }
}

