/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.bridge;

import com.oracle.svm.jdwp.bridge.PacketWriterBuffer;
import java.util.Arrays;

final class PacketWriterBufferImpl
implements PacketWriterBuffer {
    private static final int INITIAL_CAPACITY = 64;
    private int size = 0;
    private byte[] bytes;

    PacketWriterBufferImpl() {
        this(64);
    }

    PacketWriterBufferImpl(int initialCapacity) {
        this.bytes = new byte[initialCapacity];
    }

    private void ensureCapacity(int capacity) {
        if (capacity < this.bytes.length) {
            return;
        }
        int newSize = this.size();
        if (newSize == 0) {
            newSize = 1;
        }
        while (newSize < capacity) {
            newSize *= 2;
        }
        this.bytes = Arrays.copyOf(this.bytes, newSize);
    }

    @Override
    public void writeByte(int value) {
        this.ensureCapacity(this.size + 1);
        this.bytes[this.size++] = (byte)value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public byte[] toByteArray() {
        return Arrays.copyOf(this.bytes, this.size());
    }

    @Override
    public byte byteAt(int index) {
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.bytes[index];
    }
}

