/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.resident;

import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.jdwp.resident.JDWPOptions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class CopyNativeJDWPLibraryFeature
implements InternalFeature {
    CopyNativeJDWPLibraryFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return JDWPOptions.JDWP.getValue() != false && Options.CopyNativeJDWPLibrary.getValue() != false;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="imagePath.getParent() is never null")
    public void afterImageWrite(Feature.AfterImageWriteAccess access) {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        String svmjdwpLibraryName = System.mapLibraryName("svmjdwp");
        Path svmjdwpLibraryPath = javaHome.resolve(OS.WINDOWS.isCurrent() ? "bin" : "lib").resolve(svmjdwpLibraryName);
        if (Files.isRegularFile(svmjdwpLibraryPath, new LinkOption[0])) {
            Path imagePath = access.getImagePath();
            Path targetPath = imagePath.getParent().resolve(svmjdwpLibraryName);
            try {
                Files.copy(svmjdwpLibraryPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.SHARED_LIBRARY, targetPath);
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> CopyNativeJDWPLibrary = new HostedOptionKey<Boolean>(true);
    }
}

