/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.common.option.IntentionallyUnsupportedOptions;
import com.oracle.svm.common.option.LocatableOption;
import com.oracle.svm.common.option.MultiOptionValue;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionOrigin;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.driver.APIOptionSupport;
import com.oracle.svm.driver.BundleSupport;
import com.oracle.svm.driver.GroupInfo;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.hosted.option.HostedOptionParser;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.StringUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionsContainer;
import jdk.graal.compiler.options.OptionsParser;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

class APIOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private static final String ENTER_UNLOCK_SCOPE = SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.UnlockExperimentalVMOptions, (String)"+");
    private static final String LEAVE_UNLOCK_SCOPE = SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.UnlockExperimentalVMOptions, (String)"-");
    private final SortedMap<String, OptionInfo> apiOptions;
    private final Map<String, GroupInfo> groupInfos;
    private final Map<String, PathsOptionInfo> pathOptions;
    private final HostedOptionInfo injectedKnownHostedRegularOptionInfo = new HostedOptionInfo(false, false);
    private final HostedOptionInfo injectedKnownHostedBooleanOptionInfo = new HostedOptionInfo(false, true);
    private final Map<String, HostedOptionInfo> allOptionNames;
    private int numberOfActiveUnlockExperimentalVMOptions = 0;
    private Set<String> illegalExperimentalOptions = new HashSet<String>(0);

    APIOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
        if (NativeImage.IS_AOT) {
            APIOptionSupport support = (APIOptionSupport)ImageSingletons.lookup(APIOptionSupport.class);
            this.groupInfos = support.groupInfos();
            this.pathOptions = support.pathOptions();
            this.allOptionNames = support.allOptionNames();
            this.apiOptions = support.options();
        } else {
            this.groupInfos = new HashMap<String, GroupInfo>();
            this.pathOptions = new HashMap<String, PathsOptionInfo>();
            this.allOptionNames = new HashMap<String, HostedOptionInfo>();
            ClassLoader cl = nativeImage.getClass().getClassLoader();
            this.apiOptions = APIOptionHandler.extractOptions(OptionsContainer.getDiscoverableOptions((ClassLoader)cl), this.groupInfos, this.pathOptions, this.allOptionNames);
        }
    }

    static SortedMap<String, OptionInfo> extractOptions(Iterable<OptionDescriptors> optionDescriptors, Map<String, GroupInfo> groupInfos, Map<String, PathsOptionInfo> pathOptions, Map<String, HostedOptionInfo> allOptionNames) {
        EconomicMap hostedOptions = EconomicMap.create();
        EconomicMap runtimeOptions = EconomicMap.create();
        HostedOptionParser.collectOptions(optionDescriptors, (EconomicMap)hostedOptions, (EconomicMap)runtimeOptions);
        TreeMap<String, OptionInfo> apiOptions = new TreeMap<String, OptionInfo>();
        HashMap groupInstances = new HashMap();
        hostedOptions.getValues().forEach(o -> {
            APIOptionHandler.extractOption("-H:", o, apiOptions, groupInfos, groupInstances, allOptionNames);
            APIOptionHandler.extractPathOption("-H:", o, pathOptions);
        });
        runtimeOptions.getValues().forEach(o -> APIOptionHandler.extractOption("-R:", o, apiOptions, groupInfos, groupInstances, allOptionNames));
        groupInfos.forEach((groupName, groupInfo) -> {
            if (groupInfo.defaultValues.size() > 1) {
                VMError.shouldNotReachHere((String)String.format("APIOptionGroup %s must only have a single default (but has: %s)", groupName, String.join((CharSequence)", ", groupInfo.defaultValues)));
            }
        });
        return apiOptions;
    }

    private static void extractOption(String optionPrefix, OptionDescriptor optionDescriptor, SortedMap<String, OptionInfo> apiOptions, Map<String, GroupInfo> groupInfos, Map<Class<? extends APIOptionGroup>, APIOptionGroup> groupInstances, Map<String, HostedOptionInfo> allOptionNames) {
        Class<?> optionValueType = optionDescriptor.getOptionValueType();
        boolean isBooleanOption = optionValueType.equals(Boolean.class);
        for (APIOption apiAnnotation : OptionUtils.getAnnotationsByType((OptionDescriptor)optionDescriptor, APIOption.class)) {
            boolean hasFixedValue;
            Object builderOption = optionPrefix;
            if (apiAnnotation.name().length <= 0) {
                VMError.shouldNotReachHere((String)String.format("APIOption for %s does not provide a name entry", optionDescriptor.getLocation()));
            }
            Object apiOptionName = APIOption.Utils.optionName((String)apiAnnotation.name()[0]);
            String rawOptionName = optionDescriptor.getName();
            APIOptionGroup group = null;
            String defaultValue = null;
            if (optionValueType.isArray()) {
                VMError.guarantee((boolean)(optionDescriptor.getOptionKey() instanceof HostedOptionKey), (String)"Only HostedOptionKeys are allowed to have array type key values.");
                optionValueType = optionValueType.getComponentType();
            }
            boolean bl = hasFixedValue = apiAnnotation.fixedValue().length > 0;
            if (isBooleanOption) {
                if (!apiAnnotation.group().equals(APIOption.NullGroup.class)) {
                    try {
                        Class groupClass = apiAnnotation.group();
                        APIOptionGroup g = group = groupInstances.computeIfAbsent(groupClass, ReflectionUtil::newInstance);
                        String string = APIOption.Utils.groupName((APIOptionGroup)group);
                        GroupInfo groupInfo = groupInfos.computeIfAbsent(string, n -> new GroupInfo(g));
                        if (group.helpText() == null || group.helpText().isEmpty()) {
                            VMError.shouldNotReachHere((String)String.format("APIOptionGroup %s(%s) needs to provide help text", groupClass.getName(), group.name()));
                        }
                        String groupMember = apiAnnotation.name()[0];
                        groupInfo.supportedValues.add(groupMember);
                        apiOptionName = string + groupMember;
                        Boolean isEnabled = (Boolean)optionDescriptor.getOptionKey().getDefaultValue();
                        if (isEnabled.booleanValue()) {
                            groupInfo.defaultValues.add(groupMember);
                            defaultValue = groupMember;
                        }
                    }
                    catch (ReflectionUtil.ReflectionUtilError ex) {
                        throw VMError.shouldNotReachHere((String)("Class specified as group for @APIOption " + (String)apiOptionName + " cannot be loaded or instantiated: " + apiAnnotation.group().getTypeName()), (Throwable)ex.getCause());
                    }
                }
                if (apiAnnotation.defaultValue().length > 0) {
                    VMError.shouldNotReachHere((String)String.format("Boolean APIOption %s(%s) cannot use APIOption.defaultValue", apiOptionName, rawOptionName));
                }
                if (hasFixedValue) {
                    VMError.shouldNotReachHere((String)String.format("Boolean APIOption %s(%s) cannot use APIOption.fixedValue", apiOptionName, rawOptionName));
                }
                builderOption = (String)builderOption + (apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Negated) ? "-" : "+");
                builderOption = (String)builderOption + rawOptionName;
            } else {
                if (!apiAnnotation.group().equals(APIOption.NullGroup.class)) {
                    VMError.shouldNotReachHere((String)String.format("Using @APIOption.group not supported for non-boolean APIOption %s(%s)", apiOptionName, rawOptionName));
                }
                if (apiAnnotation.kind().equals((Object)APIOption.APIOptionKind.Negated)) {
                    VMError.shouldNotReachHere((String)String.format("Non-boolean APIOption %s(%s) cannot use APIOptionKind.Negated", apiOptionName, rawOptionName));
                }
                if (apiAnnotation.defaultValue().length > 1) {
                    VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) cannot have more than one APIOption.defaultValue", apiOptionName, rawOptionName));
                }
                if (apiAnnotation.fixedValue().length > 1) {
                    VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) cannot have more than one APIOption.fixedValue", apiOptionName, rawOptionName));
                }
                if (hasFixedValue && apiAnnotation.defaultValue().length > 0) {
                    VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) APIOption.defaultValue and APIOption.fixedValue cannot be combined", apiOptionName, rawOptionName));
                }
                if (apiAnnotation.defaultValue().length > 0) {
                    defaultValue = apiAnnotation.defaultValue()[0];
                }
                if (hasFixedValue) {
                    defaultValue = apiAnnotation.fixedValue()[0];
                }
                builderOption = (String)builderOption + rawOptionName;
                builderOption = (String)builderOption + "=";
            }
            String helpText = (String)optionDescriptor.getHelp().getFirst();
            if (!apiAnnotation.customHelp().isEmpty()) {
                helpText = apiAnnotation.customHelp();
            }
            if (helpText == null || helpText.isEmpty()) {
                VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) needs to provide help text", apiOptionName, rawOptionName));
            }
            if (group == null) {
                helpText = APIOptionHandler.startLowerCase(helpText);
            }
            ArrayList<Function<Object, Object>> valueTransformers = new ArrayList<Function<Object, Object>>(apiAnnotation.valueTransformer().length);
            for (Class transformerClass : apiAnnotation.valueTransformer()) {
                try {
                    valueTransformers.add((Function)ReflectionUtil.newInstance((Class)transformerClass));
                }
                catch (ReflectionUtil.ReflectionUtilError ex) {
                    throw VMError.shouldNotReachHere((String)("Class specified as valueTransformer for @APIOption " + (String)apiOptionName + " cannot be loaded or instantiated: " + transformerClass.getTypeName()), (Throwable)ex.getCause());
                }
            }
            if (apiAnnotation.valueSeparator().length == 0) {
                throw VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) does not specify any valueSeparator", apiOptionName, rawOptionName));
            }
            for (char valueSeparator : apiAnnotation.valueSeparator()) {
                if (valueSeparator != ' ') continue;
                String msgTail = " cannot use APIOption.WHITESPACE_SEPARATOR as value separator";
                if (isBooleanOption) {
                    throw VMError.shouldNotReachHere((String)String.format("Boolean APIOption %s(%s)" + msgTail, apiOptionName, rawOptionName));
                }
                if (hasFixedValue) {
                    VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) with fixed value" + msgTail, apiOptionName, rawOptionName));
                }
                if (defaultValue == null) continue;
                VMError.shouldNotReachHere((String)String.format("APIOption %s(%s) with default value" + msgTail, apiOptionName, rawOptionName));
            }
            boolean bl2 = isBooleanOption || hasFixedValue;
            apiOptions.put((String)apiOptionName, new OptionInfo(apiAnnotation.name(), apiAnnotation.valueSeparator(), (String)builderOption, defaultValue, helpText, bl2, apiAnnotation.deprecated(), valueTransformers, group, apiAnnotation.extra(), apiAnnotation.launcherOption()));
        }
        if (!IntentionallyUnsupportedOptions.contains((OptionKey)optionDescriptor.getOptionKey())) {
            allOptionNames.put(optionDescriptor.getName(), new HostedOptionInfo(optionDescriptor.getStability() == OptionStability.STABLE, isBooleanOption));
        }
    }

    private static void extractPathOption(String optionPrefix, OptionDescriptor optionDescriptor, Map<String, PathsOptionInfo> pathOptions) {
        MultiOptionValue multiOptionDefaultValue;
        Object defaultValue = optionDescriptor.getOptionKey().getDefaultValue();
        if (defaultValue instanceof MultiOptionValue && Path.class.isAssignableFrom((multiOptionDefaultValue = (MultiOptionValue)defaultValue).getValueType())) {
            String rawOptionName = optionDescriptor.getName();
            String builderOption = optionPrefix + rawOptionName;
            BundleMember.Role role = BundleMember.Role.Ignore;
            for (BundleMember bundleMember : OptionUtils.getAnnotationsByType((OptionDescriptor)optionDescriptor, BundleMember.class)) {
                role = bundleMember.role();
            }
            pathOptions.put(builderOption, new PathsOptionInfo(multiOptionDefaultValue.getDelimiter(), role));
        }
    }

    private static String startLowerCase(String str) {
        return str.substring(0, 1).toLowerCase(Locale.ROOT) + str.substring(1);
    }

    void injectKnownHostedOption(String optionName) {
        HostedOptionInfo optionInfo;
        String baseOptionName;
        if (optionName.endsWith("=")) {
            baseOptionName = optionName.substring(0, optionName.length() - 1);
            optionInfo = this.injectedKnownHostedRegularOptionInfo;
        } else {
            baseOptionName = optionName;
            optionInfo = this.injectedKnownHostedBooleanOptionInfo;
        }
        this.allOptionNames.put(baseOptionName, optionInfo);
    }

    @Override
    boolean consume(NativeImage.ArgumentQueue args) {
        String headArg = args.peek();
        String translatedOption = this.translateOption(args);
        if (translatedOption != null) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(translatedOption, args.argumentOrigin + "+api");
            return true;
        }
        if (ENTER_UNLOCK_SCOPE.equals(headArg)) {
            if (args.numberOfFirstObservedActiveUnlockExperimentalVMOptions < 0) {
                args.numberOfFirstObservedActiveUnlockExperimentalVMOptions = this.numberOfActiveUnlockExperimentalVMOptions;
            }
            ++this.numberOfActiveUnlockExperimentalVMOptions;
        } else if (LEAVE_UNLOCK_SCOPE.equals(headArg)) {
            if (this.numberOfActiveUnlockExperimentalVMOptions <= 0 || this.numberOfActiveUnlockExperimentalVMOptions <= args.numberOfFirstObservedActiveUnlockExperimentalVMOptions) {
                throw VMError.shouldNotReachHere((String)"Unlocking of experimental options in inconsistent state: trying to lock more scopes than exist or allowed.");
            }
            --this.numberOfActiveUnlockExperimentalVMOptions;
        } else if (!OptionOrigin.isAPI((String)args.argumentOrigin) && headArg.startsWith("-H:")) {
            this.validateHostedOption(headArg, args.argumentOrigin);
        }
        for (Map.Entry<String, GroupInfo> entry : this.groupInfos.entrySet()) {
            String groupNameAndSeparator = entry.getKey();
            if (!headArg.startsWith(groupNameAndSeparator)) continue;
            GroupInfo groupInfo = entry.getValue();
            String groupName = APIOption.Utils.optionName((String)groupInfo.group.name());
            NativeImage.showError("In " + args.argumentOrigin + " '" + headArg.substring(groupNameAndSeparator.length()) + "' is not a valid value for the option " + groupName + ". Supported values are " + StringUtil.joinSingleQuoted(groupInfo.supportedValues) + ".");
        }
        return false;
    }

    private void validateHostedOption(String hostedOptionArg, String argumentOrigin) {
        HostedOptionInfo info;
        char first;
        String optionName = hostedOptionArg.substring("-H:".length()).split("=", 2)[0].split("@", 2)[0];
        char booleanPrefix = '\u0000';
        if (!(optionName.isEmpty() || (first = optionName.charAt(0)) != '+' && first != '-')) {
            optionName = optionName.substring(1);
            booleanPrefix = first;
        }
        if ((info = this.allOptionNames.get(optionName)) == null) {
            ArrayList matches = new ArrayList();
            OptionsParser.collectFuzzyMatches(() -> this.allOptionNames.keySet().iterator(), (String)optionName, matches, Function.identity());
            StringBuilder msg = new StringBuilder("Unrecognized option ");
            msg.append(APIOptionHandler.optionDescription(optionName, booleanPrefix, argumentOrigin)).append('.');
            if (!matches.isEmpty()) {
                msg.append(" Did you mean one of these:");
                for (String match : matches) {
                    msg.append(' ').append('\'').append("-H:");
                    boolean matchIsBoolean = this.allOptionNames.get((Object)match).isBoolean;
                    if (matchIsBoolean) {
                        msg.append('\u00b1');
                    }
                    msg.append(match);
                    if (!matchIsBoolean) {
                        msg.append("=...");
                    }
                    msg.append('\'');
                }
                msg.append('.');
            }
            msg.append(" Use '--expert-options' (see also '--help-extra') to list all available options.");
            throw NativeImage.showError(msg.toString());
        }
        if (booleanPrefix != '\u0000' != info.isBoolean()) {
            String optionDescription = APIOptionHandler.optionDescription(optionName, booleanPrefix, argumentOrigin);
            if (info.isBoolean().booleanValue()) {
                throw NativeImage.showError("Boolean option %s must have \u00b1 prefix. Use '\u00b1%s' format.".formatted(optionDescription, optionName));
            }
            throw NativeImage.showError("Non-boolean option %s can not use \u00b1 prefix. Use '%s=<value>' format.".formatted(optionDescription, optionName));
        }
        if (this.numberOfActiveUnlockExperimentalVMOptions == 0 && !info.isStable().booleanValue()) {
            this.illegalExperimentalOptions.add(hostedOptionArg);
        }
    }

    private static String optionDescription(String optionName, char booleanPrefix, String argumentOrigin) {
        StringBuilder result = new StringBuilder("'-H:");
        if (booleanPrefix != '\u0000') {
            result.append(booleanPrefix);
        }
        result.append(optionName);
        if (booleanPrefix == '\u0000') {
            result.append("=...");
        }
        result.append("' from ").append(OptionOrigin.from((String)argumentOrigin));
        return result.toString();
    }

    String translateOption(NativeImage.ArgumentQueue argQueue) {
        OptionInfo option = null;
        boolean whitespaceSeparated = false;
        String[] optionNameAndOptionValue = null;
        OptionOrigin argumentOrigin = OptionOrigin.from((String)argQueue.argumentOrigin);
        block0: for (OptionInfo optionInfo : this.apiOptions.values()) {
            for (String variant : optionInfo.variants) {
                String headArg;
                Object optionName;
                if (optionInfo.group == null) {
                    optionName = APIOption.Utils.optionName((String)variant);
                } else {
                    if (optionInfo.group.multiValueOption() != null) {
                        headArg = argQueue.peek();
                        if (!headArg.startsWith(APIOption.Utils.groupName((APIOptionGroup)optionInfo.group))) continue;
                        return headArg.replace(APIOption.Utils.optionName((String)optionInfo.group.name()), "-H:" + optionInfo.group.multiValueOption().getName());
                    }
                    optionName = APIOption.Utils.groupName((APIOptionGroup)optionInfo.group) + variant;
                }
                headArg = argQueue.peek();
                if ((optionInfo.defaultFinal || optionInfo.defaultValue != null) && headArg.equals(optionName)) {
                    option = optionInfo;
                    optionNameAndOptionValue = new String[]{optionName};
                    break block0;
                }
                for (char valueSeparator : optionInfo.valueSeparator) {
                    if (valueSeparator == ' ' && headArg.equals(optionName)) {
                        argQueue.poll();
                        String optionValue = argQueue.peek();
                        if (optionValue == null) {
                            NativeImage.showError(headArg + " from " + String.valueOf(argumentOrigin) + " requires option argument");
                        }
                        option = optionInfo;
                        optionNameAndOptionValue = new String[]{headArg, optionValue};
                        whitespaceSeparated = true;
                        break block0;
                    }
                    String optionNameWithSeparator = (String)optionName + APIOption.Utils.valueSeparatorToString((char)valueSeparator);
                    if (!headArg.startsWith(optionNameWithSeparator)) continue;
                    option = optionInfo;
                    int length = optionNameWithSeparator.length();
                    optionNameAndOptionValue = new String[]{headArg.substring(0, length), headArg.substring(length)};
                    break block0;
                }
            }
        }
        if (option != null) {
            String optionValue;
            if (!option.deprecationWarning.isEmpty()) {
                LogUtils.warning((String)("Using a deprecated option " + (String)optionNameAndOptionValue[0] + " from " + String.valueOf(argumentOrigin) + ". " + option.deprecationWarning));
            }
            Object builderOption = option.builderOption;
            String string = optionValue = option.group != null ? null : option.defaultValue;
            if (optionNameAndOptionValue.length == 2) {
                if (option.defaultFinal) {
                    NativeImage.showError("Passing values to option " + (String)optionNameAndOptionValue[0] + " from " + String.valueOf(argumentOrigin) + " is not supported.");
                }
                optionValue = optionNameAndOptionValue[1];
            }
            if (optionValue != null) {
                Object transformed = optionValue;
                for (Function<Object, Object> transformer : option.valueTransformers) {
                    transformed = transformer.apply(transformed);
                }
                builderOption = (String)builderOption + transformed.toString();
            }
            if (this.nativeImage.useBundle() && option.launcherOption) {
                if (whitespaceSeparated) {
                    this.nativeImage.bundleSupport.bundleLauncherArgs.addAll(List.of(optionNameAndOptionValue));
                } else {
                    this.nativeImage.bundleSupport.bundleLauncherArgs.add(argQueue.peek());
                }
            }
            return builderOption;
        }
        return null;
    }

    String transformBuilderArgument(String builderArgument, BiFunction<Path, BundleMember.Role, Path> transformFunction) {
        BuilderArgumentParts argumentParts = BuilderArgumentParts.from(builderArgument);
        if (argumentParts.optionValue == null) {
            return builderArgument;
        }
        PathsOptionInfo pathsOptionInfo = this.pathOptions.get(argumentParts.option.name);
        if (pathsOptionInfo == null || pathsOptionInfo.role == BundleMember.Role.Ignore) {
            return builderArgument;
        }
        String delimiter = pathsOptionInfo.delimiter;
        List<String> rawEntries = delimiter.isEmpty() ? List.of(argumentParts.optionValue) : List.of(StringUtil.split((String)argumentParts.optionValue, (String)delimiter));
        try {
            String transformedOptionValue;
            argumentParts.optionValue = transformedOptionValue = rawEntries.stream().filter(s -> !s.isEmpty()).map(this::tryCanonicalize).map(src -> (Path)transformFunction.apply((Path)src, pathsOptionInfo.role)).map(Path::toString).collect(Collectors.joining(delimiter));
            return argumentParts.toString();
        }
        catch (BundleSupport.BundlePathSubstitutionError error) {
            String originStr = argumentParts.option.origin;
            Object optionOrigin = OptionOrigin.from((String)originStr, (boolean)false);
            if (optionOrigin == null && originStr != null) {
                optionOrigin = originStr;
            }
            String fromPart = optionOrigin != null ? " from '" + String.valueOf(optionOrigin) + "'" : "";
            throw NativeImage.showError("Failed to prepare path entry '" + String.valueOf(error.origPath) + "' of option " + argumentParts.option.name + fromPart + " for bundle inclusion.", error);
        }
    }

    private Path tryCanonicalize(String path) {
        Path origPath = Paths.get(path, new String[0]);
        try {
            return this.nativeImage.canonicalize(origPath);
        }
        catch (NativeImage.NativeImageError e) {
            return origPath;
        }
    }

    void printOptions(Consumer<String> println, boolean extra) {
        TreeMap<String, List> optionInfo = new TreeMap<String, List>();
        this.apiOptions.forEach((optionName, option) -> {
            String groupOrOptionName;
            if (option.isDeprecated() || option.extra != extra) {
                return;
            }
            String string = groupOrOptionName = option.group != null ? APIOption.Utils.groupName((APIOptionGroup)option.group) : optionName;
            if (optionInfo.containsKey(groupOrOptionName)) {
                ArrayList<OptionInfo> options = (ArrayList<OptionInfo>)optionInfo.get(groupOrOptionName);
                if (options.size() == 1) {
                    options = new ArrayList<OptionInfo>(options);
                    optionInfo.put(groupOrOptionName, options);
                }
                options.add((OptionInfo)option);
            } else {
                optionInfo.put(groupOrOptionName, List.of(option));
            }
        });
        optionInfo.forEach((optionName, options) -> {
            if (options.size() == 1) {
                OptionInfo singleOption = (OptionInfo)options.get(0);
                if (singleOption.group == null) {
                    SubstrateOptionsParser.printOption((Consumer)println, (String)optionName, (String)singleOption.helpText, (int)4, (int)22, (int)66);
                } else if (!Arrays.asList(singleOption.variants).contains(singleOption.defaultValue)) {
                    APIOptionHandler.printGroupOption(println, optionName, options);
                }
            } else {
                APIOptionHandler.printGroupOption(println, optionName, options);
            }
        });
    }

    private static void printGroupOption(Consumer<String> println, String groupName, List<OptionInfo> options) {
        APIOptionGroup group = options.get((int)0).group;
        assert (group != null);
        StringBuilder sb = new StringBuilder();
        sb.append(APIOptionHandler.startLowerCase(group.helpText()));
        if (!group.helpText().endsWith(".")) {
            sb.append(".");
        }
        sb.append(" Allowed options for <value>:");
        SubstrateOptionsParser.printOption(println, (String)(groupName + "<value>"), (String)sb.toString(), (int)4, (int)22, (int)66);
        for (OptionInfo groupEntry : options) {
            assert (groupEntry.group == group);
            sb.setLength(0);
            boolean first = true;
            boolean isDefault = false;
            for (String variant : groupEntry.variants) {
                if (variant.equals(groupEntry.defaultValue)) {
                    isDefault = true;
                }
                if (first) {
                    first = false;
                } else {
                    sb.append(" | ");
                }
                sb.append("'").append(variant).append("'");
            }
            sb.append(": ").append(groupEntry.helpText);
            if (isDefault) {
                sb.append(" (default)");
            }
            SubstrateOptionsParser.printOption(println, (String)"", (String)sb.toString(), (int)4, (int)22, (int)66);
        }
    }

    public void ensureConsistentUnlockScopes(NativeImage.ArgumentQueue queue) {
        boolean inUnlockScope = false;
        for (String arg : queue.snapshot()) {
            if (ENTER_UNLOCK_SCOPE.equals(arg)) {
                if (inUnlockScope) {
                    LogUtils.warning((String)("'" + ENTER_UNLOCK_SCOPE + "' was used repeatedly. Please check your build arguments, for example with '--verbose', and ensure experimental options are not unlocked more than once. Use '" + LEAVE_UNLOCK_SCOPE + "' to lock access to experimental options again."));
                }
                inUnlockScope = true;
                continue;
            }
            if (!LEAVE_UNLOCK_SCOPE.equals(arg)) continue;
            if (!inUnlockScope) {
                throw NativeImage.showError("'" + LEAVE_UNLOCK_SCOPE + "' was used but experimental options are not unlocked via '" + ENTER_UNLOCK_SCOPE + "'. Please check your build arguments, for example with '--verbose', and ensure access to experimental options is only locked after it has been unlocked.");
            }
            inUnlockScope = false;
        }
        if (inUnlockScope) {
            queue.add(LEAVE_UNLOCK_SCOPE);
        }
    }

    public void validateExperimentalOptions() {
        if (this.illegalExperimentalOptions.isEmpty()) {
            return;
        }
        for (String illegalOption : this.illegalExperimentalOptions) {
            LogUtils.warning((String)("The option '" + illegalOption + "' is experimental and must be enabled via '" + ENTER_UNLOCK_SCOPE + "' in the future."));
        }
        LogUtils.warning((String)"Please re-evaluate whether any experimental option is required, and either remove or unlock it. The build output lists all active experimental options, including where they come from and possible alternatives. If you think an experimental option should be considered as stable, please file an issue.");
        if ("true".equalsIgnoreCase(System.getenv().get("NATIVE_IMAGE_EXPERIMENTAL_OPTIONS_ARE_FATAL"))) {
            throw NativeImage.showError("Not all experimental options were unlocked.");
        }
    }

    record HostedOptionInfo(Boolean isStable, Boolean isBoolean) {
    }

    record OptionInfo(String[] variants, char[] valueSeparator, String builderOption, String defaultValue, String helpText, boolean defaultFinal, String deprecationWarning, List<Function<Object, Object>> valueTransformers, APIOptionGroup group, boolean extra, boolean launcherOption) {
        boolean isDeprecated() {
            return this.deprecationWarning.length() > 0;
        }
    }

    record PathsOptionInfo(String delimiter, BundleMember.Role role) {
    }

    static final class BuilderArgumentParts {
        final LocatableOption option;
        String optionValue;

        private BuilderArgumentParts(LocatableOption option, String optionValue) {
            this.option = option;
            this.optionValue = optionValue;
        }

        static BuilderArgumentParts from(String builderArgument) {
            String[] nameAndValue = StringUtil.split((String)builderArgument, (String)"=", (int)2);
            String optionValue = nameAndValue.length != 2 ? null : nameAndValue[1];
            return new BuilderArgumentParts(LocatableOption.from((String)nameAndValue[0]), optionValue);
        }

        public String toString() {
            String optionName = this.option.rawName();
            return this.optionValue == null ? optionName : optionName + "=" + this.optionValue;
        }
    }
}

