/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.util.ExitStatus;
import com.oracle.svm.driver.NativeImage;
import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jdk.jfr.internal.JVM;

class MemoryUtil {
    private static final long KiB_TO_BYTES = 1024L;
    private static final long MiB_TO_BYTES = 0x100000L;
    private static final long GiB_TO_BYTES = 0x40000000L;
    private static final long MIN_HEAP_BYTES = 0x20000000L;
    private static final double DEDICATED_MODE_TOTAL_MEMORY_RATIO = 0.85;
    private static final int MIN_AVAILABLE_MEMORY_THRESHOLD_GB = 8;
    private static final long MAX_HEAP_BYTES = 32000000000L;

    MemoryUtil() {
    }

    public static List<String> determineMemoryFlags(NativeImage.HostFlags hostFlags) {
        ArrayList<String> flags = new ArrayList<String>();
        if (hostFlags.hasUseParallelGC()) {
            flags.add("-XX:+UseParallelGC");
        }
        if (hostFlags.hasMaxRAMPercentage()) {
            flags.addAll(MemoryUtil.determineMemoryUsageFlags(value -> "-XX:MaxRAMPercentage=" + value));
        } else if (hostFlags.hasMaximumHeapSizePercent()) {
            flags.addAll(MemoryUtil.determineMemoryUsageFlags(value -> "-XX:MaximumHeapSizePercent=" + value.intValue()));
        }
        if (hostFlags.hasGCTimeRatio()) {
            flags.add("-XX:GCTimeRatio=9");
        }
        if (hostFlags.hasExitOnOutOfMemoryError()) {
            flags.add("-XX:+ExitOnOutOfMemoryError");
        }
        return flags;
    }

    private static List<String> determineMemoryUsageFlags(Function<Double, String> toMemoryFlag) {
        double reasonableMaxMemorySize;
        boolean isDedicatedMemoryUsage;
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double totalMemorySize = osBean.getTotalMemorySize();
        double dedicatedMemorySize = totalMemorySize * 0.85;
        String memoryUsageReason = "unknown";
        if (SubstrateUtil.isCISetToTrue()) {
            isDedicatedMemoryUsage = true;
            memoryUsageReason = "$CI set to 'true'";
        } else if (MemoryUtil.isContainerized()) {
            isDedicatedMemoryUsage = true;
            memoryUsageReason = "in container";
        } else {
            isDedicatedMemoryUsage = false;
        }
        if (isDedicatedMemoryUsage) {
            reasonableMaxMemorySize = dedicatedMemorySize;
        } else {
            reasonableMaxMemorySize = MemoryUtil.getAvailableMemorySize();
            if (reasonableMaxMemorySize >= 8.589934592E9) {
                memoryUsageReason = "using available memory";
            } else {
                memoryUsageReason = "less than 8GB of memory available";
                reasonableMaxMemorySize = dedicatedMemorySize;
            }
        }
        if (reasonableMaxMemorySize < 5.36870912E8) {
            throw new NativeImage.NativeImageError("There is not enough memory available on the system (got %sMiB, need at least %sMiB). Consider freeing up memory if builds are slow, for example, by closing applications that you do not need.".formatted(reasonableMaxMemorySize / 1048576.0, 512L), null, ExitStatus.OUT_OF_MEMORY.getValue());
        }
        reasonableMaxMemorySize = Math.min(reasonableMaxMemorySize, 3.2E10);
        double reasonableMaxRamPercentage = reasonableMaxMemorySize / totalMemorySize * 100.0;
        return List.of(toMemoryFlag.apply(reasonableMaxRamPercentage), "-Dsvm.build.memoryUsageReasonText=" + memoryUsageReason);
    }

    private static boolean isContainerized() {
        if (!OS.LINUX.isCurrent()) {
            return false;
        }
        return JVM.isContainerized();
    }

    private static double getAvailableMemorySize() {
        return switch (OS.getCurrent()) {
            default -> throw new MatchException(null, null);
            case OS.LINUX -> MemoryUtil.getAvailableMemorySizeLinux();
            case OS.DARWIN -> MemoryUtil.getAvailableMemorySizeDarwin();
            case OS.WINDOWS -> MemoryUtil.getAvailableMemorySizeWindows();
        };
    }

    private static long getAvailableMemorySizeLinux() {
        try {
            String memAvailableLine = Files.readAllLines(Paths.get("/proc/meminfo", new String[0])).stream().filter(l -> l.startsWith("MemAvailable")).findFirst().orElse("");
            Matcher m = Pattern.compile("^MemAvailable:\\s+(\\d+) kB").matcher(memAvailableLine);
            if (m.matches()) {
                return Long.parseLong(m.group(1)) * 1024L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static long getAvailableMemorySizeDarwin() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"vm_stat"});
            try {
                long inactivePages;
                long freePages;
                long pageSize;
                BufferedReader reader;
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                String line1;
                                block24: {
                                    long l;
                                    reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                    try {
                                        line1 = reader.readLine();
                                        if (line1 != null) break block24;
                                        l = -1L;
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                    reader.close();
                                    return l;
                                }
                                Matcher m1 = Pattern.compile("^Mach Virtual Memory Statistics: \\(page size of (\\d+) bytes\\)").matcher(line1);
                                pageSize = -1L;
                                if (m1.matches()) {
                                    pageSize = Long.parseLong(m1.group(1));
                                }
                                if (pageSize > 0L) break block25;
                                long l = -1L;
                                reader.close();
                                return l;
                            }
                            String line2 = reader.readLine();
                            Matcher m2 = Pattern.compile("^Pages free:\\s+(\\d+).").matcher(line2);
                            freePages = -1L;
                            if (m2.matches()) {
                                freePages = Long.parseLong(m2.group(1));
                            }
                            if (freePages > 0L) break block26;
                            long l = -1L;
                            reader.close();
                            return l;
                        }
                        String line3 = reader.readLine();
                        if (line3.startsWith("Pages active")) break block27;
                        long l = -1L;
                        reader.close();
                        return l;
                    }
                    String line4 = reader.readLine();
                    Matcher m4 = Pattern.compile("^Pages inactive:\\s+(\\d+).").matcher(line4);
                    inactivePages = -1L;
                    if (m4.matches()) {
                        inactivePages = Long.parseLong(m4.group(1));
                    }
                    if (inactivePages > 0L) break block28;
                    long l = -1L;
                    reader.close();
                    return l;
                }
                assert (freePages > 0L && inactivePages > 0L && pageSize > 0L);
                long l = (freePages + inactivePages) * pageSize;
                reader.close();
                return l;
            }
            finally {
                p.waitFor();
            }
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getAvailableMemorySizeWindows() {
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "wmic", "OS", "get", "FreePhysicalMemory"});
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line1 = reader.readLine();
                if (line1 == null || !line1.startsWith("FreePhysicalMemory")) {
                    long l = -1L;
                    return l;
                }
                String line2 = reader.readLine();
                if (line2 == null) {
                    long l = -1L;
                    return l;
                }
                String line3 = reader.readLine();
                if (line3 == null) {
                    long l = -1L;
                    return l;
                }
                Matcher m = Pattern.compile("^(\\d+)\\s+").matcher(line3);
                if (m.matches()) {
                    long l = Long.parseLong(m.group(1)) * 1024L;
                    return l;
                }
            }
            p.waitFor();
            return -1L;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }
}

