/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jdwp.server.impl;

import com.oracle.svm.jdwp.bridge.ErrorCode;
import com.oracle.svm.jdwp.bridge.JDWP;
import com.oracle.svm.jdwp.bridge.JDWPException;
import com.oracle.svm.jdwp.bridge.Packet;
import com.oracle.svm.jdwp.bridge.UnmodifiablePacket;
import com.oracle.svm.jdwp.bridge.WritablePacket;
import com.oracle.svm.jdwp.server.impl.ConnectionClosedException;
import com.oracle.svm.jdwp.server.impl.DebuggerController;
import com.oracle.svm.jdwp.server.impl.ServerJDWP;
import com.oracle.svm.jdwp.server.impl.SocketConnection;
import java.io.IOException;
import java.util.Collection;

public final class DebuggerConnection {
    private final DebuggerController controller;
    private final SocketConnection connection;
    private final Collection<Thread> activeThreads;

    public DebuggerConnection(SocketConnection connection, DebuggerController controller, Collection<Thread> activeThreads) {
        this.connection = connection;
        this.controller = controller;
        this.activeThreads = activeThreads;
    }

    public void doProcessCommands(boolean suspend, Runnable vmStartedJob) {
        this.controller.init();
        Thread jdwpTransport = new Thread((Runnable)new JDWPTransportThread(vmStartedJob), "jdwp-transport");
        jdwpTransport.setDaemon(true);
        jdwpTransport.start();
        this.activeThreads.add(jdwpTransport);
    }

    public void queuePacket(Packet packet) {
        this.connection.queuePacket(packet);
    }

    public void close() {
        try {
            this.connection.close();
            this.controller.getEventListener().setConnection(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Closing socket connection failed", e);
        }
        for (Thread t : this.activeThreads) {
            t.interrupt();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static Packet safeParseAndWrap(byte[] packetBytes) throws IOException, ConnectionClosedException {
        if (packetBytes.length < 11) {
            if (Thread.currentThread().isInterrupted() || packetBytes.length == 0) {
                throw new ConnectionClosedException();
            }
            throw new IOException("Packet insufficient size");
        }
        try {
            return UnmodifiablePacket.parseAndWrap((byte[])packetBytes);
        }
        catch (IllegalArgumentException e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new ConnectionClosedException();
            }
            throw new IOException("Packet .length and size mis-match");
        }
    }

    void handleReply(Packet packet, Packet result) {
        if (result == null) {
            assert (packet.commandSet() == 3 && packet.command() == 3 || packet.commandSet() == 9 && packet.command() == 6 || packet.commandSet() == 5 && packet.command() == 1 || packet.commandSet() == 3 && packet.command() == 4) : "Only JDWP invoke commands can have a null reply (asynchronous).";
            ServerJDWP.LOGGER.log(() -> "no result for command " + JDWP.toString((int)packet.commandSet(), (int)packet.command()));
            return;
        }
        ServerJDWP.LOGGER.log(() -> "replying to command " + JDWP.toString((int)packet.commandSet(), (int)packet.command()));
        this.connection.queuePacket(result);
    }

    private class JDWPTransportThread
    implements Runnable {
        private Runnable vmStartedJob;

        JDWPTransportThread(Runnable vmStartedJob) {
            this.vmStartedJob = vmStartedJob;
        }

        @Override
        public void run() {
            this.vmStartedJob.run();
            this.vmStartedJob = null;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Packet packet = DebuggerConnection.safeParseAndWrap(DebuggerConnection.this.connection.readPacket());
                    this.processPacket(packet);
                }
                catch (IOException e) {
                    ServerJDWP.LOGGER.log((Throwable)e, "Failed to read/parse JDWP packet");
                    break;
                }
                catch (ConnectionClosedException e) {
                    ServerJDWP.LOGGER.log((Throwable)e);
                    break;
                }
            }
        }

        private void processPacket(Packet packet) {
            try {
                if (packet.isReply()) {
                    ServerJDWP.LOGGER.log(() -> "Should not get any reply packet from debugger");
                } else {
                    ServerJDWP.LOGGER.log(() -> "received command " + JDWP.toString((int)packet.commandSet(), (int)packet.command()));
                    Packet result = DebuggerConnection.this.controller.getServerJDWP().dispatch(packet);
                    DebuggerConnection.this.handleReply(packet, result);
                }
            }
            catch (JDWPException e) {
                ServerJDWP.LOGGER.log((Throwable)e, "JDWP exception");
                WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
                reply.errorCode(e.getError());
                DebuggerConnection.this.handleReply(packet, (Packet)reply);
            }
            catch (VirtualMachineError vmError) {
                ServerJDWP.LOGGER.log((Throwable)vmError);
                throw vmError;
            }
            catch (Throwable t) {
                ServerJDWP.LOGGER.log(t, "Internal error");
                WritablePacket reply = WritablePacket.newReplyTo((Packet)packet);
                reply.errorCode(ErrorCode.INTERNAL);
                DebuggerConnection.this.handleReply(packet, (Packet)reply);
            }
        }
    }
}

