/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure;

import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.configure.SerializationConfigurationParser;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import com.oracle.svm.configure.config.conditional.ConfigurationConditionResolver;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.TypeResult;
import java.net.URI;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class SerializationMetadataParser<C>
extends SerializationConfigurationParser<C> {
    private boolean customConstructorWarningTriggered = false;

    SerializationMetadataParser(ConfigurationConditionResolver<C> conditionResolver, RuntimeSerializationSupport<C> serializationSupport, EnumSet<ConfigurationParserOption> parserOptions) {
        super(conditionResolver, serializationSupport, parserOptions);
    }

    @Override
    public void parseAndRegister(Object json, URI origin) {
        Object serializationJson = this.getFromGlobalFile(json, "serialization");
        if (serializationJson != null) {
            this.parseSerializationTypes(SerializationMetadataParser.asList(serializationJson, "The serialization property must be an array of serialization descriptor object"), false);
        }
    }

    @Override
    protected void parseSerializationDescriptorObject(EconomicMap<String, Object> data, boolean lambdaCapturingType) {
        this.checkAttributes(data, "serialization descriptor object", List.of("type"), List.of("condition", "customTargetConstructorClass"));
        Optional<ConfigurationTypeDescriptor> targetSerializationClass = this.parseTypeContents(data.get((Object)"type"));
        if (targetSerializationClass.isEmpty()) {
            return;
        }
        UnresolvedConfigurationCondition unresolvedCondition = this.parseCondition(data, true);
        TypeResult condition = this.conditionResolver.resolveCondition(unresolvedCondition);
        if (!condition.isPresent()) {
            return;
        }
        if (!this.customConstructorWarningTriggered && data.containsKey((Object)"customTargetConstructorClass")) {
            this.customConstructorWarningTriggered = true;
            LogUtils.warning((String)"\"customTargetConstructorClass\" is deprecated in reachability-metadata.json. All serializable classes can be instantiated through any superclass constructor without the use of the flag.");
        }
        this.registerType(targetSerializationClass.get(), condition.get());
    }
}

