/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.ConfigurationParser;
import com.oracle.svm.configure.ConfigurationParserOption;
import com.oracle.svm.configure.ForeignConfigurationParser;
import com.oracle.svm.configure.UnresolvedConfigurationCondition;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.graal.compiler.util.json.JsonPrintable;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class ForeignConfiguration
extends ConfigurationBase<ForeignConfiguration, Predicate> {
    private final Set<StubDesc> downcallStubs = ConcurrentHashMap.newKeySet();
    private final Set<StubDesc> upcallStubs = ConcurrentHashMap.newKeySet();
    private final Set<DirectStubDesc> directUpcallStubs = ConcurrentHashMap.newKeySet();

    public ForeignConfiguration() {
    }

    public ForeignConfiguration(ForeignConfiguration other) {
        this.downcallStubs.addAll(other.downcallStubs);
        this.upcallStubs.addAll(other.upcallStubs);
        this.directUpcallStubs.addAll(other.directUpcallStubs);
    }

    @Override
    public ForeignConfiguration copy() {
        return new ForeignConfiguration(this);
    }

    @Override
    protected void merge(ForeignConfiguration other) {
        this.downcallStubs.addAll(other.downcallStubs);
        this.upcallStubs.addAll(other.upcallStubs);
        this.directUpcallStubs.addAll(other.directUpcallStubs);
        this.directUpcallStubs.removeIf((? super E e) -> e.desc != null && this.directUpcallStubs.contains(e.withoutFD()));
    }

    @Override
    protected void intersect(ForeignConfiguration other) {
        this.downcallStubs.retainAll(other.downcallStubs);
        this.upcallStubs.retainAll(other.upcallStubs);
        HashSet<DirectStubDesc> tmp = new HashSet<DirectStubDesc>();
        for (DirectStubDesc e : this.directUpcallStubs) {
            if (!other.directUpcallStubs.contains(e) && !other.directUpcallStubs.contains(e.withoutFD())) continue;
            tmp.add(e);
        }
        for (DirectStubDesc e : other.directUpcallStubs) {
            if (!this.directUpcallStubs.contains(e) && !this.directUpcallStubs.contains(e.withoutFD())) continue;
            tmp.add(e);
        }
        this.directUpcallStubs.clear();
        this.directUpcallStubs.addAll(tmp);
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.downcallStubs.removeIf((? super E element) -> predicate.testDowncall(element.desc, element.linkerOptions));
        this.upcallStubs.removeIf((? super E element) -> predicate.testUpcall(element.desc, element.linkerOptions));
        this.directUpcallStubs.removeIf((? super E element) -> predicate.testDirectUpcall(element.clazz, element.method, element.desc, element.linkerOptions));
    }

    @Override
    public void subtract(ForeignConfiguration other) {
        this.downcallStubs.removeAll(other.downcallStubs);
        this.upcallStubs.removeAll(other.upcallStubs);
        this.directUpcallStubs.removeAll(other.directUpcallStubs);
    }

    @Override
    public void mergeConditional(UnresolvedConfigurationCondition condition, ForeignConfiguration other) {
        this.merge(other);
    }

    public void addDowncall(String returnType, List<String> parameterTypes, Map<String, Object> linkerOptions) {
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(parameterTypes);
        this.addDowncall(new ConfigurationFunctionDescriptor(returnType, parameterTypes), Map.copyOf(linkerOptions));
    }

    public void addUpcall(String returnType, List<String> parameterTypes, Map<String, Object> linkerOptions) {
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(parameterTypes);
        this.addUpcall(new ConfigurationFunctionDescriptor(returnType, parameterTypes), Map.copyOf(linkerOptions));
    }

    public void addDirectUpcall(String returnType, List<String> parameterTypes, Map<String, Object> linkerOptions, String clazz, String method) {
        Objects.requireNonNull(returnType);
        Objects.requireNonNull(parameterTypes);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(method);
        this.addDirectUpcall(new ConfigurationFunctionDescriptor(returnType, parameterTypes), Map.copyOf(linkerOptions), clazz, method);
    }

    public void addDowncall(ConfigurationFunctionDescriptor desc, Map<String, Object> linkerOptions) {
        Objects.requireNonNull(desc);
        this.downcallStubs.add(new StubDesc(desc, Map.copyOf(linkerOptions)));
    }

    public void addUpcall(ConfigurationFunctionDescriptor desc, Map<String, Object> linkerOptions) {
        Objects.requireNonNull(desc);
        this.upcallStubs.add(new StubDesc(desc, Map.copyOf(linkerOptions)));
    }

    public void addDirectUpcall(ConfigurationFunctionDescriptor desc, Map<String, Object> linkerOptions, String clazz, String method) {
        Objects.requireNonNull(desc);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(method);
        DirectStubDesc candidate = new DirectStubDesc(clazz, method, desc, Map.copyOf(linkerOptions));
        if (!this.directUpcallStubs.contains(candidate.withoutFD())) {
            this.directUpcallStubs.add(candidate);
        }
    }

    public void addDirectUpcall(Map<String, Object> linkerOptions, String clazz, String method) {
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(method);
        DirectStubDesc directStubDesc = new DirectStubDesc(clazz, method, null, Map.copyOf(linkerOptions));
        this.directUpcallStubs.removeIf((? super E existing) -> directStubDesc.equals(existing.withoutFD()));
        this.directUpcallStubs.add(directStubDesc);
    }

    public void printJson(JsonWriter writer) throws IOException {
        Map<String, Set<DirectStubDesc>> stubSets = Map.of("downcalls", this.downcallStubs, "upcalls", this.upcallStubs, "directUpcalls", this.directUpcallStubs);
        writer.appendObjectStart();
        boolean first = true;
        for (String sectionName : stubSets.keySet()) {
            Collection stubs = stubSets.get(sectionName);
            if (stubs.isEmpty()) continue;
            if (!first) {
                writer.appendSeparator();
            }
            writer.quote(sectionName).appendFieldSeparator().appendArrayStart();
            ForeignConfiguration.printStubs(writer, stubs);
            writer.appendArrayEnd();
            first = false;
        }
        writer.appendObjectEnd();
    }

    private static void printStubs(JsonWriter writer, Collection<? extends JsonPrintable> stubs) throws IOException {
        boolean first = true;
        for (JsonPrintable jsonPrintable : stubs) {
            if (first) {
                first = false;
            } else {
                writer.appendSeparator();
            }
            jsonPrintable.printJson(writer);
        }
    }

    @Override
    public ConfigurationParser createParser(boolean combinedFileSchema, EnumSet<ConfigurationParserOption> parserOptions) {
        if (!combinedFileSchema) {
            throw new IllegalArgumentException("Foreign configuration is only supported with reachability-metadata.json");
        }
        return new UnresolvedForeignConfigurationParser(parserOptions);
    }

    @Override
    public boolean isEmpty() {
        return this.downcallStubs.isEmpty() && this.upcallStubs.isEmpty() && this.directUpcallStubs.isEmpty();
    }

    @Override
    public boolean supportsCombinedFile() {
        return true;
    }

    private record DirectStubDesc(String clazz, String method, ConfigurationFunctionDescriptor desc, Map<String, Object> linkerOptions) implements JsonPrintable
    {
        public void printJson(JsonWriter writer) throws IOException {
            writer.appendObjectStart().appendKeyValue("class", (Object)this.clazz).appendSeparator().appendKeyValue("method", (Object)this.method).appendSeparator();
            if (this.desc != null) {
                this.desc.printJson(writer);
            }
            if (!this.linkerOptions.isEmpty()) {
                writer.appendSeparator().quote("options").appendFieldSeparator().print(this.linkerOptions);
            }
            writer.appendObjectEnd();
        }

        public DirectStubDesc withoutFD() {
            if (this.desc == null) {
                return this;
            }
            return new DirectStubDesc(this.clazz, this.method, null, this.linkerOptions);
        }
    }

    public static interface Predicate {
        public boolean testDowncall(ConfigurationFunctionDescriptor var1, Map<String, Object> var2);

        public boolean testUpcall(ConfigurationFunctionDescriptor var1, Map<String, Object> var2);

        public boolean testDirectUpcall(String var1, String var2, ConfigurationFunctionDescriptor var3, Map<String, Object> var4);
    }

    public record ConfigurationFunctionDescriptor(String returnType, List<String> parameterTypes) implements JsonPrintable
    {
        public void printJson(JsonWriter writer) throws IOException {
            writer.appendKeyValue("returnType", (Object)this.returnType).appendSeparator().quote("parameterTypes").appendFieldSeparator().print(this.parameterTypes);
        }
    }

    private record StubDesc(ConfigurationFunctionDescriptor desc, Map<String, Object> linkerOptions) implements JsonPrintable
    {
        public void printJson(JsonWriter writer) throws IOException {
            writer.appendObjectStart();
            this.desc.printJson(writer);
            if (!this.linkerOptions.isEmpty()) {
                writer.appendSeparator().quote("options").appendFieldSeparator().print(this.linkerOptions);
            }
            writer.appendObjectEnd();
        }
    }

    private final class UnresolvedForeignConfigurationParser
    extends ForeignConfigurationParser<ConfigurationFunctionDescriptor, Map<String, Object>> {
        private UnresolvedForeignConfigurationParser(EnumSet<ConfigurationParserOption> parserOptions) {
            super(parserOptions);
        }

        @Override
        protected void registerDowncall(ConfigurationCondition configurationCondition, ConfigurationFunctionDescriptor descriptor, Map<String, Object> options) {
            ForeignConfiguration.this.addDowncall(descriptor, options);
        }

        @Override
        protected void registerUpcall(ConfigurationCondition configurationCondition, ConfigurationFunctionDescriptor descriptor, Map<String, Object> options) {
            ForeignConfiguration.this.addUpcall(descriptor, options);
        }

        @Override
        protected void registerDirectUpcallWithoutDescriptor(String className, String methodName, EconomicMap<String, Object> optionsMap) {
            ForeignConfiguration.this.addDirectUpcall(UnresolvedForeignConfigurationParser.economicMapToJavaMap(optionsMap), className, methodName);
        }

        @Override
        protected void registerDirectUpcallWithDescriptor(String className, String methodName, ConfigurationFunctionDescriptor descriptor, Map<String, Object> options) {
            ForeignConfiguration.this.addDirectUpcall(descriptor, options, className, methodName);
        }

        @Override
        protected void handleRegistrationError(Exception e, EconomicMap<String, Object> map) {
            throw new RuntimeException("Should not be reached", e);
        }

        @Override
        protected ConfigurationFunctionDescriptor createFunctionDescriptor(String returnType, List<String> parameterTypes) {
            return new ConfigurationFunctionDescriptor(returnType, parameterTypes);
        }

        @Override
        protected Map<String, Object> createDowncallOptions(EconomicMap<String, Object> map, ConfigurationFunctionDescriptor desc) {
            return UnresolvedForeignConfigurationParser.economicMapToJavaMap(map);
        }

        @Override
        protected Map<String, Object> createUpcallOptions(EconomicMap<String, Object> map, ConfigurationFunctionDescriptor desc) {
            return UnresolvedForeignConfigurationParser.economicMapToJavaMap(map);
        }

        private static Map<String, Object> economicMapToJavaMap(EconomicMap<String, Object> map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            MapCursor cursor = map.getEntries();
            while (cursor.advance()) {
                result.put((String)cursor.getKey(), cursor.getValue());
            }
            return result;
        }
    }
}

