/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.classfile.attributes;

import com.oracle.svm.espresso.classfile.attributes.Attribute;
import com.oracle.svm.espresso.classfile.attributes.LineNumberTableRef;
import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import java.util.AbstractList;
import java.util.List;

public final class LineNumberTableAttribute
extends Attribute
implements LineNumberTableRef {
    public static final Symbol<Name> NAME = ParserSymbols.ParserNames.LineNumberTable;
    public static final LineNumberTableAttribute EMPTY = new LineNumberTableAttribute(NAME, new char[0]);
    private final char[] bciToLineEntries;
    private int lastLine = -1;

    public LineNumberTableAttribute(Symbol<Name> name, char[] entries) {
        assert (name == NAME);
        assert (entries.length % 2 == 0);
        this.bciToLineEntries = entries;
    }

    public List<Entry> getEntries() {
        return new ListWrapper();
    }

    private int length() {
        return this.bciToLineEntries.length >> 1;
    }

    public int getLineNumber(int atBci) {
        for (int i = 0; i < this.length() - 1; ++i) {
            if (this.bciAt(i) > atBci || atBci >= this.bciAt(i + 1)) continue;
            return this.lineAt(i);
        }
        return this.lineAt(this.length() - 1);
    }

    public long getBCI(int line) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.lineAt(i) != line) continue;
            return this.bciAt(i);
        }
        return -1L;
    }

    public int getLastLine() {
        if (this.lastLine != -1) {
            return this.lastLine;
        }
        int max = -1;
        for (int i = 0; i < this.length(); ++i) {
            max = Math.max(max, this.lineAt(i));
        }
        this.lastLine = max;
        return this.lastLine;
    }

    private int bciAt(int i) {
        return this.bciToLineEntries[i * 2];
    }

    private int lineAt(int i) {
        return this.bciToLineEntries[i * 2 + 1];
    }

    @Override
    public Symbol<Name> getName() {
        return NAME;
    }

    private final class ListWrapper
    extends AbstractList<Entry> {
        private ListWrapper() {
        }

        @Override
        public Entry get(int index) {
            if (index >= 0 && index < this.size()) {
                return new Entry(LineNumberTableAttribute.this.bciAt(index), LineNumberTableAttribute.this.lineAt(index));
            }
            throw new IndexOutOfBoundsException("index " + index + " out of bounds for list of size " + LineNumberTableAttribute.this.length() + ".");
        }

        @Override
        public int size() {
            return LineNumberTableAttribute.this.length();
        }
    }

    public static final class Entry
    implements LineNumberTableRef.EntryRef {
        private final int bci;
        private final int lineNumber;

        public Entry(int bci, int lineNumber) {
            this.bci = bci;
            this.lineNumber = lineNumber;
        }

        @Override
        public int getBCI() {
            return this.bci;
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

