/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.classfile.descriptors.ParserSymbols;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;

final class ArrayOperand<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>>
extends Operand<R, C, M, F> {
    private final int dimensions;
    private final Operand<R, C, M, F> elemental;
    private Operand<R, C, M, F> component = null;

    ArrayOperand(Operand<R, C, M, F> elemental, int dimensions) {
        super(JavaKind.Object);
        assert (!elemental.isArrayType());
        if (dimensions > 255) {
            throw MethodVerifier.failVerify("Creating array of dimension > 255");
        }
        this.dimensions = dimensions;
        this.elemental = elemental;
    }

    ArrayOperand(Operand<R, C, M, F> elemental) {
        this(elemental, 1);
    }

    @Override
    boolean compliesWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        if (other.isArrayType()) {
            if (other.getDimensions() < this.getDimensions()) {
                return other.getElemental().isReference() && (other.getElemental().getType() == ParserSymbols.ParserTypes.java_lang_Object || other.getElemental().getType() == ParserSymbols.ParserTypes.java_lang_Cloneable || other.getElemental().getType() == ParserSymbols.ParserTypes.java_io_Serializable);
            }
            if (other.getDimensions() == this.getDimensions()) {
                return this.elemental.compliesWith(other.getElemental(), methodVerifier);
            }
            return false;
        }
        return other.isTopOperand() || other.isReference() && (other.getType() == ParserSymbols.ParserTypes.java_lang_Object || other.getType() == ParserSymbols.ParserTypes.java_lang_Cloneable || other.getType() == ParserSymbols.ParserTypes.java_io_Serializable);
    }

    @Override
    Operand<R, C, M, F> mergeWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        int thisDim;
        assert (!this.compliesWithInMerge(other, methodVerifier)) : "mergeWith method should only be called for non-compatible operands.";
        if (!other.isReference()) {
            return null;
        }
        if (other.isNull()) {
            return this;
        }
        if (!other.isArrayType()) {
            return methodVerifier.jlObject;
        }
        Operand<R, C, M, F> thisElemental = this.getElemental();
        Operand<R, C, M, F> otherElemental = other.getElemental();
        int otherDim = other.getDimensions();
        if (otherDim == (thisDim = this.getDimensions())) {
            if (thisElemental.isPrimitive() || otherElemental.isPrimitive()) {
                assert (!this.compliesWithInMerge(other, methodVerifier));
                if (thisDim == 1) {
                    return methodVerifier.jlObject;
                }
                return new ArrayOperand(methodVerifier.jlObject, thisDim - 1);
            }
            return new ArrayOperand<R, C, M, F>(thisElemental.mergeWith(otherElemental, methodVerifier), thisDim);
        }
        Operand<R, C, M, F> smallestElemental = thisDim < otherDim ? thisElemental : otherElemental;
        int newDim = Math.min(thisDim, otherDim);
        if (smallestElemental.isPrimitive()) {
            if (newDim == 1) {
                return methodVerifier.jlObject;
            }
            return new ArrayOperand(methodVerifier.jlObject, newDim - 1);
        }
        if (smallestElemental.getType() == ParserSymbols.ParserTypes.java_lang_Cloneable || smallestElemental.getType() == ParserSymbols.ParserTypes.java_io_Serializable) {
            return new ArrayOperand<R, C, M, F>(smallestElemental, newDim);
        }
        return new ArrayOperand(methodVerifier.jlObject, newDim);
    }

    @Override
    boolean isReference() {
        return true;
    }

    @Override
    boolean isArrayType() {
        return true;
    }

    @Override
    Operand<R, C, M, F> getComponent() {
        if (this.component == null) {
            this.component = this.dimensions == 1 ? this.elemental : new ArrayOperand<R, C, M, F>(this.elemental, this.dimensions - 1);
        }
        return this.component;
    }

    @Override
    Operand<R, C, M, F> getElemental() {
        return this.elemental;
    }

    public String toString() {
        if (this.dimensions == 1) {
            return "[" + String.valueOf(this.getElemental());
        }
        return "[dim:" + this.dimensions + "]" + String.valueOf(this.getElemental());
    }

    @Override
    int getDimensions() {
        return this.dimensions;
    }
}

