/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;
import com.oracle.svm.espresso.shared.verifier.ReferenceOperand;
import com.oracle.svm.espresso.shared.verifier.StackFrame;
import com.oracle.svm.espresso.shared.verifier.UninitReferenceOperand;

final class OperandStack<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> {
    final MethodVerifier<R, C, M, F> mv;
    final Operand<R, C, M, F>[] stack;
    int top;
    int size;

    OperandStack(MethodVerifier<R, C, M, F> mv, int maxStack) {
        this.mv = mv;
        this.stack = new Operand[maxStack];
        this.top = 0;
        this.size = 0;
    }

    public Operand<R, C, M, F>[] extract() {
        Operand[] result = new Operand[this.top];
        System.arraycopy(this.stack, 0, result, 0, this.top);
        return result;
    }

    void procSize(int modif) {
        this.size += modif;
        MethodVerifier.verifyGuarantee(this.size <= this.stack.length, "insufficent stack size: " + this.stack.length);
        MethodVerifier.verifyGuarantee(this.size >= 0, "invalid stack access: " + this.size);
    }

    void pushInt() {
        this.push(this.mv.intOp);
    }

    void pushFloat() {
        this.push(this.mv.floatOp);
    }

    void pushDouble() {
        this.push(this.mv.doubleOp);
    }

    void pushLong() {
        this.push(this.mv.longOp);
    }

    void push(Operand<R, C, M, F> kind) {
        this.procSize(kind.slots());
        this.stack[this.top++] = kind.getKind().isStackInt() ? this.mv.intOp : kind;
    }

    private Operand<R, C, M, F> popAny() {
        MethodVerifier.verifyGuarantee(this.top > 0, "Popping an empty stack");
        Operand<R, C, M, F> op = this.stack[--this.top];
        this.procSize(-op.slots());
        return op;
    }

    Operand<R, C, M, F> popRef() {
        Operand<R, C, M, F> op = this.popAny();
        MethodVerifier.verifyGuarantee(op.isReference(), "Invalid operand. Expected a reference, found: " + String.valueOf(op));
        return op;
    }

    Operand<R, C, M, F> popRef(Operand<R, C, M, F> kind) {
        Operand<R, C, M, F> op = this.popRef();
        MethodVerifier.verifyGuarantee(op.compliesWith(kind, this.mv), "Type check error: " + String.valueOf(op) + " cannot be merged into " + String.valueOf(kind));
        return op;
    }

    public Operand<R, C, M, F> popUninitRef(Operand<R, C, M, F> kind) {
        Operand<R, C, M, F> op = this.popRef(kind);
        MethodVerifier.verifyGuarantee(op.isUninit(), "Calling initialization method on already initialized reference.");
        return op;
    }

    Operand<R, C, M, F> popArray() {
        Operand<R, C, M, F> op = this.popRef();
        MethodVerifier.verifyGuarantee(op == this.mv.nullOp || op.isArrayType(), "Invalid operand. Expected array, found: " + String.valueOf(op));
        return op;
    }

    void popInt() {
        this.pop(this.mv.intOp);
    }

    void popFloat() {
        this.pop(this.mv.floatOp);
    }

    void popDouble() {
        this.pop(this.mv.doubleOp);
    }

    void popLong() {
        this.pop(this.mv.longOp);
    }

    Operand<R, C, M, F> popObjOrRA() {
        Operand<R, C, M, F> op = this.popAny();
        MethodVerifier.verifyGuarantee(op.isReference() || op.isReturnAddress(), String.valueOf(op) + " on stack, required: Reference or ReturnAddress");
        return op;
    }

    Operand<R, C, M, F> pop(Operand<R, C, M, F> k) {
        if (!k.getKind().isStackInt() || k == this.mv.intOp) {
            Operand<R, C, M, F> op = this.popAny();
            MethodVerifier.verifyGuarantee(op.compliesWith(k, this.mv), String.valueOf(op) + " on stack, required: " + String.valueOf(k));
            return op;
        }
        return this.pop(this.mv.intOp);
    }

    void dup() {
        this.procSize(1);
        Operand<R, C, M, F> v = this.stack[this.top - 1];
        MethodVerifier.verifyGuarantee(!v.isType2(), "type 2 operand for dup.");
        MethodVerifier.verifyGuarantee(!v.isTopOperand(), "dup of Top type.");
        this.stack[this.top] = v;
        ++this.top;
    }

    void pop() {
        this.procSize(-1);
        Operand<R, C, M, F> v = this.stack[this.top - 1];
        MethodVerifier.verifyGuarantee(!v.isType2(), "type 2 operand for pop.");
        MethodVerifier.verifyGuarantee(!v.isTopOperand(), "dup2x2 of Top type.");
        --this.top;
    }

    void pop2() {
        this.procSize(-2);
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        MethodVerifier.verifyGuarantee(!v1.isTopOperand(), "dup2x2 of Top type.");
        if (v1.isType2()) {
            --this.top;
            return;
        }
        Operand<R, C, M, F> v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!v2.isTopOperand(), "dup2x2 of Top type.");
        MethodVerifier.verifyGuarantee(!v2.isType2(), "type 2 second operand for pop2.");
        this.top -= 2;
    }

    void dupx1() {
        this.procSize(1);
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        Operand<R, C, M, F> v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!v1.isType2() && !v2.isType2(), "type 2 operand for dupx1.");
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dupx1 of Top type.");
        System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
        ++this.top;
        this.stack[this.top - 3] = v1;
    }

    void dupx2() {
        this.procSize(1);
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        Operand<R, C, M, F> v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!v1.isType2(), "type 2 first operand for dupx2.");
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dupx2 of Top type.");
        if (v2.isType2()) {
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
            ++this.top;
            this.stack[this.top - 3] = v1;
        } else {
            Operand<R, C, M, F> v3 = this.stack[this.top - 3];
            MethodVerifier.verifyGuarantee(!v3.isType2(), "type 2 third operand for dupx2.");
            MethodVerifier.verifyGuarantee(!v3.isTopOperand(), "dupx2 of Top type.");
            System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 2, 3);
            ++this.top;
            this.stack[this.top - 4] = v1;
        }
    }

    void dup2() {
        this.procSize(2);
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        if (v1.isType2()) {
            this.stack[this.top] = v1;
            ++this.top;
        } else {
            Operand<R, C, M, F> v2 = this.stack[this.top - 2];
            MethodVerifier.verifyGuarantee(!v2.isType2(), "type 2 second operand for dup2.");
            MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dup2 of Top type.");
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top, 2);
            this.top += 2;
        }
    }

    void dup2x1() {
        this.procSize(2);
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        Operand<R, C, M, F> v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!v2.isType2(), "type 2 second operand for dup2x1");
        MethodVerifier.verifyGuarantee(!v2.isTopOperand() && !v1.isTopOperand(), "dup2x1 of Top type.");
        if (v1.isType2()) {
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
            ++this.top;
            this.stack[this.top - 3] = v1;
            return;
        }
        Operand<R, C, M, F> v3 = this.stack[this.top - 3];
        MethodVerifier.verifyGuarantee(!v3.isType2(), "type 2 third operand for dup2x1.");
        MethodVerifier.verifyGuarantee(!v3.isTopOperand(), "dup2x1 of Top type.");
        System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 1, 3);
        this.top += 2;
        this.stack[this.top - 5] = v2;
        this.stack[this.top - 4] = v1;
    }

    void dup2x2() {
        this.procSize(2);
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        Operand<R, C, M, F> v2 = this.stack[this.top - 2];
        boolean b1 = v1.isType2();
        boolean b2 = v2.isType2();
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "dup2x2 of Top type.");
        if (b1 && b2) {
            System.arraycopy(this.stack, this.top - 2, this.stack, this.top - 1, 2);
            this.stack[this.top - 2] = v1;
            ++this.top;
            return;
        }
        Operand<R, C, M, F> v3 = this.stack[this.top - 3];
        boolean b3 = v3.isType2();
        MethodVerifier.verifyGuarantee(!v3.isTopOperand(), "dup2x2 of Top type.");
        if (!b1 && !b2 && b3) {
            System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 1, 3);
            this.stack[this.top - 3] = v2;
            this.stack[this.top - 2] = v1;
            this.top += 2;
            return;
        }
        if (b1 && !b2 && !b3) {
            System.arraycopy(this.stack, this.top - 3, this.stack, this.top - 2, 3);
            this.stack[this.top - 3] = v1;
            ++this.top;
            return;
        }
        Operand<R, C, M, F> v4 = this.stack[this.top - 4];
        MethodVerifier.verifyGuarantee(!v4.isTopOperand(), "dup2x2 of Top type.");
        boolean b4 = v4.isType2();
        if (!(b1 || b2 || b3 || b4)) {
            System.arraycopy(this.stack, this.top - 4, this.stack, this.top - 2, 4);
            this.stack[this.top - 4] = v2;
            this.stack[this.top - 3] = v1;
            this.top += 2;
            return;
        }
        throw MethodVerifier.failVerify("Calling dup2x2 with operands: " + String.valueOf(v1) + ", " + String.valueOf(v2) + ", " + String.valueOf(v3) + ", " + String.valueOf(v4));
    }

    void swap() {
        Operand<R, C, M, F> v1 = this.stack[this.top - 1];
        Operand<R, C, M, F> v2 = this.stack[this.top - 2];
        MethodVerifier.verifyGuarantee(!v1.isType2() && !v2.isType2(), "Type 2 operand for SWAP");
        MethodVerifier.verifyGuarantee(!v1.isTopOperand() && !v2.isTopOperand(), "swap of Top type.");
        this.stack[this.top - 1] = v2;
        this.stack[this.top - 2] = v1;
    }

    int mergeInto(StackFrame<R, C, M, F> stackFrame) {
        MethodVerifier.verifyGuarantee(this.size == stackFrame.stackSize, "Inconsistent stack height: " + this.size + " != " + stackFrame.stackSize);
        int secondIndex = 0;
        for (int index = 0; index < this.top; ++index) {
            Operand op2;
            Operand op1 = this.stack[index];
            if (!op1.compliesWithInMerge(op2 = stackFrame.stack[secondIndex++], this.mv)) {
                return index;
            }
            if (!op1.isType2() || !op2.isTopOperand()) continue;
            MethodVerifier.verifyGuarantee(stackFrame.stack[secondIndex++].isTopOperand(), "Inconsistent stack Map: " + String.valueOf(op1) + " vs. " + String.valueOf(op2) + " and " + String.valueOf(stackFrame.stack[secondIndex - 1]));
        }
        return -1;
    }

    Operand<R, C, M, F> initUninit(UninitReferenceOperand<R, C, M, F> toInit) {
        ReferenceOperand<R, C, M, F> init = toInit.init();
        for (int i = 0; i < this.top; ++i) {
            if (!this.stack[i].isUninit() || ((UninitReferenceOperand)this.stack[i]).newBCI != toInit.newBCI) continue;
            this.stack[i] = init;
        }
        return init;
    }
}

