/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.classfile.JavaKind;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;
import com.oracle.svm.espresso.shared.verifier.PrimitiveOperand;
import java.util.ArrayList;

final class ReturnAddressOperand<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>>
extends PrimitiveOperand<R, C, M, F> {
    final ArrayList<Integer> targetBCIs = new ArrayList();
    final int subroutineBCI;

    ReturnAddressOperand(int target, int subroutineBCI) {
        super(JavaKind.ReturnAddress);
        this.targetBCIs.add(target);
        this.subroutineBCI = subroutineBCI;
    }

    private ReturnAddressOperand(ArrayList<Integer> bcis, int subroutineBCI) {
        super(JavaKind.ReturnAddress);
        this.targetBCIs.addAll(bcis);
        this.subroutineBCI = subroutineBCI;
    }

    @Override
    boolean isReturnAddress() {
        return true;
    }

    @Override
    boolean compliesWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        if (other.isTopOperand()) {
            return true;
        }
        if (other.isReturnAddress()) {
            ReturnAddressOperand ra = (ReturnAddressOperand)other;
            if (ra.subroutineBCI != this.subroutineBCI) {
                return false;
            }
            for (Integer target : this.targetBCIs) {
                if (ra.targetBCIs.contains(target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    Operand<R, C, M, F> mergeWith(Operand<R, C, M, F> other, MethodVerifier<R, C, M, F> methodVerifier) {
        assert (!this.compliesWithInMerge(other, methodVerifier)) : "mergeWith method should only be called for non-compatible operands.";
        if (!other.isReturnAddress()) {
            return null;
        }
        ReturnAddressOperand otherRA = (ReturnAddressOperand)other;
        if (otherRA.subroutineBCI != this.subroutineBCI) {
            return null;
        }
        ReturnAddressOperand<R, C, M, F> ra = new ReturnAddressOperand<R, C, M, F>(otherRA.targetBCIs, this.subroutineBCI);
        for (Integer target : this.targetBCIs) {
            if (ra.targetBCIs.contains(target)) continue;
            ra.targetBCIs.add(target);
        }
        return ra;
    }
}

