/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.verifier;

import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.RuntimeAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.verifier.Locals;
import com.oracle.svm.espresso.shared.verifier.MethodVerifier;
import com.oracle.svm.espresso.shared.verifier.Operand;
import com.oracle.svm.espresso.shared.verifier.OperandStack;
import com.oracle.svm.espresso.shared.verifier.StackMapFrameParser;
import com.oracle.svm.espresso.shared.verifier.SubroutineModificationStack;
import com.oracle.svm.espresso.shared.verifier.VerificationTypeInfo;

class StackFrame<R extends RuntimeAccess<C, M, F>, C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>>
implements StackMapFrameParser.FrameState<StackFrame<R, C, M, F>, MethodVerifier<R, C, M, F>> {
    final MethodVerifier<R, C, M, F> mv;
    final Operand<R, C, M, F>[] stack;
    final int stackSize;
    final int top;
    final Operand<R, C, M, F>[] locals;
    final SubroutineModificationStack subroutineModificationStack;

    StackFrame(MethodVerifier<R, C, M, F> mv, OperandStack<R, C, M, F> stack, Locals<R, C, M, F> locals) {
        this.mv = mv;
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals.extract();
        this.subroutineModificationStack = locals.subRoutineModifications;
    }

    StackFrame(MethodVerifier<R, C, M, F> mv, OperandStack<R, C, M, F> stack, Operand<R, C, M, F>[] locals) {
        this(mv, stack, locals, null);
    }

    StackFrame(MethodVerifier<R, C, M, F> mv, OperandStack<R, C, M, F> stack, Operand<R, C, M, F>[] locals, SubroutineModificationStack sms) {
        this.mv = mv;
        this.stack = stack.extract();
        this.stackSize = stack.size;
        this.top = stack.top;
        this.locals = locals;
        this.subroutineModificationStack = sms;
    }

    StackFrame(MethodVerifier<R, C, M, F> mv) {
        this(mv, new OperandStack<R, C, M, F>(mv, mv.getMaxStack()), new Locals<R, C, M, F>(mv));
    }

    StackFrame(MethodVerifier<R, C, M, F> mv, Operand<R, C, M, F>[] stack, int stackSize, int top, Operand<R, C, M, F>[] locals) {
        this.mv = mv;
        this.stack = stack;
        this.stackSize = stackSize;
        this.top = top;
        this.locals = locals;
        this.subroutineModificationStack = null;
    }

    StackFrame(MethodVerifier<R, C, M, F> mv, Operand<R, C, M, F>[] stack, int stackSize, int top, Operand<R, C, M, F>[] locals, SubroutineModificationStack sms) {
        this.mv = mv;
        this.stack = stack;
        this.stackSize = stackSize;
        this.top = top;
        this.locals = locals;
        this.subroutineModificationStack = sms;
    }

    OperandStack<R, C, M, F> extractStack(int maxStack) {
        OperandStack<R, C, M, F> res = new OperandStack<R, C, M, F>(this.mv, maxStack);
        System.arraycopy(this.stack, 0, res.stack, 0, this.top);
        res.size = this.stackSize;
        res.top = this.top;
        return res;
    }

    Locals<R, C, M, F> extractLocals() {
        Locals<R, C, M, F> newLocals = new Locals<R, C, M, F>(this.mv, (Operand[])this.locals.clone());
        newLocals.subRoutineModifications = this.subroutineModificationStack;
        return newLocals;
    }

    void mergeSubroutines(SubroutineModificationStack other) {
        if (this.subroutineModificationStack == null) {
            return;
        }
        if (other == this.subroutineModificationStack) {
            return;
        }
        this.subroutineModificationStack.merge(other);
    }

    public StackFrame<R, C, M, F> sameNoStack() {
        return new StackFrame<R, C, M, F>(this.mv, Operand.emptyArray(), 0, 0, this.locals);
    }

    public StackFrame<R, C, M, F> sameLocalsWith1Stack(VerificationTypeInfo vfi, MethodVerifier<R, C, M, F> verifier) {
        Operand<R, C, M, F> op = verifier.getOperandFromVerificationType(vfi);
        MethodVerifier.formatGuarantee(op.slots() <= verifier.getMaxStack(), "Stack map entry requires more stack than allowed by maxStack.");
        OperandStack<R, C, M, F> newStack = new OperandStack<R, C, M, F>(verifier, 2);
        newStack.push(op);
        return new StackFrame<R, C, M, F>(this.mv, newStack, this.locals);
    }

    @Override
    public StackMapFrameParser.FrameAndLocalEffect<StackFrame<R, C, M, F>, MethodVerifier<R, C, M, F>> chop(int chop, int lastLocal, MethodVerifier<R, C, M, F> verifier) {
        Operand[] newLocals = (Operand[])this.locals.clone();
        int pos = lastLocal;
        for (int i = 0; i < chop; ++i) {
            MethodVerifier.formatGuarantee(pos >= 0, "Chop frame entry chops more locals than existing.");
            Operand op = newLocals[pos];
            if (op.isTopOperand() && pos > 0 && newLocals[pos - 1].isType2()) {
                --pos;
            }
            newLocals[pos] = verifier.invalidOp;
            --pos;
        }
        return new StackMapFrameParser.FrameAndLocalEffect<StackFrame<R, C, M, F>, MethodVerifier<R, C, M, F>>(new StackFrame<R, C, M, F>(this.mv, Operand.emptyArray(), 0, 0, newLocals), pos - lastLocal);
    }

    @Override
    public StackMapFrameParser.FrameAndLocalEffect<StackFrame<R, C, M, F>, MethodVerifier<R, C, M, F>> append(VerificationTypeInfo[] vfis, MethodVerifier<R, C, M, F> verifier, int lastLocal) {
        MethodVerifier.verifyGuarantee(vfis.length > 0, "Empty Append Frame in the StackmapTable");
        Operand[] newLocals = (Operand[])this.locals.clone();
        int pos = lastLocal;
        for (VerificationTypeInfo vti : vfis) {
            Operand<R, C, M, F> op = verifier.getOperandFromVerificationType(vti);
            verifier.setLocal(newLocals, op, ++pos, "Append frame entry in stack map appends more locals than allowed.");
            if (!op.isType2()) continue;
            verifier.setLocal(newLocals, verifier.invalidOp, ++pos, "Append frame entry in stack map appends more locals than allowed.");
        }
        return new StackMapFrameParser.FrameAndLocalEffect<StackFrame<R, C, M, F>, MethodVerifier<R, C, M, F>>(new StackFrame<R, C, M, F>(this.mv, Operand.emptyArray(), 0, 0, newLocals), pos - lastLocal);
    }
}

