/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.espresso.shared.vtable;

import com.oracle.svm.espresso.classfile.descriptors.Name;
import com.oracle.svm.espresso.classfile.descriptors.Signature;
import com.oracle.svm.espresso.classfile.descriptors.Symbol;
import com.oracle.svm.espresso.shared.meta.FieldAccess;
import com.oracle.svm.espresso.shared.meta.MethodAccess;
import com.oracle.svm.espresso.shared.meta.TypeAccess;
import com.oracle.svm.espresso.shared.vtable.FailingPartialMethod;
import com.oracle.svm.espresso.shared.vtable.MethodTableException;
import com.oracle.svm.espresso.shared.vtable.PartialMethod;
import com.oracle.svm.espresso.shared.vtable.PartialType;
import com.oracle.svm.espresso.shared.vtable.Tables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;

public final class VTable {
    public static <C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> Tables<C, M, F> create(PartialType<C, M, F> targetClass, boolean verbose, boolean allowInterfaceResolvingToPrivate, boolean addImplicitInterfaceMethods) throws MethodTableException {
        return new Builder<C, M, F>(targetClass, verbose, allowInterfaceResolvingToPrivate, addImplicitInterfaceMethods).build();
    }

    public static <C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> boolean isVirtualEntry(PartialMethod<C, M, F> m) {
        return !m.isPrivate() && !m.isStatic() && !m.isConstructor() && !m.isClassInitializer();
    }

    private static final class Builder<C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> {
        private final boolean verbose;
        private final boolean allowInterfaceResolvingToPrivate;
        private final boolean addMirandas;
        private final PartialType<C, M, F> targetClass;
        private final EconomicMap<MethodKey, Locations<C, M, F>> locations = EconomicMap.create();
        private final List<PartialMethod<C, M, F>> vtable = new ArrayList<PartialMethod<C, M, F>>();
        private final EconomicMap<C, List<PartialMethod<C, M, F>>> itables = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        private final List<PartialMethod<C, M, F>> mirandas = new ArrayList<PartialMethod<C, M, F>>();

        Builder(PartialType<C, M, F> targetClass, boolean verbose, boolean allowInterfaceResolvingToPrivate, boolean addMirandas) {
            this.targetClass = targetClass;
            this.verbose = verbose;
            this.allowInterfaceResolvingToPrivate = allowInterfaceResolvingToPrivate;
            this.addMirandas = addMirandas;
        }

        Tables<C, M, F> build() throws MethodTableException {
            this.buildLocations();
            this.assignCandidateTargets();
            this.resolveVirtual();
            this.resolveInterfaces();
            if (this.addMirandas) {
                this.resolveMirandas();
            }
            return new Tables<C, M, F>(this.vtable, this.itables, this.mirandas);
        }

        private void buildLocations() {
            this.registerFromTable(this.targetClass.getParentTable(), LocationKind.V);
            MapCursor cursor = this.targetClass.getInterfacesData().getEntries();
            while (cursor.advance()) {
                this.registerFromTable((List)cursor.getValue(), LocationKind.I);
            }
        }

        private void assignCandidateTargets() {
            for (PartialMethod<C, M, F> impl : this.targetClass.getDeclaredMethodsList()) {
                MethodKey k;
                if (!VTable.isVirtualEntry(impl) || !this.locations.containsKey((Object)(k = MethodKey.of(impl)))) continue;
                Locations entries = (Locations)this.locations.get((Object)k);
                entries.setTarget(impl);
            }
        }

        private void resolveVirtual() throws MethodTableException {
            MethodKey k;
            List<M> parentTable = this.targetClass.getParentTable();
            for (int i = 0; i < parentTable.size(); ++i) {
                MethodAccess parentMethod = (MethodAccess)parentTable.get(i);
                k = MethodKey.of(parentMethod);
                assert (this.locations.containsKey((Object)k)) : "Should have been populated with super table.";
                Locations currentLocations = (Locations)this.locations.get((Object)k);
                PartialMethod declaredMethod = currentLocations.target;
                if (declaredMethod != null) {
                    assert (parentMethod.getDeclaringClass().isInterface() || currentLocations.vLookup(i) == parentMethod) : "Should have been populated with super table.";
                    if (this.canOverride(declaredMethod, parentMethod, i)) {
                        if (parentMethod.isFinalFlagSet()) {
                            throw new MethodTableException("Method " + String.valueOf(declaredMethod.getSymbolicName()) + String.valueOf(declaredMethod.getSymbolicSignature()) + " from type " + String.valueOf(this.targetClass.getSymbolicName()) + " overrides final method " + String.valueOf(parentMethod.getSymbolicName()) + String.valueOf(declaredMethod.getSymbolicSignature()) + " from type " + String.valueOf(parentMethod.getDeclaringClass().getSymbolicName()), MethodTableException.Kind.IncompatibleClassChangeError);
                        }
                        if (!this.verbose && this.sameOverrideAccess(declaredMethod, parentMethod)) {
                            declaredMethod = currentLocations.markEquivalentEntry(declaredMethod, i);
                        }
                        this.vtable.add(declaredMethod);
                        continue;
                    }
                }
                PartialMethod entry = parentMethod;
                if (parentMethod.getDeclaringClass().isInterface()) {
                    PartialMethod ma;
                    entry = currentLocations.resolve(k, this, true);
                    if (entry instanceof MethodAccess && (ma = entry).getDeclaringClass() == parentMethod.getDeclaringClass()) {
                        assert (parentMethod.hasVTableIndex());
                        this.vtable.add(parentMethod);
                        continue;
                    }
                    this.vtable.add(entry.withVTableIndex(i));
                    continue;
                }
                this.vtable.add(entry);
            }
            assert (this.vtable.size() == parentTable.size());
            for (PartialMethod<C, M, F> declaredMethod : this.targetClass.getDeclaredMethodsList()) {
                if (!VTable.isVirtualEntry(declaredMethod)) continue;
                if (this.verbose) {
                    this.vtable.add(declaredMethod.withVTableIndex(this.vtable.size()));
                    continue;
                }
                k = MethodKey.of(declaredMethod);
                Locations loc = (Locations)this.locations.get((Object)k);
                if (loc != null && !loc.shouldPopulate()) continue;
                this.vtable.add(declaredMethod.withVTableIndex(this.vtable.size()));
            }
        }

        private void resolveInterfaces() {
            MapCursor cursor = this.targetClass.getInterfacesData().getEntries();
            while (cursor.advance()) {
                List parentTable = (List)cursor.getValue();
                ArrayList table = new ArrayList(((List)cursor.getValue()).size());
                for (MethodAccess m : parentTable) {
                    if (!VTable.isVirtualEntry(m)) {
                        table.add(m);
                        continue;
                    }
                    MethodKey k = MethodKey.of(m);
                    table.add(((Locations)this.locations.get((Object)k)).resolve(k, this, false));
                }
                this.itables.put((Object)((TypeAccess)cursor.getKey()), table);
            }
        }

        private void resolveMirandas() {
            for (int i = 0; i < this.mirandas.size(); ++i) {
                PartialMethod<C, M, F> m = this.mirandas.get(i);
                PartialMethod<C, M, F> entry = m.withVTableIndex(this.vtable.size());
                this.vtable.add(entry);
                this.mirandas.set(i, entry);
            }
        }

        private void registerFromTable(List<M> table, LocationKind kind) {
            int index = 0;
            for (MethodAccess m : table) {
                if (!VTable.isVirtualEntry(m)) continue;
                MethodKey k = MethodKey.of(m);
                if (!this.locations.containsKey((Object)k)) {
                    this.locations.put((Object)k, new Locations());
                }
                assert (this.locations.containsKey((Object)k));
                if (LocationKind.of(m) == kind) {
                    ((Locations)this.locations.get((Object)k)).register(kind, m, index);
                }
                ++index;
            }
        }

        private boolean canOverride(PartialMethod<C, M, F> candidate, M parentMethod, int vtableIndex) {
            Object currentMethod;
            if (this.canOverride(candidate, parentMethod)) {
                return true;
            }
            for (Object parentClass = parentMethod.getDeclaringClass().getSuperClass(); parentClass != null && (currentMethod = parentClass.lookupVTableEntry(vtableIndex)) != null; parentClass = parentClass.getSuperClass()) {
                if (!this.canOverride(candidate, currentMethod)) continue;
                return true;
            }
            return false;
        }

        private boolean canOverride(PartialMethod<C, M, F> candidate, M parentMethod) {
            assert (VTable.isVirtualEntry(candidate) && VTable.isVirtualEntry(parentMethod));
            assert (candidate.getSymbolicName() == parentMethod.getSymbolicName() && candidate.getSymbolicSignature() == parentMethod.getSymbolicSignature());
            if (parentMethod.isPublic() || parentMethod.isProtected()) {
                return true;
            }
            return this.targetClass.sameRuntimePackage(parentMethod.getDeclaringClass());
        }

        private boolean sameOverrideAccess(PartialMethod<C, M, F> candidate, M parentMethod) {
            assert (VTable.isVirtualEntry(candidate) && VTable.isVirtualEntry(parentMethod));
            assert (candidate.getSymbolicName() == parentMethod.getSymbolicName() && candidate.getSymbolicSignature() == parentMethod.getSymbolicSignature());
            if (candidate.isPublic() || candidate.isProtected()) {
                return parentMethod.isPublic() || parentMethod.isProtected();
            }
            assert (candidate.isPackagePrivate());
            return parentMethod.isPackagePrivate() && this.targetClass.sameRuntimePackage(parentMethod.getDeclaringClass());
        }

        private static enum LocationKind {
            V,
            I;


            public static <M extends MethodAccess<?, ?, ?>> LocationKind of(M m) {
                if (m.getDeclaringClass().isInterface()) {
                    return I;
                }
                return V;
            }
        }

        private record MethodKey(Symbol<Name> name, Symbol<Signature> signature) {
            static <C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> MethodKey of(PartialMethod<C, M, F> method) {
                return new MethodKey(method.getSymbolicName(), method.getSymbolicSignature());
            }
        }

        private static final class Locations<C extends TypeAccess<C, M, F>, M extends MethodAccess<C, M, F>, F extends FieldAccess<C, M, F>> {
            private final List<Location> vLocations = new ArrayList<Location>();
            private final List<Location> iLocations = new ArrayList<Location>();
            private PartialMethod<C, M, F> target;
            boolean shouldPopulate = true;
            boolean resolved = false;
            private PartialMethod<C, M, F> resolvedInterfaceMethod;

            private Locations() {
            }

            void register(LocationKind kind, M method, int index) {
                switch (kind.ordinal()) {
                    case 0: {
                        assert (this.vLocations.isEmpty() || this.vLocations.getLast().index < index);
                        this.vLocations.add(new Location(this, method, index));
                        break;
                    }
                    case 1: {
                        this.iLocations.add(new Location(this, method, index));
                    }
                }
            }

            void setTarget(PartialMethod<C, M, F> declared) {
                this.target = declared;
            }

            M vLookup(int index) {
                int locIdx = Collections.binarySearch(this.vLocations, new Location(this, null, index));
                if (locIdx < 0) {
                    return null;
                }
                return this.vLocations.get((int)locIdx).value;
            }

            PartialMethod<C, M, F> resolve(MethodKey k, Builder<C, M, F> b, boolean inVTable) {
                if (this.resolved) {
                    return this.resolvedInterfaceMethod;
                }
                this.resolvedInterfaceMethod = this.resolveImpl(k, b, inVTable);
                this.resolved = true;
                return this.resolvedInterfaceMethod;
            }

            PartialMethod<C, M, F> markEquivalentEntry(PartialMethod<C, M, F> declaredMethod, int idx) {
                assert (idx >= 0);
                if (this.shouldPopulate) {
                    this.shouldPopulate = false;
                    this.target = declaredMethod.withVTableIndex(idx);
                }
                return this.target;
            }

            boolean shouldPopulate() {
                return this.shouldPopulate;
            }

            private PartialMethod<C, M, F> resolveImpl(MethodKey k, Builder<C, M, F> b, boolean inVTable) {
                if (this.target != null) {
                    return this.target;
                }
                PartialMethod<C, M, F> result = !inVTable && b.allowInterfaceResolvingToPrivate ? b.targetClass.lookupOverrideWithPrivate(k.name(), k.signature()) : this.resolveConcrete();
                if (result != null) {
                    return result;
                }
                PartialMethod<C, M, F> miranda = this.resolveMaximallySpecific();
                if (!inVTable) {
                    b.mirandas.add(miranda);
                }
                return miranda;
            }

            private PartialMethod<C, M, F> resolveConcrete() {
                Object candidate = null;
                for (Location loc : this.vLocations) {
                    candidate = this.mostSpecific(loc.value, candidate, true);
                }
                return candidate;
            }

            private PartialMethod<C, M, F> resolveMaximallySpecific() {
                EconomicSet maximallySpecific = EconomicSet.create((Equivalence)Equivalence.IDENTITY);
                block0: for (Location loc : this.iLocations) {
                    Iterator iter = maximallySpecific.iterator();
                    while (iter.hasNext()) {
                        MethodAccess next = (MethodAccess)iter.next();
                        MethodAccess mostSpecific = this.mostSpecific(loc.value, next, false);
                        if (mostSpecific == next) continue block0;
                        if (mostSpecific == loc.value) {
                            iter.remove();
                            continue;
                        }
                        assert (mostSpecific == null);
                    }
                    maximallySpecific.add(loc.value);
                }
                MethodAccess nonAbstractMaximallySpecific = null;
                for (MethodAccess m : maximallySpecific) {
                    if (m.isAbstract()) continue;
                    if (nonAbstractMaximallySpecific != null) {
                        return new FailingPartialMethod(nonAbstractMaximallySpecific);
                    }
                    nonAbstractMaximallySpecific = m;
                }
                if (nonAbstractMaximallySpecific != null) {
                    return nonAbstractMaximallySpecific;
                }
                assert (!maximallySpecific.isEmpty());
                return (PartialMethod)maximallySpecific.iterator().next();
            }

            private M mostSpecific(M m1, M m2, boolean totalOrder) {
                assert (m1 != null);
                if (m2 == null) {
                    return m1;
                }
                if (m2.getDeclaringClass().isAssignableFrom(m1.getDeclaringClass())) {
                    return m1;
                }
                if (totalOrder) {
                    assert (m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass()));
                    return m2;
                }
                if (m1.getDeclaringClass().isAssignableFrom(m2.getDeclaringClass())) {
                    return m2;
                }
                return null;
            }

            private class Location
            implements Comparable<Location> {
                private final M value;
                private final int index;
                final /* synthetic */ Locations this$0;

                /*
                 * WARNING - Possible parameter corruption
                 */
                Location(M value, int index) {
                    this.this$0 = (Locations)n;
                    this.value = value;
                    this.index = index;
                }

                @Override
                public int compareTo(Location o) {
                    return Integer.compare(this.index, o.index);
                }
            }
        }
    }
}

