/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.conditionalconfig;

import com.oracle.svm.agent.configwithorigins.ConfigurationWithOriginsTracer;
import com.oracle.svm.agent.configwithorigins.ConfigurationWithOriginsWriter;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationComputer;
import com.oracle.svm.configure.config.conditional.ConditionalConfigurationPredicate;
import com.oracle.svm.configure.config.conditional.MethodCallNode;
import com.oracle.svm.configure.filters.ComplexFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class ConditionalConfigurationWriter
implements TracingResultWriter {
    private final ConfigurationWithOriginsTracer tracer;
    private final ComplexFilter userCodeFilter;
    private final ConditionalConfigurationPredicate predicate;

    public ConditionalConfigurationWriter(ConfigurationWithOriginsTracer tracer, ComplexFilter userCodeFilter, ConditionalConfigurationPredicate predicate) {
        this.tracer = tracer;
        this.userCodeFilter = userCodeFilter;
        this.predicate = predicate;
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return true;
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return false;
    }

    @Override
    public List<Path> writeToDirectory(Path directoryPath) throws IOException {
        MethodCallNode rootNode = this.tracer.getRootNode();
        List<Path> writtenFiles = new ConfigurationWithOriginsWriter(this.tracer).writeToDirectory(directoryPath);
        ConfigurationSet config = new ConditionalConfigurationComputer(rootNode, this.userCodeFilter, this.predicate).computeConditionalConfiguration();
        writtenFiles.addAll(config.writeConfiguration(configurationFile -> directoryPath.resolve(configurationFile.getFileName())));
        return writtenFiles;
    }
}

