/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.ArrayElementsTypeFlow;
import com.oracle.graal.pointsto.flow.FieldFilterTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestore.FieldTypeStore;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.BytecodePosition;

public class ContextSensitiveAnalysisObject
extends AnalysisObject {
    public ContextSensitiveAnalysisObject(AnalysisUniverse universe, AnalysisType type, AnalysisObject.AnalysisObjectKind kind) {
        super(universe, type, kind);
        assert (universe.analysisPolicy().allocationSiteSensitiveHeap()) : "policy mismatch";
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled()) : "policy mismatch";
        if (!this.merged) {
            super.noteMerge(bb);
            if (this.type.isArray()) {
                if (this.isObjectArray()) {
                    this.mergeArrayElementsFlow(bb);
                }
            } else {
                this.mergeInstanceFieldsFlows(bb);
            }
        }
    }

    private void mergeArrayElementsFlow(PointsToAnalysis bb) {
        assert (this.isObjectArray()) : this;
        ArrayElementsTypeFlow contextInsensitiveWriteArrayElementsFlow = this.type.getContextInsensitiveAnalysisObject().getArrayElementsFlow(bb, true);
        contextInsensitiveWriteArrayElementsFlow.addUse(bb, this.arrayElementsTypeStore.writeFlow());
        ArrayElementsTypeFlow contextInsensitiveReadArrayElementsFlow = this.type.getContextInsensitiveAnalysisObject().getArrayElementsFlow(bb, false);
        this.arrayElementsTypeStore.readFlow().addUse(bb, contextInsensitiveReadArrayElementsFlow);
    }

    private void mergeInstanceFieldsFlows(PointsToAnalysis bb) {
        this.mergeInstanceFieldsFlows(bb, this.type.getContextInsensitiveAnalysisObject());
    }

    public void mergeInstanceFieldsFlows(PointsToAnalysis bb, AnalysisObject object) {
        if (this.instanceFieldsTypeStore != null) {
            for (int i = 0; i < this.instanceFieldsTypeStore.length(); ++i) {
                FieldTypeStore fieldTypeStore = (FieldTypeStore)this.instanceFieldsTypeStore.get(i);
                if (fieldTypeStore == null) continue;
                ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, object);
            }
        }
    }

    protected static void mergeInstanceFieldFlow(PointsToAnalysis bb, FieldTypeStore fieldTypeStore, AnalysisObject object) {
        AnalysisField field = fieldTypeStore.field();
        FieldTypeFlow readFieldFlow = fieldTypeStore.readFlow();
        FieldTypeFlow writeFieldFlow = fieldTypeStore.writeFlow();
        FieldTypeFlow parentWriteFieldFlow = object.getInstanceFieldFlow(bb, field, true);
        parentWriteFieldFlow.addUse(bb, writeFieldFlow);
        readFieldFlow.addUse(bb, parentWriteFieldFlow);
    }

    @Override
    public ArrayElementsTypeFlow getArrayElementsFlow(PointsToAnalysis bb, boolean isStore) {
        assert (this.type.isArray()) : this.type;
        assert (bb.analysisPolicy().allocationSiteSensitiveHeap()) : "policy mismatch";
        return isStore ? this.arrayElementsTypeStore.writeFlow() : this.arrayElementsTypeStore.readFlow();
    }

    @Override
    public FieldFilterTypeFlow getInstanceFieldFilterFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field) {
        assert (!Modifier.isStatic(field.getModifiers()) && field.isUnsafeAccessed() && bb.analysisPolicy().allocationSiteSensitiveHeap()) : field;
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        for (AnalysisObject mergedWith : this.getAllObjectsMergedWith()) {
            ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, mergedWith);
        }
        return fieldTypeStore.writeFlow().filterFlow(bb);
    }

    @Override
    public FieldTypeFlow getInstanceFieldFlow(PointsToAnalysis bb, TypeFlow<?> objectFlow, BytecodePosition context, AnalysisField field, boolean isStore) {
        assert (!Modifier.isStatic(field.getModifiers()) && bb.analysisPolicy().allocationSiteSensitiveHeap()) : field;
        FieldTypeStore fieldTypeStore = this.getInstanceFieldTypeStore(bb, objectFlow, context, field);
        for (AnalysisObject mergedWith : this.getAllObjectsMergedWith()) {
            ContextSensitiveAnalysisObject.mergeInstanceFieldFlow(bb, fieldTypeStore, mergedWith);
        }
        return isStore ? fieldTypeStore.writeFlow() : fieldTypeStore.readFlow();
    }

    @Override
    protected void linkFieldFlows(PointsToAnalysis bb, AnalysisField field, FieldTypeStore fieldStore) {
        field.getInitialFlow().addUse(bb, fieldStore.writeFlow());
        fieldStore.readFlow().addUse(bb, field.getSinkFlow());
        FieldTypeFlow parentReadFieldFlow = this.type.getContextInsensitiveAnalysisObject().getInstanceFieldFlow(bb, field, false);
        fieldStore.readFlow().addUse(bb, parentReadFieldFlow);
    }

    protected List<AnalysisObject> getAllObjectsMergedWith() {
        return this.merged ? Collections.singletonList(this.type().getContextInsensitiveAnalysisObject()) : Collections.emptyList();
    }
}

