/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ContextInsensitiveFieldTypeFlow;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaField;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.PointsToAnalysisField;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.AnalysisFuture;
import com.oracle.graal.pointsto.util.AtomicUtils;
import com.oracle.svm.common.meta.GuaranteeFolded;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class AnalysisField
extends AnalysisElement
implements WrappedJavaField,
OriginalFieldProvider {
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isAccessedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isAccessed");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isReadUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isRead");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isWrittenUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isWritten");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isFoldedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isFolded");
    private static final AtomicReferenceFieldUpdater<AnalysisField, Object> isUnsafeAccessedUpdater = AtomicReferenceFieldUpdater.newUpdater(AnalysisField.class, Object.class, "isUnsafeAccessed");
    private final int id;
    private final boolean isInBaseLayer;
    public final ResolvedJavaField wrapped;
    protected FieldTypeFlow initialFlow;
    protected FieldTypeFlow sinkFlow;
    private volatile Object isRead;
    private volatile Object isAccessed;
    private volatile Object isWritten;
    private volatile Object isFolded;
    private volatile Object isUnsafeAccessed;
    private ConcurrentMap<Object, Boolean> readBy;
    private ConcurrentMap<Object, Boolean> writtenBy;
    protected int position;
    protected final AnalysisType declaringClass;
    protected final AnalysisType fieldType;
    protected Object fieldValueInterceptor;
    private final boolean isLayeredStaticField;

    public AnalysisField(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        super(universe.hostVM.enableTrackAcrossLayers());
        assert (!wrappedField.isInternal()) : wrappedField;
        this.position = -1;
        this.wrapped = wrappedField;
        boolean trackAccessChain = (Boolean)PointstoOptions.TrackAccessChain.getValue(universe.hostVM().options());
        this.readBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.writtenBy = trackAccessChain ? new ConcurrentHashMap() : null;
        this.declaringClass = universe.lookup((JavaType)wrappedField.getDeclaringClass());
        this.fieldType = AnalysisField.getDeclaredType(universe, wrappedField);
        this.initialFlow = new FieldTypeFlow(this, this.getType());
        this.sinkFlow = this.isStatic() ? this.initialFlow : new ContextInsensitiveFieldTypeFlow(this, this.getType());
        if (universe.hostVM().useBaseLayer() && this.declaringClass.isInBaseLayer()) {
            int fid = universe.getImageLayerLoader().lookupHostedFieldInBaseLayer(this);
            if (fid != -1) {
                this.id = fid;
                this.isInBaseLayer = true;
            } else {
                this.id = universe.computeNextFieldId();
                this.isInBaseLayer = false;
            }
        } else {
            this.id = universe.computeNextFieldId();
            this.isInBaseLayer = false;
        }
        this.isLayeredStaticField = this.isStatic() && universe.hostVM.buildingImageLayer();
    }

    @Override
    protected AnalysisUniverse getUniverse() {
        return this.declaringClass.getUniverse();
    }

    private static AnalysisType getDeclaredType(AnalysisUniverse universe, ResolvedJavaField wrappedField) {
        ResolvedJavaType resolvedType;
        try {
            resolvedType = wrappedField.getType().resolve(OriginalClassProvider.getOriginalType((JavaType)wrappedField.getDeclaringClass()));
        }
        catch (LinkageError e) {
            return universe.objectType();
        }
        return universe.lookup((JavaType)resolvedType);
    }

    @Override
    public ResolvedJavaField getWrapped() {
        return this.wrapped;
    }

    public int getId() {
        return this.id;
    }

    public boolean isInBaseLayer() {
        return this.isInBaseLayer;
    }

    public boolean installableInLayer() {
        if (this.isLayeredStaticField) {
            return this.getUniverse().hostVM.installableInLayer(this);
        }
        return true;
    }

    public boolean preventConstantFolding() {
        if (this.isLayeredStaticField) {
            return this.getUniverse().hostVM.preventConstantFolding(this);
        }
        return false;
    }

    public int hashCode() {
        return this.id;
    }

    public JavaKind getStorageKind() {
        return this.fieldType.getStorageKind();
    }

    public FieldTypeFlow getInitialFlow() {
        return this.initialFlow;
    }

    public FieldTypeFlow getSinkFlow() {
        return this.sinkFlow;
    }

    public FieldTypeFlow getStaticFieldFlow() {
        assert (Modifier.isStatic(this.getModifiers())) : this;
        return this.sinkFlow;
    }

    public void cleanupAfterAnalysis() {
        this.initialFlow = null;
        this.sinkFlow = null;
        this.readBy = null;
        this.writtenBy = null;
    }

    public boolean registerAsAccessed(Object reason) {
        this.checkGuaranteeFolded();
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as accessed needs to provide a valid reason.";
        return AtomicUtils.atomicSetAndRun(this, reason, isAccessedUpdater, () -> {
            this.onReachable(reason);
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        });
    }

    public boolean registerAsRead(Object reason) {
        this.checkGuaranteeFolded();
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as read needs to provide a valid reason.";
        if (this.readBy != null) {
            this.readBy.put(reason, Boolean.TRUE);
        }
        return AtomicUtils.atomicSetAndRun(this, reason, isReadUpdater, () -> {
            this.onReachable(reason);
            this.getUniverse().onFieldAccessed(this);
            this.getUniverse().getHeapScanner().onFieldRead(this);
        });
    }

    public boolean registerAsWritten(Object reason) {
        this.checkGuaranteeFolded();
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as written needs to provide a valid reason.";
        if (this.writtenBy != null) {
            this.writtenBy.put(reason, Boolean.TRUE);
        }
        return AtomicUtils.atomicSetAndRun(this, reason, isWrittenUpdater, () -> {
            this.onReachable(reason);
            if (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object) {
                this.getUniverse().onFieldAccessed(this);
            }
        });
    }

    public void injectDeclaredType() {
        BigBang bb = this.getUniverse().getBigbang();
        if (this.getStorageKind().isObject()) {
            bb.injectFieldTypes(this, List.of(this.getType()), true);
        } else if (bb.trackPrimitiveValues() && this.getStorageKind().isPrimitive()) {
            ((PointsToAnalysisField)this).saturatePrimitiveField();
        }
    }

    public boolean isGuaranteeFolded() {
        return this.getAnnotation(GuaranteeFolded.class) != null;
    }

    public void checkGuaranteeFolded() {
        AnalysisError.guarantee(!this.isGuaranteeFolded(), "A field that is guaranteed to always be folded is seen as accessed: %s. ", this);
    }

    public void registerAsFolded(Object reason) {
        this.getDeclaringClass().registerAsReachable(this);
        assert (this.isValidReason(reason)) : "Registering a field as folded needs to provide a valid reason.";
        AtomicUtils.atomicSetAndRun(this, reason, isFoldedUpdater, () -> {
            assert (this.getDeclaringClass().isReachable()) : this;
            this.onReachable(reason);
        });
    }

    public boolean registerAsUnsafeAccessed(Object reason) {
        this.checkGuaranteeFolded();
        assert (this.isValidReason(reason)) : "Registering a field as unsafe accessed needs to provide a valid reason.";
        this.registerAsAccessed(reason);
        return AtomicUtils.atomicSetAndRun(this, reason, isUnsafeAccessedUpdater, () -> {
            this.registerAsWritten(reason);
            if (this.getUniverse().analysisPolicy().useConservativeUnsafeAccess()) {
                this.injectDeclaredType();
            } else if (this.isStatic()) {
                this.getUniverse().registerUnsafeAccessedStaticField(this);
            } else {
                AnalysisType declaringType = this.getDeclaringClass();
                declaringType.registerUnsafeAccessedField(this);
            }
        });
    }

    public boolean isUnsafeAccessed() {
        return AtomicUtils.isSet(this, isUnsafeAccessedUpdater);
    }

    public Object getReadBy() {
        return isReadUpdater.get(this);
    }

    public Object getAccessedReason() {
        return this.isAccessed;
    }

    public boolean isAccessed() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) && (Modifier.isVolatile(this.getModifiers()) || this.getStorageKind() == JavaKind.Object);
    }

    public boolean isRead() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater);
    }

    public Object getReadReason() {
        return this.isRead;
    }

    public boolean isWritten() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isWrittenUpdater);
    }

    public Object getWrittenReason() {
        return this.isWritten;
    }

    public boolean isFolded() {
        return AtomicUtils.isSet(this, isFoldedUpdater);
    }

    public Object getFoldedReason() {
        return this.isFolded;
    }

    @Override
    public boolean isReachable() {
        return AtomicUtils.isSet(this, isAccessedUpdater) || AtomicUtils.isSet(this, isReadUpdater) || AtomicUtils.isSet(this, isWrittenUpdater) || AtomicUtils.isSet(this, isFoldedUpdater);
    }

    @Override
    public void onReachable(Object reason) {
        this.registerAsTrackedAcrossLayers(reason);
        this.notifyReachabilityCallbacks(this.declaringClass.getUniverse(), new ArrayList<AnalysisFuture<Void>>());
    }

    @Override
    protected void onTrackedAcrossLayers(Object reason) {
        AnalysisError.guarantee(!this.getUniverse().sealed(), "Field %s was marked as tracked after the universe was sealed", this);
    }

    public Object getFieldValueInterceptor() {
        return this.fieldValueInterceptor;
    }

    public void setFieldValueInterceptor(Object fieldValueInterceptor) {
        this.fieldValueInterceptor = fieldValueInterceptor;
    }

    public String getName() {
        return this.wrapped.getName();
    }

    public void setPosition(int newPosition) {
        AnalysisError.guarantee(this.position == -1 || newPosition == this.position, "Position already set for field %s, old position: %d, new position: %d", this, this.position, newPosition);
        this.position = newPosition;
    }

    public int getPosition() {
        AnalysisError.guarantee(this.position != -1, "Unknown position for field %s", this);
        return this.position;
    }

    public AnalysisType getType() {
        return this.fieldType;
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public int getOffset() {
        throw GraalError.unimplementedOverride();
    }

    public AnalysisType getDeclaringClass() {
        return this.declaringClass;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isSynthetic() {
        return this.wrapped.isSynthetic();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public String toString() {
        return "AnalysisField<" + this.format("%h.%n") + " -> " + this.wrapped.toString() + ", accessed: " + (this.isAccessed != null) + ", read: " + (this.isRead != null) + ", written: " + (this.isWritten != null) + ", folded: " + this.isFolded() + ">";
    }

    @Override
    public ResolvedJavaField unwrapTowardsOriginalField() {
        return this.wrapped;
    }

    public JavaConstant getConstantValue() {
        return this.getUniverse().lookup(this.getWrapped().getConstantValue());
    }

    public void beforeFieldValueAccess() {
        this.declaringClass.registerAsReachable(this);
        this.declaringClass.forAllSuperTypes(type -> {
            type.ensureOnTypeReachableTaskDone();
            List<AnalysisFuture<Void>> notifications = type.scheduledTypeReachableNotifications;
            if (notifications != null) {
                for (AnalysisFuture<Void> notification : notifications) {
                    notification.ensureDone();
                }
                type.scheduledTypeReachableNotifications = null;
            }
        });
    }
}

