/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractSpecialInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphInfo;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.DefaultInvokeTypeFlowUtil;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.LightImmutableCollection;
import com.oracle.svm.common.meta.MultiMethod;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;

final class DefaultSpecialInvokeTypeFlow
extends AbstractSpecialInvokeTypeFlow {
    private boolean calleesLinked = false;
    private final boolean isDeoptInvokeTypeFlow;

    DefaultSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey) {
        this(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey, false);
    }

    DefaultSpecialInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, MultiMethod.MultiMethodKey callerMultiMethodKey, boolean isDeoptInvokeTypeFlow) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn, callerMultiMethodKey);
        this.isDeoptInvokeTypeFlow = isDeoptInvokeTypeFlow;
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (!this.isSaturated()) : this;
        if (!this.isFlowEnabled()) {
            return;
        }
        TypeState receiverState = this.filterReceiverState(bb, this.getReceiver().getState());
        if (this.seenReceiverTypes.equals(receiverState)) {
            return;
        }
        this.seenReceiverTypes = receiverState;
        if (receiverState.isNull()) {
            return;
        }
        this.initializeCallees(bb);
        LightImmutableCollection.forEach(this, CALLEES_ACCESSOR, callee -> {
            MethodFlowsGraphInfo calleeFlows = callee.getTypeFlow().getOrCreateMethodFlowsGraphInfo(bb, this);
            assert (calleeFlows.getMethod().equals(callee)) : callee;
            if (!this.calleesLinked) {
                this.linkCallee(bb, false, calleeFlows);
            }
            this.updateReceiver(bb, calleeFlows, receiverState);
        });
        this.calleesLinked = true;
    }

    @Override
    public Collection<MethodFlowsGraph> getAllNonStubCalleesFlows(PointsToAnalysis bb) {
        return DefaultInvokeTypeFlowUtil.getAllNonStubCalleesFlows(this);
    }

    @Override
    public boolean isDeoptInvokeTypeFlow() {
        return this.isDeoptInvokeTypeFlow;
    }
}

