/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_SystemLookup_WindowsFallbackSymbols;
import com.oracle.svm.core.foreign.Util_java_lang_foreign_SymbolLookup;
import com.oracle.svm.core.jdk.NativeLibraries;
import com.oracle.svm.core.util.BasedOnJDKClass;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import jdk.graal.compiler.word.Word;
import jdk.internal.foreign.SystemLookup;
import jdk.internal.foreign.Utils;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.word.Pointer;

@BasedOnJDKClass(value=SystemLookup.class)
public final class RuntimeSystemLookup {
    static final SymbolLookup INSTANCE = RuntimeSystemLookup.makeSystemLookup();

    public static SymbolLookup makeSystemLookup() {
        if (Platform.includedIn(Platform.WINDOWS.class)) {
            Path system32 = Path.of(System.getenv("SystemRoot"), "System32");
            Path ucrtbase = system32.resolve("ucrtbase.dll");
            Path msvcrt = system32.resolve("msvcrt.dll");
            boolean useUCRT = Files.exists(ucrtbase, new LinkOption[0]);
            Path stdLib = useUCRT ? ucrtbase : msvcrt;
            SymbolLookup lookup = Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, List.of(stdLib));
            if (useUCRT) {
                Function<String, Optional> fallbackLookup = name -> {
                    Pointer ptr = RuntimeSystemLookup.getWindowsFallbackSymbol(name);
                    if (ptr.isNonNull()) {
                        return Optional.of(MemorySegment.ofAddress(ptr.rawValue()));
                    }
                    return Optional.empty();
                };
                SymbolLookup finalLookup = lookup;
                lookup = name -> {
                    Objects.requireNonNull(name);
                    if (Utils.containsNullChars(name)) {
                        return Optional.empty();
                    }
                    return finalLookup.find(name).or(() -> (Optional)fallbackLookup.apply(name));
                };
            }
            return lookup;
        }
        if (Platform.includedIn(Platform.DARWIN.class)) {
            return Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, List.of("/usr/lib/libSystem.B.dylib"));
        }
        return Util_java_lang_foreign_SymbolLookup.libraryLookup(NativeLibraries::loadLibraryPlatformSpecific, List.of("libc.so.6", "libm.so.6", "libdl.so.2"));
    }

    @Platforms(value={Platform.WINDOWS.class})
    @CLibrary(value="libchelper", requireStatic=true)
    @CFunction(value="__svm_get_syslookup_func", transition=CFunction.Transition.NO_TRANSITION)
    public static native Pointer getSyslookupFunc(int var0, int var1);

    @Platforms(value={Platform.WINDOWS.class})
    private static Pointer getWindowsFallbackSymbol(String name) {
        try {
            assert (Target_jdk_internal_foreign_SystemLookup_WindowsFallbackSymbols.class.isEnum());
            Object value = Enum.valueOf((Class)SubstrateUtil.cast(Target_jdk_internal_foreign_SystemLookup_WindowsFallbackSymbols.class, Class.class), name);
            Pointer func = RuntimeSystemLookup.getSyslookupFunc(((Enum)value).ordinal(), ((Target_jdk_internal_foreign_SystemLookup_WindowsFallbackSymbols[])Target_jdk_internal_foreign_SystemLookup_WindowsFallbackSymbols.class.getEnumConstants()).length);
            assert (func.isNonNull()) : "Function pointer for " + ((Enum)value).name() + " is NULL but shouldn't.";
            return func;
        }
        catch (IllegalArgumentException e) {
            return (Pointer)Word.nullPointer();
        }
    }
}

