/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.foreign;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.DowncallStubsHolder;
import com.oracle.svm.core.foreign.ForeignFunctionsRuntime;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_NativeEntryPoint;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.graal.code.SubstrateCallingConventionType;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.code.NonBytecodeMethod;
import com.oracle.svm.hosted.code.SubstrateCompilationDirectives;
import com.oracle.svm.hosted.foreign.ForeignGraphKit;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodType;
import java.lang.reflect.AnnotatedElement;
import java.util.List;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.java.FrameStateBuilder;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import org.graalvm.collections.Pair;
import org.graalvm.nativeimage.c.function.CFunction;

@BasedOnJDKFile.List(value={@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+7/src/hotspot/share/prims/nativeEntryPoint.cpp"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+18/src/hotspot/cpu/x86/downcallLinker_x86_64.cpp"), @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-25+17/src/hotspot/cpu/aarch64/downcallLinker_aarch64.cpp")})
class DowncallStub
extends NonBytecodeMethod {
    private final NativeEntryPointInfo nep;
    private static final AnnotationValue[] INJECTED_ANNOTATIONS_FOR_ALLOW_HEAP_ACCESS = SubstrateAnnotationExtractor.prepareInjectedAnnotations((Annotation[])new Annotation[]{Uninterruptible.Utils.getAnnotation((AnnotatedElement)ReflectionUtil.lookupMethod(DowncallStub.class, (String)"uninterruptibleAnnotationForAllowHeapAccessHolder", (Class[])new Class[0]))});

    public static Signature createSignature(MetaAccessProvider metaAccess) {
        return ResolvedSignature.fromKinds((JavaKind[])new JavaKind[]{JavaKind.Object}, (JavaKind)JavaKind.Object, (MetaAccessProvider)metaAccess);
    }

    DowncallStub(NativeEntryPointInfo nep, MetaAccessProvider metaAccess) {
        super(DowncallStubsHolder.stubName(nep), true, metaAccess.lookupJavaType(DowncallStubsHolder.class), DowncallStub.createSignature(metaAccess), DowncallStubsHolder.getConstantPool(metaAccess));
        this.nep = nep;
    }

    @Uninterruptible(reason="See DowncallStub.getInjectedAnnotations.", calleeMustBe=false)
    private static void uninterruptibleAnnotationForAllowHeapAccessHolder() {
    }

    public AnnotationValue[] getInjectedAnnotations() {
        if (this.nep.allowHeapAccess()) {
            return INJECTED_ANNOTATIONS_FOR_ALLOW_HEAP_ACCESS;
        }
        return null;
    }

    public StructuredGraph buildGraph(DebugContext debug, AnalysisMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        ForeignGraphKit kit = new ForeignGraphKit(debug, providers, (ResolvedJavaMethod)method);
        FrameStateBuilder state = kit.getFrameState();
        boolean deoptimizationTarget = SubstrateCompilationDirectives.isDeoptTarget((ResolvedJavaMethod)method);
        List arguments = kit.getInitialArguments();
        assert (arguments.size() == 1);
        Pair<List<ValueNode>, ValueNode> argumentsAndNep = kit.unpackArgumentsAndExtractNEP((ValueNode)arguments.get(0), this.nep.methodType());
        arguments = (List)argumentsAndNep.getLeft();
        ValueNode runtimeNep = (ValueNode)argumentsAndNep.getRight();
        AbiUtils.Adapter.Result.FullNativeAdaptation adapted = AbiUtils.singleton().adapt(kit.unboxArguments(arguments, this.nep.methodType()), this.nep);
        for (Node node : adapted.nodesToAppendToGraph()) {
            kit.append(node);
        }
        ValueNode callAddress = adapted.getArgument(AbiUtils.Adapter.Extracted.CallTarget);
        SnippetRuntime.SubstrateForeignCallDescriptor captureFunction = null;
        LoadFieldNode captureMask = null;
        ValueNode captureAddress = null;
        if (this.nep.capturesCallState()) {
            captureFunction = ForeignFunctionsRuntime.CAPTURE_CALL_STATE;
            captureMask = kit.createLoadField(runtimeNep, (ResolvedJavaField)kit.getMetaAccess().lookupJavaField(ReflectionUtil.lookupField(Target_jdk_internal_foreign_abi_NativeEntryPoint.class, (String)"captureMask")));
            captureAddress = adapted.getArgument(AbiUtils.Adapter.Extracted.CaptureBufferAddress);
        }
        state.clearLocals();
        SubstrateCallingConventionType cc = SubstrateCallingConventionType.makeCustom((boolean)true, (AssignedLocation[])adapted.parametersAssignment().toArray(new AssignedLocation[0]), (AssignedLocation[])adapted.returnsAssignment().toArray(new AssignedLocation[0]));
        CFunction.Transition transition = this.nep.skipsTransition() ? CFunction.Transition.NO_TRANSITION : CFunction.Transition.TO_NATIVE;
        ValueNode returnValue = kit.createCFunctionCallWithCapture(callAddress, adapted.arguments(), (Signature)ResolvedSignature.fromMethodType((MethodType)adapted.callType(), (MetaAccessProvider)kit.getMetaAccess()), VMThreads.StatusSupport.getNewThreadStatus((CFunction.Transition)transition), deoptimizationTarget, (CallingConvention.Type)cc, (ForeignCallDescriptor)captureFunction, (ValueNode)captureMask, captureAddress);
        kit.boxAndReturn(returnValue, this.nep.methodType());
        return kit.finalizeGraph();
    }
}

