// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: TruffleCompilerOptions.java
package jdk.graal.compiler.truffle;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class TruffleCompilerOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new TruffleCompilerOptions();
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "CompilationTimeout": {
            return OptionDescriptor.create(
                /*name*/ "CompilationTimeout",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Double.class,
                /*help*/ "Time limit in seconds before a compilation expires and throws a bailout (0 to disable the limit). ",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.CompilationTimeout,
                /*fieldName*/ "CompilationTimeout",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptCycleDetectionAllowedRepeats": {
            return OptionDescriptor.create(
                /*name*/ "DeoptCycleDetectionAllowedRepeats",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum allowed repeats of the same compiled code for the same compilable. Works only if the detection of repeated compilation is enabled after DeoptCycleDetectionThreshold has been reached for the compilable. (negative integer means 0, default: 0)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.DeoptCycleDetectionAllowedRepeats,
                /*fieldName*/ "DeoptCycleDetectionAllowedRepeats",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeoptCycleDetectionThreshold": {
            return OptionDescriptor.create(
                /*name*/ "DeoptCycleDetectionThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Threshold for enabling deopt cycle detection for a call target. When the number of successful compilation of the call target reaches the threshold, deopt cycle detection is enabled for the call target. (negative integer means the detection is never enabled, default: 15)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.DeoptCycleDetectionThreshold,
                /*fieldName*/ "DeoptCycleDetectionThreshold",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnoseFailure": {
            return OptionDescriptor.create(
                /*name*/ "DiagnoseFailure",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Forces diagnostics for compilation failures (default: false).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.DiagnoseFailure,
                /*fieldName*/ "DiagnoseFailure",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EncodedGraphCache": {
            return OptionDescriptor.create(
                /*name*/ "EncodedGraphCache",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Cache encoded graphs across Truffle compilations to speed up partial evaluation. (default: true).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.EncodedGraphCache,
                /*fieldName*/ "EncodedGraphCache",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ExcludeAssertions": {
            return OptionDescriptor.create(
                /*name*/ "ExcludeAssertions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exclude assertion code from Truffle compilations (default: true)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.ExcludeAssertions,
                /*fieldName*/ "ExcludeAssertions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FirstTierInliningPolicy": {
            return OptionDescriptor.create(
                /*name*/ "FirstTierInliningPolicy",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Explicitly pick a first tier inlining policy by name (None, TrivialOnly). If empty (default) the lowest priority policy (TrivialOnly) is chosen.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.FirstTierInliningPolicy,
                /*fieldName*/ "FirstTierInliningPolicy",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FirstTierUseEconomy": {
            return OptionDescriptor.create(
                /*name*/ "FirstTierUseEconomy",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Whether to use the economy configuration in the first-tier compilations. (default: true, syntax: true|false)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.FirstTierUseEconomy,
                /*fieldName*/ "FirstTierUseEconomy",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineAcrossTruffleBoundary": {
            return OptionDescriptor.create(
                /*name*/ "InlineAcrossTruffleBoundary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable inlining across Truffle boundary",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InlineAcrossTruffleBoundary,
                /*fieldName*/ "InlineAcrossTruffleBoundary",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InlineOnly": {
            return OptionDescriptor.create(
                /*name*/ "InlineOnly",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Restrict inlined methods to ','-separated list of includes (or excludes prefixed with '~'). No restriction by default. (usage: <name>,<name>,...)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InlineOnly,
                /*fieldName*/ "InlineOnly",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Inlining": {
            return OptionDescriptor.create(
                /*name*/ "Inlining",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable automatic inlining of guest language call targets (default: true, usage: true|false).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.Inlining,
                /*fieldName*/ "Inlining",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InliningExpansionBudget": {
            return OptionDescriptor.create(
                /*name*/ "InliningExpansionBudget",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The base expansion budget for language-agnostic inlining (default: 12000). Syntax: [1, inf)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InliningExpansionBudget,
                /*fieldName*/ "InliningExpansionBudget",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InliningInliningBudget": {
            return OptionDescriptor.create(
                /*name*/ "InliningInliningBudget",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The base inlining budget for language-agnostic inlining (default: 12000). Syntax: [1, inf)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InliningInliningBudget,
                /*fieldName*/ "InliningInliningBudget",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InliningPolicy": {
            return OptionDescriptor.create(
                /*name*/ "InliningPolicy",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Explicitly pick a inlining policy by name. If empty (default) the highest priority chosen by default.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InliningPolicy,
                /*fieldName*/ "InliningPolicy",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InliningRecursionDepth": {
            return OptionDescriptor.create(
                /*name*/ "InliningRecursionDepth",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum depth for recursive inlining (default: 2, usage: [0, inf)).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InliningRecursionDepth,
                /*fieldName*/ "InliningRecursionDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InliningUseSize": {
            return OptionDescriptor.create(
                /*name*/ "InliningUseSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use the graph size as a cost model during inlining (default: false).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InliningUseSize,
                /*fieldName*/ "InliningUseSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstrumentBoundaries": {
            return OptionDescriptor.create(
                /*name*/ "InstrumentBoundaries",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument Truffle boundaries and output profiling information to the standard output.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InstrumentBoundaries,
                /*fieldName*/ "InstrumentBoundaries",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstrumentBoundariesPerInlineSite": {
            return OptionDescriptor.create(
                /*name*/ "InstrumentBoundariesPerInlineSite",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument Truffle boundaries by considering different inlining sites as different branches.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InstrumentBoundariesPerInlineSite,
                /*fieldName*/ "InstrumentBoundariesPerInlineSite",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstrumentBranches": {
            return OptionDescriptor.create(
                /*name*/ "InstrumentBranches",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument branches and output profiling information to the standard output.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InstrumentBranches,
                /*fieldName*/ "InstrumentBranches",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstrumentBranchesPerInlineSite": {
            return OptionDescriptor.create(
                /*name*/ "InstrumentBranchesPerInlineSite",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instrument branches by considering different inlining sites as different branches.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InstrumentBranchesPerInlineSite,
                /*fieldName*/ "InstrumentBranchesPerInlineSite",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstrumentFilter": {
            return OptionDescriptor.create(
                /*name*/ "InstrumentFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Method filter for host methods in which to add instrumentation (syntax: <method>,<method>,....)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InstrumentFilter,
                /*fieldName*/ "InstrumentFilter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstrumentationTableSize": {
            return OptionDescriptor.create(
                /*name*/ "InstrumentationTableSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of instrumentation counters available (default: 10000, syntax: [1, inf))",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.InstrumentationTableSize,
                /*fieldName*/ "InstrumentationTableSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IterativePartialEscape": {
            return OptionDescriptor.create(
                /*name*/ "IterativePartialEscape",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Run the partial escape analysis iteratively in Truffle compilation.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.IterativePartialEscape,
                /*fieldName*/ "IterativePartialEscape",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LogInlinedTargets": {
            return OptionDescriptor.create(
                /*name*/ "LogInlinedTargets",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Logs inlined targets for statistical purposes (default: false).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.LogInlinedTargets,
                /*fieldName*/ "LogInlinedTargets",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumGraalGraphSize": {
            return OptionDescriptor.create(
                /*name*/ "MaximumGraalGraphSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Stop partial evaluation when the graph exceeded this size, disabled if < 0. (default: -1, syntax: [-inf, inf))",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.MaximumGraalGraphSize,
                /*fieldName*/ "MaximumGraalGraphSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MethodExpansionStatistics": {
            return OptionDescriptor.create(
                /*name*/ "MethodExpansionStatistics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.truffle.TruffleCompilerOptions.CompilationTiers.class,
                /*help*/ "Print statistics on expanded Java methods during partial evaluation at the end of a run.(syntax: true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...)%nAccepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.MethodExpansionStatistics,
                /*fieldName*/ "MethodExpansionStatistics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NodeExpansionStatistics": {
            return OptionDescriptor.create(
                /*name*/ "NodeExpansionStatistics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.truffle.TruffleCompilerOptions.CompilationTiers.class,
                /*help*/ "Print statistics on expanded Truffle nodes during partial evaluation at the end of a run.(syntax: true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...)%nAccepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.NodeExpansionStatistics,
                /*fieldName*/ "NodeExpansionStatistics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NodeSourcePositions": {
            return OptionDescriptor.create(
                /*name*/ "NodeSourcePositions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable node source positions in truffle partial evaluations.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.NodeSourcePositions,
                /*fieldName*/ "NodeSourcePositions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParsePEGraphsWithAssumptions": {
            return OptionDescriptor.create(
                /*name*/ "ParsePEGraphsWithAssumptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow assumptions during parsing of seed graphs for partial evaluation. Disables the persistent encoded graph cache 'engine.EncodedGraphCache'. (default: false).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.ParsePEGraphsWithAssumptions,
                /*fieldName*/ "ParsePEGraphsWithAssumptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInlining": {
            return OptionDescriptor.create(
                /*name*/ "TraceInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print information for inlining decisions.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TraceInlining,
                /*fieldName*/ "TraceInlining",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceInliningDetails": {
            return OptionDescriptor.create(
                /*name*/ "TraceInliningDetails",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print detailed information for inlining (i.e. the entire explored call tree).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TraceInliningDetails,
                /*fieldName*/ "TraceInliningDetails",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceMethodExpansion": {
            return OptionDescriptor.create(
                /*name*/ "TraceMethodExpansion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.truffle.TruffleCompilerOptions.CompilationTiers.class,
                /*help*/ "Print a tree of all expanded Java methods with statistics after each compilation. (syntax: true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...)%nAccepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TraceMethodExpansion,
                /*fieldName*/ "TraceMethodExpansion",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceNodeExpansion": {
            return OptionDescriptor.create(
                /*name*/ "TraceNodeExpansion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.truffle.TruffleCompilerOptions.CompilationTiers.class,
                /*help*/ "Print a tree of all expanded Truffle nodes with statistics after each compilation. (syntax: true|false|peTier|truffleTier|lowTier|<tier>,<tier>,...)%nAccepted values are:%n    true - Collect data for the default tier 'truffleTier'.%n    false - No data will be collected.%nOr one or multiple tiers separated by comma (e.g. truffleTier,lowTier):%n    peTier - After partial evaluation without additional phases applied.%n    truffleTier - After partial evaluation with additional phases applied.%n    lowTier - After low tier phases were applied.",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TraceNodeExpansion,
                /*fieldName*/ "TraceNodeExpansion",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TracePerformanceWarnings": {
            return OptionDescriptor.create(
                /*name*/ "TracePerformanceWarnings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.truffle.TruffleCompilerOptions.PerformanceWarnings.class,
                /*help*/ "Print potential performance problems, Performance warnings are: call, instanceof, store, frame_merge, trivial. (syntax: none|all|<perfWarning>,<perfWarning>,...)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TracePerformanceWarnings,
                /*fieldName*/ "TracePerformanceWarnings",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceStackTraceLimit": {
            return OptionDescriptor.create(
                /*name*/ "TraceStackTraceLimit",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of stack trace elements printed by TraceTruffleTransferToInterpreter, TraceTruffleAssumptions and TraceDeoptimizeFrame (default: 20). Syntax: [1, inf).",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TraceStackTraceLimit,
                /*fieldName*/ "TraceStackTraceLimit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TreatPerformanceWarningsAsErrors": {
            return OptionDescriptor.create(
                /*name*/ "TreatPerformanceWarningsAsErrors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ jdk.graal.compiler.truffle.TruffleCompilerOptions.PerformanceWarnings.class,
                /*help*/ "Treat performance warnings as error. Handling of the error depends on the CompilationFailureAction option value. Performance warnings are: call, instanceof, store, frame_merge, trivial. (syntax: none|all|<perfWarning>,<perfWarning>,...)",
                /*container*/ getContainer(),
                /*option*/ TruffleCompilerOptions.TreatPerformanceWarningsAsErrors,
                /*fieldName*/ "TreatPerformanceWarningsAsErrors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 36;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("CompilationTimeout");
                    case 1: return get("DeoptCycleDetectionAllowedRepeats");
                    case 2: return get("DeoptCycleDetectionThreshold");
                    case 3: return get("DiagnoseFailure");
                    case 4: return get("EncodedGraphCache");
                    case 5: return get("ExcludeAssertions");
                    case 6: return get("FirstTierInliningPolicy");
                    case 7: return get("FirstTierUseEconomy");
                    case 8: return get("InlineAcrossTruffleBoundary");
                    case 9: return get("InlineOnly");
                    case 10: return get("Inlining");
                    case 11: return get("InliningExpansionBudget");
                    case 12: return get("InliningInliningBudget");
                    case 13: return get("InliningPolicy");
                    case 14: return get("InliningRecursionDepth");
                    case 15: return get("InliningUseSize");
                    case 16: return get("InstrumentBoundaries");
                    case 17: return get("InstrumentBoundariesPerInlineSite");
                    case 18: return get("InstrumentBranches");
                    case 19: return get("InstrumentBranchesPerInlineSite");
                    case 20: return get("InstrumentFilter");
                    case 21: return get("InstrumentationTableSize");
                    case 22: return get("IterativePartialEscape");
                    case 23: return get("LogInlinedTargets");
                    case 24: return get("MaximumGraalGraphSize");
                    case 25: return get("MethodExpansionStatistics");
                    case 26: return get("NodeExpansionStatistics");
                    case 27: return get("NodeSourcePositions");
                    case 28: return get("ParsePEGraphsWithAssumptions");
                    case 29: return get("TraceInlining");
                    case 30: return get("TraceInliningDetails");
                    case 31: return get("TraceMethodExpansion");
                    case 32: return get("TraceNodeExpansion");
                    case 33: return get("TracePerformanceWarnings");
                    case 34: return get("TraceStackTraceLimit");
                    case 35: return get("TreatPerformanceWarningsAsErrors");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
