// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.DeprecatedOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SubstrateOptions_DeprecatedOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(SubstrateOptions.DeprecatedOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "ParallelGCThreads": {
            return OptionDescriptor.create(
                /*name*/ "ParallelGCThreads",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of GC worker threads. Parallel and G1 GC only.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeprecatedOptions.ParallelGCThreads,
                /*fieldName*/ "ParallelGCThreads",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TearDownFailureNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownFailureNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before tearing down an isolate gives a failure message and returns from a tear-down call. 0 implies no message.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeprecatedOptions.TearDownFailureNanos,
                /*fieldName*/ "TearDownFailureNanos",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This call leaks resources. Instead, terminate java threads cooperatively, or use System#exit");
        }
        case "TearDownWarningNanos": {
            return OptionDescriptor.create(
                /*name*/ "TearDownWarningNanos",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of nanoseconds before and between which tearing down an isolate gives a warning message. 0 implies no warning.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeprecatedOptions.TearDownWarningNanos,
                /*fieldName*/ "TearDownWarningNanos",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Use -XX:TearDownWarningSeconds=<secs> instead");
        }
        case "UseEpsilonGC": {
            return OptionDescriptor.create(
                /*name*/ "UseEpsilonGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a no-op GC",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeprecatedOptions.UseEpsilonGC,
                /*fieldName*/ "UseEpsilonGC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--gc=epsilon' instead");
        }
        case "UseParallelGC": {
            return OptionDescriptor.create(
                /*name*/ "UseParallelGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a parallel GC",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeprecatedOptions.UseParallelGC,
                /*fieldName*/ "UseParallelGC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--gc=parallel' instead");
        }
        case "UseSerialGC": {
            return OptionDescriptor.create(
                /*name*/ "UseSerialGC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a serial GC",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeprecatedOptions.UseSerialGC,
                /*fieldName*/ "UseSerialGC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--gc=serial' instead");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 6;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("ParallelGCThreads");
                    case 1: return get("TearDownFailureNanos");
                    case 2: return get("TearDownWarningNanos");
                    case 3: return get("UseEpsilonGC");
                    case 4: return get("UseParallelGC");
                    case 5: return get("UseSerialGC");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
