// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SubstrateOptions.java
package com.oracle.svm.core;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SubstrateOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(SubstrateOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AOTInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AOTInline,
                /*fieldName*/ "AOTInline",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "AOTTrivialInline": {
            return OptionDescriptor.create(
                /*name*/ "AOTTrivialInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Perform trivial method inlining in the AOT compiled native image",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AOTTrivialInline,
                /*fieldName*/ "AOTTrivialInline",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "APIFunctionPrefix": {
            return OptionDescriptor.create(
                /*name*/ "APIFunctionPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of API functions.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.APIFunctionPrefix,
                /*fieldName*/ "APIFunctionPrefix",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AbortOnNameConflict": {
            return OptionDescriptor.create(
                /*name*/ "AbortOnNameConflict",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Throws an exception on potential type conflict during heap persisting if enabled",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AbortOnNameConflict,
                /*fieldName*/ "AbortOnNameConflict",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ActiveProcessorCount": {
            return OptionDescriptor.create(
                /*name*/ "ActiveProcessorCount",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Overwrites the available number of processors provided by the OS. Any value <= 0 means using the processor count from the OS.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ActiveProcessorCount,
                /*fieldName*/ "ActiveProcessorCount",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AdditionalHeaderBytes": {
            return OptionDescriptor.create(
                /*name*/ "AdditionalHeaderBytes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Add additional header bytes to each object, for diagnostic purposes.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AdditionalHeaderBytes,
                /*fieldName*/ "AdditionalHeaderBytes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocateInstancePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocateInstancePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the object address using prefetch instructions.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllocateInstancePrefetchLines,
                /*fieldName*/ "AllocateInstancePrefetchLines",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchDistance": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchDistance",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the size (in bytes) of the prefetch distance for object allocation. Memory about to be written with the value of new objects is prefetched up to this distance starting from the address of the last allocated object. Each Java thread has its own allocation point.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllocatePrefetchDistance,
                /*fieldName*/ "AllocatePrefetchDistance",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchInstr": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchInstr",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the prefetch instruction to prefetch ahead of the allocation pointer. Possible values are from 0 to 3. The actual instructions behind the values depend on the platform.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllocatePrefetchInstr,
                /*fieldName*/ "AllocatePrefetchInstr",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchLines": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of cache lines to load after the array allocation using prefetch instructions.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllocatePrefetchLines,
                /*fieldName*/ "AllocatePrefetchLines",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllocatePrefetchStepSize": {
            return OptionDescriptor.create(
                /*name*/ "AllocatePrefetchStepSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Sets the step size (in bytes) for sequential prefetch instructions.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllocatePrefetchStepSize,
                /*fieldName*/ "AllocatePrefetchStepSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AllowDeprecatedBuilderClassesOnImageClasspath": {
            return OptionDescriptor.create(
                /*name*/ "AllowDeprecatedBuilderClassesOnImageClasspath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instead of abort, only warn if image builder classes are found on the image class-path.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllowDeprecatedBuilderClassesOnImageClasspath,
                /*fieldName*/ "AllowDeprecatedBuilderClassesOnImageClasspath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option was introduced to simplify migration to GraalVM 23.0 and will be removed in a future release");
        }
        case "AllowUnsafeAllocationOfAllInstantiatedTypes": {
            return OptionDescriptor.create(
                /*name*/ "AllowUnsafeAllocationOfAllInstantiatedTypes",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allow all instantiated types to be allocated via Unsafe.allocateInstance().",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllowUnsafeAllocationOfAllInstantiatedTypes,
                /*fieldName*/ "AllowUnsafeAllocationOfAllInstantiatedTypes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "ThrowMissingRegistrationErrors is the preferred way of configuring this on a per-type level.");
        }
        case "AllowVMInternalThreads": {
            return OptionDescriptor.create(
                /*name*/ "AllowVMInternalThreads",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if VM internal threads (e.g., a dedicated VM operation or reference handling thread) are allowed in this image.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AllowVMInternalThreads,
                /*fieldName*/ "AllowVMInternalThreads",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ApplicationLayerInitializedClasses": {
            return OptionDescriptor.create(
                /*name*/ "ApplicationLayerInitializedClasses",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Register class as being initialized in the app layer.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ApplicationLayerInitializedClasses,
                /*fieldName*/ "ApplicationLayerInitializedClasses",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ApplicationLayerOnlySingletons": {
            return OptionDescriptor.create(
                /*name*/ "ApplicationLayerOnlySingletons",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Mark singleton as application layer only",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ApplicationLayerOnlySingletons,
                /*fieldName*/ "ApplicationLayerOnlySingletons",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "AsyncSignalSafeDiagnostics": {
            return OptionDescriptor.create(
                /*name*/ "AsyncSignalSafeDiagnostics",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Only print diagnostic output that is async signal safe.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.AsyncSignalSafeDiagnostics,
                /*fieldName*/ "AsyncSignalSafeDiagnostics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputBreakdowns": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputBreakdowns",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show code and heap breakdowns as part of the build output",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputBreakdowns,
                /*fieldName*/ "BuildOutputBreakdowns",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Deprecated without replacement");
        }
        case "BuildOutputColorful": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputColorful",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Color build output (enabled by default if colors are supported by terminal)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputColorful,
                /*fieldName*/ "BuildOutputColorful",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "Please use '--color' instead.");
        }
        case "BuildOutputGCWarnings": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputGCWarnings",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print GC warnings as part of build output",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputGCWarnings,
                /*fieldName*/ "BuildOutputGCWarnings",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputJSONFile": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputJSONFile",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Print build output statistics as JSON to the specified file. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-output-schema-v0.9.4.json",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputJSONFile,
                /*fieldName*/ "BuildOutputJSONFile",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputLinks": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputLinks",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show links in build output (defaults to the value of BuildOutputColorful)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputLinks,
                /*fieldName*/ "BuildOutputLinks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputPrefix": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputPrefix",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputPrefix,
                /*fieldName*/ "BuildOutputPrefix",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "BuildOutputProgress": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputProgress",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report progress in build output (default is adaptive)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputProgress,
                /*fieldName*/ "BuildOutputProgress",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputRecommendations": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputRecommendations",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show recommendations as part of the build output",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputRecommendations,
                /*fieldName*/ "BuildOutputRecommendations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "BuildOutputSilent": {
            return OptionDescriptor.create(
                /*name*/ "BuildOutputSilent",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Silence build output",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.BuildOutputSilent,
                /*fieldName*/ "BuildOutputSilent",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CCompilerOption": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerOption",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Provide custom C compiler option used for query code compilation.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CCompilerOption,
                /*fieldName*/ "CCompilerOption",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CCompilerPath": {
            return OptionDescriptor.create(
                /*name*/ "CCompilerPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Provide custom path to C compiler used for query code compilation and linking.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CCompilerPath,
                /*fieldName*/ "CCompilerPath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CLibraryPath": {
            return OptionDescriptor.create(
                /*name*/ "CLibraryPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Search path for C libraries passed to the linker (list of comma-separated directories)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CLibraryPath,
                /*fieldName*/ "CLibraryPath",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckBootModuleDependencies": {
            return OptionDescriptor.create(
                /*name*/ "CheckBootModuleDependencies",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Temporary option to disable checking of image builder module dependencies or increasing its verbosity",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CheckBootModuleDependencies,
                /*fieldName*/ "CheckBootModuleDependencies",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckIsolateThreadAtEntry": {
            return OptionDescriptor.create(
                /*name*/ "CheckIsolateThreadAtEntry",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "At CEntryPoints check that the passed IsolateThread is valid.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CheckIsolateThreadAtEntry,
                /*fieldName*/ "CheckIsolateThreadAtEntry",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CheckToolchain": {
            return OptionDescriptor.create(
                /*name*/ "CheckToolchain",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Check if native-toolchain is known to work with native-image",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CheckToolchain,
                /*fieldName*/ "CheckToolchain",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Class": {
            return OptionDescriptor.create(
                /*name*/ "Class",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Class containing the default entry point method. Optional if --shared is used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Class,
                /*fieldName*/ "Class",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClosedTypeWorld": {
            return OptionDescriptor.create(
                /*name*/ "ClosedTypeWorld",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Assume new types cannot be added after analysis",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ClosedTypeWorld,
                /*fieldName*/ "ClosedTypeWorld",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ClosedTypeWorldHubLayout": {
            return OptionDescriptor.create(
                /*name*/ "ClosedTypeWorldHubLayout",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use the closed type world dynamic hub representation. This is only allowed when the option ClosedTypeWorld is also set to true.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ClosedTypeWorldHubLayout,
                /*fieldName*/ "ClosedTypeWorldHubLayout",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Color": {
            return OptionDescriptor.create(
                /*name*/ "Color",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Color build output ('always', 'never', or 'auto')",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Color,
                /*fieldName*/ "Color",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilationIsolateAddressSpaceSize": {
            return OptionDescriptor.create(
                /*name*/ "CompilationIsolateAddressSpaceSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Size of the reserved address space of each compilation isolate (0: default for new isolates).",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CompilationIsolateAddressSpaceSize,
                /*fieldName*/ "CompilationIsolateAddressSpaceSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilationIsolateOptions": {
            return OptionDescriptor.create(
                /*name*/ "CompilationIsolateOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Options that are passed to each compilation isolate. Individual arguments are separated by spaces. Arguments that contain spaces need to be enclosed by single quotes.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CompilationIsolateOptions,
                /*fieldName*/ "CompilationIsolateOptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CompilerBackend": {
            return OptionDescriptor.create(
                /*name*/ "CompilerBackend",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Backend used by the compiler",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.CompilerBackend,
                /*fieldName*/ "CompilerBackend",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ConfigureReflectionMetadata": {
            return OptionDescriptor.create(
                /*name*/ "ConfigureReflectionMetadata",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable runtime instantiation of reflection objects for non-invoked methods.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ConfigureReflectionMetadata,
                /*fieldName*/ "ConfigureReflectionMetadata",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "ContendedPaddingWidth": {
            return OptionDescriptor.create(
                /*name*/ "ContendedPaddingWidth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "How many bytes to pad fields and classes marked @Contended with.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ContendedPaddingWidth,
                /*fieldName*/ "ContendedPaddingWidth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeadlockWatchdogExitOnTimeout": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogExitOnTimeout",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Exit the image builder VM after printing call stacks",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeadlockWatchdogExitOnTimeout,
                /*fieldName*/ "DeadlockWatchdogExitOnTimeout",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeadlockWatchdogInterval": {
            return OptionDescriptor.create(
                /*name*/ "DeadlockWatchdogInterval",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Integer.class,
                /*help*/ "The interval in minutes between watchdog checks (0 disables the watchdog)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeadlockWatchdogInterval,
                /*fieldName*/ "DeadlockWatchdogInterval",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugCodeInfoMaxDepth": {
            return OptionDescriptor.create(
                /*name*/ "DebugCodeInfoMaxDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specify maximum inlining depth to consider when building DebugCodeInfo",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DebugCodeInfoMaxDepth,
                /*fieldName*/ "DebugCodeInfoMaxDepth",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugCodeInfoUseSourceMappings": {
            return OptionDescriptor.create(
                /*name*/ "DebugCodeInfoUseSourceMappings",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Do not use SourceMappings for generating DebugCodeInfo (i.e. only use Infopoints)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DebugCodeInfoUseSourceMappings,
                /*fieldName*/ "DebugCodeInfoUseSourceMappings",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DebugInfoSourceCacheRoot": {
            return OptionDescriptor.create(
                /*name*/ "DebugInfoSourceCacheRoot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Directory under which to create source file cache for Application or GraalVM classes",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DebugInfoSourceCacheRoot,
                /*fieldName*/ "DebugInfoSourceCacheRoot",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DeleteLocalSymbols": {
            return OptionDescriptor.create(
                /*name*/ "DeleteLocalSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to remove all local symbols from image.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DeleteLocalSymbols,
                /*fieldName*/ "DeleteLocalSymbols",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DetectUserDirectoriesInImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "DetectUserDirectoriesInImageHeap",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "When set to true, the image generator verifies that the image heap does not contain a home directory as a substring",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DetectUserDirectoriesInImageHeap,
                /*fieldName*/ "DetectUserDirectoriesInImageHeap",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticBufferSize": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticBufferSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Specifies the number of entries that diagnostic buffers have.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DiagnosticBufferSize,
                /*fieldName*/ "DiagnosticBufferSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DiagnosticDetails": {
            return OptionDescriptor.create(
                /*name*/ "DiagnosticDetails",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ String.class,
                /*help*/ "Specifies how many details are printed for certain diagnostic thunks, e.g.: 'DumpThreads:1,DumpRegisters:2'. A value of 1 will result in the maximum amount of information, higher values will print less information. By default, the most detailed output is enabled for all diagnostic thunks. Wildcards (*) are supported in the name of the diagnostic thunk.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DiagnosticDetails,
                /*fieldName*/ "DiagnosticDetails",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableSubstitution": {
            return OptionDescriptor.create(
                /*name*/ "DisableSubstitution",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Disable the substitutions matched by the option value. A value can be a fully qualified method name with parameter list, a fully qualified method name without parameter list, or a fully qualified type name. When multiple methods match a value, then all matching substitutions are disabled.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DisableSubstitution,
                /*fieldName*/ "DisableSubstitution",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableTypeIdResultVerification": {
            return OptionDescriptor.create(
                /*name*/ "DisableTypeIdResultVerification",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "For internal purposes only. Disables type id result verification even when running with assertions enabled.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DisableTypeIdResultVerification,
                /*fieldName*/ "DisableTypeIdResultVerification",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DisableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "DisableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "List of comma separated URL protocols that must never be included.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DisableURLProtocols,
                /*fieldName*/ "DisableURLProtocols",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpHeapAndExit": {
            return OptionDescriptor.create(
                /*name*/ "DumpHeapAndExit",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Create a heap dump and exit.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DumpHeapAndExit,
                /*fieldName*/ "DumpHeapAndExit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DumpTargetInfo": {
            return OptionDescriptor.create(
                /*name*/ "DumpTargetInfo",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Show native-toolchain information and image-build settings",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.DumpTargetInfo,
                /*fieldName*/ "DumpTargetInfo",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableAllSecurityServices": {
            return OptionDescriptor.create(
                /*name*/ "EnableAllSecurityServices",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Add all security service classes to the generated image.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.EnableAllSecurityServices,
                /*fieldName*/ "EnableAllSecurityServices",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "EnableSignalHandling": {
            return OptionDescriptor.create(
                /*name*/ "EnableSignalHandling",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables signal handling",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.EnableSignalHandling,
                /*fieldName*/ "EnableSignalHandling",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableURLProtocols": {
            return OptionDescriptor.create(
                /*name*/ "EnableURLProtocols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "List of comma separated URL protocols to enable.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.EnableURLProtocols,
                /*fieldName*/ "EnableURLProtocols",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EnableWildcardExpansion": {
            return OptionDescriptor.create(
                /*name*/ "EnableWildcardExpansion",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable wildcard expansion in command line arguments on Windows.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.EnableWildcardExpansion,
                /*fieldName*/ "EnableWildcardExpansion",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "EntryPointNamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "EntryPointNamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Prefix that is added to the names of entry point methods.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.EntryPointNamePrefix,
                /*fieldName*/ "EntryPointNamePrefix",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FallbackThreshold": {
            return OptionDescriptor.create(
                /*name*/ "FallbackThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define when fallback-image generation should be used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.FallbackThreshold,
                /*fieldName*/ "FallbackThreshold",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorder": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorder",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Flight Recorder.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.FlightRecorder,
                /*fieldName*/ "FlightRecorder",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorderLogging": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorderLogging",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Usage: -XX:FlightRecorderLogging=[tag1[+tag2...][*][=level][,...]]

When this option is not set, logging is enabled at a level of WARNING.
When this option is set to the empty string, logging is enabled at a level of INFO.
When this option is set to \"disable\", logging is disabled entirely.

Otherwise, this option expects a comma separated list of tag combinations, each with an optional wildcard (*) and level.
A tag combination without a level is given a default level of INFO.
Messages with tags that match a given tag combination are set to log at that tag combination's level.
If a tag combination does not have a wildcard, then only messages with exactly the same tags are matched.
Otherwise, messages whose tags are a subset of the tag combination are matched.
Specifying \"all\" instead of a tag combination matches all tag combinations.
If more than one tag combination matches a message's tags, the rightmost one will apply.
Messages with tags that do not have any matching tag combinations are set to log at a default level of WARNING.
This option is case insensitive.

Available log levels:
[trace, debug, info, warning, error, off]

Available log tags:
[jfr, system, event, setting, bytecode, parser, metadata, dcmd]""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.FlightRecorderLogging,
                /*fieldName*/ "FlightRecorderLogging",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FlightRecorderOptions": {
            return OptionDescriptor.create(
                /*name*/ "FlightRecorderOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Usage: -XX:FlightRecorderOptions=[option[=value][,...]]

This option expects a comma separated list of key-value pairs. None of the options are mandatory. Possible option keys are as follows:

globalbuffersize=512k      (Optional) Size of each global JFR buffer.
                           This value cannot be changed once JFR has been initialized.
                           The default value is determined by the value for memorysize.

maxchunksize=12m           (Optional) Maximum size of each individual JFR data chunk.
                           This value cannot be changed once JFR has been initialized.

memorysize=10m             (Optional) Total size of all global JFR buffers.
                           This value cannot be changed once JFR has been initialized.

old-object-queue-size=256  (Optional) The maximum number of old objects to track when the JFR event
                           OldObjectSample is enabled.

repository=...             (Optional) Path to the location where JFR recordings are stored until they are
                           written to a permanent file.
                           The default location is the temporary directory for the operating system.

stackdepth=64              (Optional) Stack depth for stack traces.
                           Setting this value greater than the default may cause a performance degradation.
                           This value cannot be changed once JFR has been initialized.

threadbuffersize=8k        (Optional) Size of each thread-local JFR buffer.
                           This value cannot be changed once JFR has been initialized.

preserve-repository=false  (Optional) Preserve files stored in the disk repository after the process exits.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.FlightRecorderOptions,
                /*fieldName*/ "FlightRecorderOptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "FoldSecurityManagerGetter": {
            return OptionDescriptor.create(
                /*name*/ "FoldSecurityManagerGetter",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fold SecurityManager getter.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.FoldSecurityManagerGetter,
                /*fieldName*/ "FoldSecurityManagerGetter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ForeignAPISupport": {
            return OptionDescriptor.create(
                /*name*/ "ForeignAPISupport",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support for calls via the Java Foreign Function and Memory API",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ForeignAPISupport,
                /*fieldName*/ "ForeignAPISupport",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenerateBuildArtifactsFile": {
            return OptionDescriptor.create(
                /*name*/ "GenerateBuildArtifactsFile",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Create a build-artifacts.json file in the build directory. The output conforms to the JSON schema located at: docs/reference-manual/native-image/assets/build-artifacts-schema-v0.9.0.json",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.GenerateBuildArtifactsFile,
                /*fieldName*/ "GenerateBuildArtifactsFile",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "GenerateDebugInfo": {
            return OptionDescriptor.create(
                /*name*/ "GenerateDebugInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Insert debug info into the generated native image or library",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.GenerateDebugInfo,
                /*fieldName*/ "GenerateDebugInfo",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapDumpDefaultFilenamePrefix": {
            return OptionDescriptor.create(
                /*name*/ "HeapDumpDefaultFilenamePrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "A prefix that is used for heap dump filenames if no heap dump filename was specified explicitly.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.HeapDumpDefaultFilenamePrefix,
                /*fieldName*/ "HeapDumpDefaultFilenamePrefix",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapDumpOnOutOfMemoryError": {
            return OptionDescriptor.create(
                /*name*/ "HeapDumpOnOutOfMemoryError",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Dump heap to file (see HeapDumpPath) the first time the image throws java.lang.OutOfMemoryError because it ran out of Java heap.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.HeapDumpOnOutOfMemoryError,
                /*fieldName*/ "HeapDumpOnOutOfMemoryError",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapDumpPath": {
            return OptionDescriptor.create(
                /*name*/ "HeapDumpPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Path of the file or directory in which heap dumps are created. An empty value means a default file name will be used. An existing directory means the dump will be placed in the directory and have the default file name.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.HeapDumpPath,
                /*fieldName*/ "HeapDumpPath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IgnorePreserveForClasses": {
            return OptionDescriptor.create(
                /*name*/ "IgnorePreserveForClasses",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Ignore classes or packages (comma separated) from the ones included with '-H:Preserve'. This can be used to workaround potential issues related to '-H:Preserve'.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.IgnorePreserveForClasses,
                /*fieldName*/ "IgnorePreserveForClasses",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageBuildID": {
            return OptionDescriptor.create(
                /*name*/ "ImageBuildID",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Image Build ID is a 128-bit UUID string generated randomly, once per bundle or digest of input args when bundles are not used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ImageBuildID,
                /*fieldName*/ "ImageBuildID",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ImageSymbolsPrefix": {
            return OptionDescriptor.create(
                /*name*/ "ImageSymbolsPrefix",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Common prefix used by method symbols in image.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ImageSymbolsPrefix,
                /*fieldName*/ "ImageSymbolsPrefix",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeDebugHelperMethods": {
            return OptionDescriptor.create(
                /*name*/ "IncludeDebugHelperMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if debugging-specific helper methods are embedded into the image. Those methods can be called directly from the debugger to obtain or print additional information.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.IncludeDebugHelperMethods,
                /*fieldName*/ "IncludeDebugHelperMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeMethodData": {
            return OptionDescriptor.create(
                /*name*/ "IncludeMethodData",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Include a list of methods included in the image for runtime inspection.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.IncludeMethodData,
                /*fieldName*/ "IncludeMethodData",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "IncludeNodeSourcePositions": {
            return OptionDescriptor.create(
                /*name*/ "IncludeNodeSourcePositions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track NodeSourcePositions during runtime-compilation",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.IncludeNodeSourcePositions,
                /*fieldName*/ "IncludeNodeSourcePositions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InstallExitHandlers": {
            return OptionDescriptor.create(
                /*name*/ "InstallExitHandlers",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Provide java.lang.Terminator exit handlers. Default value is true for executables and false for shared libraries because this option installs signal handlers.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.InstallExitHandlers,
                /*fieldName*/ "InstallExitHandlers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InternalSymbolsAreGlobal": {
            return OptionDescriptor.create(
                /*name*/ "InternalSymbolsAreGlobal",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Compatibility option to make symbols used for the image heap global. Using global symbols is problematic for shared libraries because the loader implicitly changes the value when the symbol is already defined in the executable loading the library. Setting this option to true preserves the broken behavior of old Native Image versions.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.InternalSymbolsAreGlobal,
                /*fieldName*/ "InternalSymbolsAreGlobal",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InternalThreadStackSize": {
            return OptionDescriptor.create(
                /*name*/ "InternalThreadStackSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "Deprecated, has no effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.InternalThreadStackSize,
                /*fieldName*/ "InternalThreadStackSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "JNI": {
            return OptionDescriptor.create(
                /*name*/ "JNI",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable Java Native Interface (JNI) support.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JNI,
                /*fieldName*/ "JNI",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIEnhancedErrorCodes": {
            return OptionDescriptor.create(
                /*name*/ "JNIEnhancedErrorCodes",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "JNI functions will return more specific error codes.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JNIEnhancedErrorCodes,
                /*fieldName*/ "JNIEnhancedErrorCodes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIExportSymbols": {
            return OptionDescriptor.create(
                /*name*/ "JNIExportSymbols",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Export Invocation API symbols.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JNIExportSymbols,
                /*fieldName*/ "JNIExportSymbols",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JNIVerboseLookupErrors": {
            return OptionDescriptor.create(
                /*name*/ "JNIVerboseLookupErrors",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report information about known JNI elements when lookup fails",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JNIVerboseLookupErrors,
                /*fieldName*/ "JNIVerboseLookupErrors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JVMTI": {
            return OptionDescriptor.create(
                /*name*/ "JVMTI",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable JVM Tool Interface (JVMTI) support.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JVMTI,
                /*fieldName*/ "JVMTI",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JVMTIAgentLib": {
            return OptionDescriptor.create(
                /*name*/ "JVMTIAgentLib",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Loads the specified native agent library. After the library name, a comma-separated list of options specific to the library can be used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JVMTIAgentLib,
                /*fieldName*/ "JVMTIAgentLib",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JVMTIAgentPath": {
            return OptionDescriptor.create(
                /*name*/ "JVMTIAgentPath",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Loads the specified native agent library specified by the absolute path name. After the library path, a comma-separated list of options specific to the library can be used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.JVMTIAgentPath,
                /*fieldName*/ "JVMTIAgentPath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LayerCreate": {
            return OptionDescriptor.create(
                /*name*/ "LayerCreate",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Experimental: Build a Native Image layer.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LayerCreate,
                /*fieldName*/ "LayerCreate",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LayerOptionVerification": {
            return OptionDescriptor.create(
                /*name*/ "LayerOptionVerification",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Experimental: Perform strict checking of options used for layered image build.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LayerOptionVerification,
                /*fieldName*/ "LayerOptionVerification",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LayerOptionVerificationVerbose": {
            return OptionDescriptor.create(
                /*name*/ "LayerOptionVerificationVerbose",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Experimental: Provide verbose output of difference in builder options between layers.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LayerOptionVerificationVerbose,
                /*fieldName*/ "LayerOptionVerificationVerbose",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LayerUse": {
            return OptionDescriptor.create(
                /*name*/ "LayerUse",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Paths.class,
                /*help*/ "Experimental: Build an image based on a Native Image layer.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LayerUse,
                /*fieldName*/ "LayerUse",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LibGraalClassLoader": {
            return OptionDescriptor.create(
                /*name*/ "LibGraalClassLoader",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Specify the fully qualified name of a class that implements org.graalvm.nativeimage.libgraal.LibGraalLoader.

This option is only supported for building the libgraal shared library.

The named class is instantiated via the default constructor.
It affects image building as follows:

 1. The custom loader is used to lookup Feature implementations passed via the --features option.
 2. All @CEntryPoint definitions in classes loaded by the custom loader are processed.
 3. All @TargetClass substitutions in classes loaded by the custom loader are processed.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LibGraalClassLoader,
                /*fieldName*/ "LibGraalClassLoader",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LinkerRPath": {
            return OptionDescriptor.create(
                /*name*/ "LinkerRPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Path passed to the linker as the -rpath (list of comma-separated directories)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LinkerRPath,
                /*fieldName*/ "LinkerRPath",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LoggingHashCodeInjection": {
            return OptionDescriptor.create(
                /*name*/ "LoggingHashCodeInjection",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enables logging of failed hash code injection",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.LoggingHashCodeInjection,
                /*fieldName*/ "LoggingHashCodeInjection",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxDirectMemorySize": {
            return OptionDescriptor.create(
                /*name*/ "MaxDirectMemorySize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "Maximum total size of NIO direct-buffer allocations",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MaxDirectMemorySize,
                /*fieldName*/ "MaxDirectMemorySize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxInvokesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxInvokesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of invokes in a method so that it is considered trivial (for testing only).",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MaxInvokesInTrivialMethod,
                /*fieldName*/ "MaxInvokesInTrivialMethod",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesAfterTrivialInlining": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesAfterTrivialInlining",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of nodes in a graph allowed after trivial inlining.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MaxNodesAfterTrivialInlining,
                /*fieldName*/ "MaxNodesAfterTrivialInlining",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesInTrivialLeafMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialLeafMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial, if it does not have any invokes.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MaxNodesInTrivialLeafMethod,
                /*fieldName*/ "MaxNodesInTrivialLeafMethod",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxNodesInTrivialMethod": {
            return OptionDescriptor.create(
                /*name*/ "MaxNodesInTrivialMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of nodes in a method so that it is considered trivial.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MaxNodesInTrivialMethod,
                /*fieldName*/ "MaxNodesInTrivialMethod",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxUnrolledObjectZeroingStores": {
            return OptionDescriptor.create(
                /*name*/ "MaxUnrolledObjectZeroingStores",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Define the maximum number of stores for which the loop that zeroes out objects is unrolled.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MaxUnrolledObjectZeroingStores,
                /*fieldName*/ "MaxUnrolledObjectZeroingStores",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Method": {
            return OptionDescriptor.create(
                /*name*/ "Method",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the main entry point method. Optional if --shared is used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Method,
                /*fieldName*/ "Method",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MissingRegistrationReportingMode": {
            return OptionDescriptor.create(
                /*name*/ "MissingRegistrationReportingMode",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.SubstrateOptions.ReportingMode.class,
                /*help*/ """
Select the mode in which the missing reflection registrations will be reported.
Possible values are:\",
 \"Throw\" (default): Throw a MissingReflectionRegistrationError;
 \"Exit\": Call System.exit() to avoid accidentally catching the error;
 \"Warn\": Print a message to stdout, including a stack trace to see what caused the issue.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MissingRegistrationReportingMode,
                /*fieldName*/ "MissingRegistrationReportingMode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MissingRegistrationWarnContextLines": {
            return OptionDescriptor.create(
                /*name*/ "MissingRegistrationWarnContextLines",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of context lines printed for each missing registration error in Warn mode",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MissingRegistrationWarnContextLines,
                /*fieldName*/ "MissingRegistrationWarnContextLines",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Module": {
            return OptionDescriptor.create(
                /*name*/ "Module",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Module containing the class that contains the main entry point. Optional if --shared is used.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Module,
                /*fieldName*/ "Module",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MremapImageHeap": {
            return OptionDescriptor.create(
                /*name*/ "MremapImageHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable fallback to mremap for initializing the image heap.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MremapImageHeap,
                /*fieldName*/ "MremapImageHeap",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MultiThreaded": {
            return OptionDescriptor.create(
                /*name*/ "MultiThreaded",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, has no effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.MultiThreaded,
                /*fieldName*/ "MultiThreaded",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "Name": {
            return OptionDescriptor.create(
                /*name*/ "Name",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Name of the output file to be generated",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Name,
                /*fieldName*/ "Name",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NeverInline": {
            return OptionDescriptor.create(
                /*name*/ "NeverInline",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ """
Pattern for disabling inlining of methods during image generation.
The syntax for a pattern is:

  SourcePatterns = SourcePattern [\",\" SourcePatterns] .
  SourcePattern = [ Class \".\" ] method [ \"(\" [ Parameter { \";\" Parameter } ] \")\" ] .
  Parameter = Class | \"int\" | \"long\" | \"float\" | \"double\" | \"short\" | \"char\" | \"boolean\" .
  Class = { package \".\" } class .

Glob pattern matching (*, ?) is allowed in all parts of the source pattern.

Examples of method filters:
---------
  visit(Argument;BlockScope)

  Matches all methods named \"visit\", with the first parameter of
  type \"Argument\", and the second parameter of type \"BlockScope\".
  The packages of the parameter types are irrelevant.
---------
  arraycopy(Object;;;;)

  Matches all methods named \"arraycopy\", with the first parameter
  of type \"Object\", and four more parameters of any type. The
  packages of the parameter types are irrelevant.
---------
  jdk.graal.compiler.core.graph.PostOrderNodeIterator.*

  Matches all methods in the class \"jdk.graal.compiler.core.graph.PostOrderNodeIterator\".
---------
  *

  Matches all methods in all classes
---------
  jdk.graal.compiler.core.graph.*.visit

  Matches all methods named \"visit\" in classes in the package
  \"jdk.graal.compiler.core.graph\".
---------
  arraycopy,toString

  Matches all methods named \"arraycopy\" or \"toString\", meaning that ',' acts as an or operator.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.NeverInline,
                /*fieldName*/ "NeverInline",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "NoDirectRelocationsInText": {
            return OptionDescriptor.create(
                /*name*/ "NoDirectRelocationsInText",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force no direct relocations to be present in the text section of the generated image",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.NoDirectRelocationsInText,
                /*fieldName*/ "NoDirectRelocationsInText",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "OmitInlinedMethodDebugLineInfo": {
            return OptionDescriptor.create(
                /*name*/ "OmitInlinedMethodDebugLineInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Omit generation of DebugLineInfo originating from inlined methods",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.OmitInlinedMethodDebugLineInfo,
                /*fieldName*/ "OmitInlinedMethodDebugLineInfo",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Optimize": {
            return OptionDescriptor.create(
                /*name*/ "Optimize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ String.class,
                /*help*/ "Control code optimizations: b - optimize for fastest build time, s - optimize for size, 0 - no optimizations, 1 - basic optimizations, 2 - advanced optimizations, 3 - all optimizations for best performance.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Optimize,
                /*fieldName*/ "Optimize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ParseOnce": {
            return OptionDescriptor.create(
                /*name*/ "ParseOnce",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ParseOnce,
                /*fieldName*/ "ParseOnce",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "ParseOnceJIT": {
            return OptionDescriptor.create(
                /*name*/ "ParseOnceJIT",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ParseOnceJIT,
                /*fieldName*/ "ParseOnceJIT",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "ParseRuntimeOptions": {
            return OptionDescriptor.create(
                /*name*/ "ParseRuntimeOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Parse and consume standard options and system properties from the command line arguments when the VM is created.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ParseRuntimeOptions,
                /*fieldName*/ "ParseRuntimeOptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PinnedObjectAddressing": {
            return OptionDescriptor.create(
                /*name*/ "PinnedObjectAddressing",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Allows the addresses of pinned objects to be passed to other code.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.PinnedObjectAddressing,
                /*fieldName*/ "PinnedObjectAddressing",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "Preserve": {
            return OptionDescriptor.create(
                /*name*/ "Preserve",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ """
Preserves all classes and relevant resources from selected classpath entries in the image.
For the selected classpath entries it is not necessary to provide reachability metadata because all classes, as well as resources not ending in '.class' or '.jar', are included into the image.
Please note that using this option can result in a significant increase in build time and binary size, as well as a decrease in runtime performance.

Usage: -H:Preserve=[all|none|module=<module>|package=<package>|package=<package-wildcard>|path=<cp-entry>][,...]

The flag can be used in following ways:
1. -H:Preserve=all preserves all elements from the JDK, the classpath, and the module path
2. -H:Preserve=module=<module> preserves all elements from a given module
3. -H:Preserve=module=ALL-UNNAMED preserves all elements from all class-path entries
4. -H:Preserve=package=<package> preserves all elements from a given package
5. -H:Preserve=package=<package-wildcard> preserves all elements from packages captured by the wildcard. For example, -H:Preserve=package=my.app.*
6. -H:Preserve=path=<cp-entry> preserves all elements from a given class-path entry
7. -H:Preserve=none disables all previous selections for preservation
8. A comma-separated list of the previous cases. For example, -H:Preserve=path=<cp-entry>,module=<module>,package=<package>

'-H:Preserve' is only allowed on the native-image command line and cannot be embedded in the native-image.properties files.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.Preserve,
                /*fieldName*/ "Preserve",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PreserveFramePointer": {
            return OptionDescriptor.create(
                /*name*/ "PreserveFramePointer",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Saves stack base pointer on the stack on method entry.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.PreserveFramePointer,
                /*fieldName*/ "PreserveFramePointer",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintClosedArenaUponThrow": {
            return OptionDescriptor.create(
                /*name*/ "PrintClosedArenaUponThrow",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Flag indicating if the code checking for closed arenas should print to stdout when it sees an exception.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.PrintClosedArenaUponThrow,
                /*fieldName*/ "PrintClosedArenaUponThrow",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintVMInfoAndExit": {
            return OptionDescriptor.create(
                /*name*/ "PrintVMInfoAndExit",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print some VM information and exit.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.PrintVMInfoAndExit,
                /*fieldName*/ "PrintVMInfoAndExit",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReduceImplicitExceptionStackTraceInformation": {
            return OptionDescriptor.create(
                /*name*/ "ReduceImplicitExceptionStackTraceInformation",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Reduce the amount of metadata in the image for implicit exceptions by removing inlining information from the stack trace. This makes the image smaller, but also the stack trace of implicit exceptions less precise.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ReduceImplicitExceptionStackTraceInformation,
                /*fieldName*/ "ReduceImplicitExceptionStackTraceInformation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RelativeCodePointers": {
            return OptionDescriptor.create(
                /*name*/ "RelativeCodePointers",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Avoid linker relocations for code and instead emit address computations.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.RelativeCodePointers,
                /*fieldName*/ "RelativeCodePointers",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RemoveUnusedSymbols": {
            return OptionDescriptor.create(
                /*name*/ "RemoveUnusedSymbols",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use linker option to prevent unreferenced symbols in image.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.RemoveUnusedSymbols,
                /*fieldName*/ "RemoveUnusedSymbols",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ReportAnalysisForbiddenType": {
            return OptionDescriptor.create(
                /*name*/ "ReportAnalysisForbiddenType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Report error if <typename>[:<UsageKind>{,<UsageKind>}] is discovered during analysis (valid values for UsageKind: Reachable, Instantiated).",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ReportAnalysisForbiddenType,
                /*fieldName*/ "ReportAnalysisForbiddenType",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RunMainInNewThread": {
            return OptionDescriptor.create(
                /*name*/ "RunMainInNewThread",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Initializes and runs main entry point in a new native thread.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.RunMainInNewThread,
                /*fieldName*/ "RunMainInNewThread",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SharedArenaSupport": {
            return OptionDescriptor.create(
                /*name*/ "SharedArenaSupport",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable support for Arena.ofShared ",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.SharedArenaSupport,
                /*fieldName*/ "SharedArenaSupport",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SharedLibrary": {
            return OptionDescriptor.create(
                /*name*/ "SharedLibrary",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build shared library",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.SharedLibrary,
                /*fieldName*/ "SharedLibrary",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SourceLevelDebug": {
            return OptionDescriptor.create(
                /*name*/ "SourceLevelDebug",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Preserve the local variable information for every Java source line to allow line-by-line stepping in the debugger. Allow the lookup of Java-level method information, e.g., in stack traces.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.SourceLevelDebug,
                /*fieldName*/ "SourceLevelDebug",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SourceLevelDebugFilter": {
            return OptionDescriptor.create(
                /*name*/ "SourceLevelDebugFilter",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Constrain debug info generation to the comma-separated list of package prefixes given to this option.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.SourceLevelDebugFilter,
                /*fieldName*/ "SourceLevelDebugFilter",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpawnIsolates": {
            return OptionDescriptor.create(
                /*name*/ "SpawnIsolates",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support multiple isolates.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.SpawnIsolates,
                /*fieldName*/ "SpawnIsolates",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option disables a major feature of GraalVM Native Image and will be removed in a future release");
        }
        case "StackSize": {
            return OptionDescriptor.create(
                /*name*/ "StackSize",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of each thread stack at run-time, in bytes.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StackSize,
                /*fieldName*/ "StackSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StackTrace": {
            return OptionDescriptor.create(
                /*name*/ "StackTrace",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, has no effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StackTrace,
                /*fieldName*/ "StackTrace",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "");
        }
        case "StartFlightRecording": {
            return OptionDescriptor.create(
                /*name*/ "StartFlightRecording",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ """
Start a flight recording by passing a comma-separated list of key-value pairs.

Usage: -XX:StartFlightRecording=[key[=value][,...]]

The following key-value pairs are supported:

name       (Optional) Specify a name to identify the recording, for example, `name=MyRecording` to identify the recording, for example, \"name=MyRecording\".

settings   (Optional) Specify a settings file (profile.jfc, default.jfc, etc.), for example, \"settings=myprofile.jfc\".

delay      (Optional) Delay recording start with (s)econds, (m)inutes, (h)ours, or (d)ays, for example, \"delay=5h\".

duration   (Optional) Duration of recording in (s)econds, (m)inutes, (h)ours, or (d)ays for example, \"duration=300s\". Default: 0 (infinite).

filename   (Optional) Specify a resulting recording filename, for example, \"filename=recording1.jfr\".

maxage     (Optional) Maximum time to keep the recorded data on disk in (s)econds, (m)inutes, (h)ours, or (d)ays, e.g., 60m, or 0 for no limit, for example, \"maxage=1d\". Default: 0 (no limit).

maxsize    (Optional) Maximum amount of bytes to keep on disk in (k)B, (M)B or (G)B, or 0 for no limit, for example, 500M, or 0 for no limit, for example, \"maxsize=1G\". Default: 0 (no limit).

dumponexit (Optional) Whether to dump a running recording when the JVM shuts down, for example, \"dumponexit=true\". Default: false.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StartFlightRecording,
                /*fieldName*/ "StartFlightRecording",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticExecutable": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutable",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable (requires static libc and zlib)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StaticExecutable,
                /*fieldName*/ "StaticExecutable",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticExecutableWithDynamicLibC": {
            return OptionDescriptor.create(
                /*name*/ "StaticExecutableWithDynamicLibC",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Build statically linked executable with libc dynamically linked",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StaticExecutableWithDynamicLibC,
                /*fieldName*/ "StaticExecutableWithDynamicLibC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StaticLibStdCpp": {
            return OptionDescriptor.create(
                /*name*/ "StaticLibStdCpp",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Builds image with libstdc++ statically linked into the image (if needed)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StaticLibStdCpp,
                /*fieldName*/ "StaticLibStdCpp",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StrictQueryCodeCompilation": {
            return OptionDescriptor.create(
                /*name*/ "StrictQueryCodeCompilation",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use strict checks when performing query code compilation.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StrictQueryCodeCompilation,
                /*fieldName*/ "StrictQueryCodeCompilation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "StripDebugInfo": {
            return OptionDescriptor.create(
                /*name*/ "StripDebugInfo",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use a separate file for debug info.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.StripDebugInfo,
                /*fieldName*/ "StripDebugInfo",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SupportedGCs": {
            return OptionDescriptor.create(
                /*name*/ "SupportedGCs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.ReplacingLocatableMultiOptionValue.DelimitedString.class,
                /*help*/ "Please use '--gc=*' instead. Possible values are listed with '--help'.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.SupportedGCs,
                /*fieldName*/ "SupportedGCs",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TargetPlatform": {
            return OptionDescriptor.create(
                /*name*/ "TargetPlatform",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Selects native-image compilation target (in <OS>-<architecture> format). Defaults to host's OS-architecture pair.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TargetPlatform,
                /*fieldName*/ "TargetPlatform",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TearDownWarningSeconds": {
            return OptionDescriptor.create(
                /*name*/ "TearDownWarningSeconds",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The number of seconds before and between which tearing down an isolate gives a warning message. 0 implies no warning.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TearDownWarningSeconds,
                /*fieldName*/ "TearDownWarningSeconds",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowLinkAtBuildTimeIOExceptions": {
            return OptionDescriptor.create(
                /*name*/ "ThrowLinkAtBuildTimeIOExceptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Instead of warning, throw IOExceptions for link-at-build-time resources at build time",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ThrowLinkAtBuildTimeIOExceptions,
                /*fieldName*/ "ThrowLinkAtBuildTimeIOExceptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowMissingRegistrationErrors": {
            return OptionDescriptor.create(
                /*name*/ "ThrowMissingRegistrationErrors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ """
Enables exact and user-friendly handling of reflection, resources, JNI, and serialization.
When reachability metadata for an element is specified, the native executable will have expected and predictable behavior.
When reachability metadata for an element is not specified, the binary will fail fast with a subtype of `java.lang.Error`
 that explains exactly which element was missing. The errors can happen on reflection, resource, JNI, and serialization accesses.

Note: '--exact-reachability-metadata' will become the default in future versions of Native Image. It is recommended to adopt the mode early
 to avoid breakage during migration to newer GraalVM versions.

If errors occur in third-party code, exact reachability metadata can be applied only to a single package with
 '--exact-reachability-metadata=pkg'. To apply to whole jars, modules, and class-path entries please use
 '--exact-reachability-metadata-path'. Using '--exact-reachability-metadata=<pkg>' with arguments is allowed in every scope:

  1. On command line
  2. Embedded in a 'native-image.properties' file of some zip/jar file on module-path
  3. Embedded in a 'native-image.properties' file of some zip/jar file on class-path

If used without arguments (only '--exact-reachability-metadata'), the errors will be thrown when calling the corresponding query from any
 class in scope of the option. Using '--exact-reachability-metadata' without arguments is only allowed on command line or when
 embedded in a 'native-image.properties' file of some zip/jar file on the module-path (but not on class-path).
 In the module path case, the option will cause all classes of the module to trigger missing registration errors.
 If used without arguments on command line all classes will trigger missing registration errors.

If the option is embedded in 'native-image.properties' file in some zip/jar file all class-names
and package-names passed to the option have to be found in the zip/jar files the option is embedded
in. Using '--exact-reachability-metadata' with arguments on command line does not have that restriction.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ThrowMissingRegistrationErrors,
                /*fieldName*/ "ThrowMissingRegistrationErrors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ThrowMissingRegistrationErrorsPaths": {
            return OptionDescriptor.create(
                /*name*/ "ThrowMissingRegistrationErrorsPaths",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ """
Trigger exact handling of reflection, resources, JNI, and serialization from all types in the given class-path or module-path entries.

This option requires arguments that are of the same type as the arguments passed via -p (--module-path) or -cp (--class-path):

  --exact-reachability-metadata-path <class-search path of directories and jar files>

The given entries are searched and all classes inside are registered as '--exact-reachability-metadata' classes.

This option is only allowed to be used on command line. The option will be rejected if it is provided
by 'Args' in a 'native-image.properties' file that is embedded in a jar file.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ThrowMissingRegistrationErrorsPaths,
                /*fieldName*/ "ThrowMissingRegistrationErrorsPaths",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceClassInitialization": {
            return OptionDescriptor.create(
                /*name*/ "TraceClassInitialization",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma-separated list of fully-qualified class names that class initialization is traced for.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TraceClassInitialization,
                /*fieldName*/ "TraceClassInitialization",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "This option is not required anymore with the strict image heap enabled by default.");
        }
        case "TraceNativeToolUsage": {
            return OptionDescriptor.create(
                /*name*/ "TraceNativeToolUsage",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace all native tool invocations as part of image building",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TraceNativeToolUsage,
                /*fieldName*/ "TraceNativeToolUsage",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceObjectInstantiation": {
            return OptionDescriptor.create(
                /*name*/ "TraceObjectInstantiation",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Comma-separated list of fully-qualified class names that object instantiation is traced for.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TraceObjectInstantiation,
                /*fieldName*/ "TraceObjectInstantiation",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceVMOperations": {
            return OptionDescriptor.create(
                /*name*/ "TraceVMOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace VMOperation execution.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TraceVMOperations,
                /*fieldName*/ "TraceVMOperations",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackDynamicAccess": {
            return OptionDescriptor.create(
                /*name*/ "TrackDynamicAccess",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ """
Reports all reflection (e.g., Class#forName(String)) and resource (e.g., Class#getResource(String)) calls in reachable code that require metadata for dynamic access.
The analysis is limited to the provided comma-separated list of class-path entries, and module or package names.
If any dynamic access calls are found, a \"dynamic-access\" directory is created in the native image output,
and the calls are serialized in \"dynamic-access/<entry-name>/[reflection-calls.json][resource-calls.json]\".

Usage: -H:TrackDynamicAccess=[all|none|to-console|no-dump|path=<cp-entry>|module=<module>|package=<package>][,...]

The flag can be used in following ways:
1. -H:TrackDynamicAccess=all reports all dynamic access calls made across the entire project
2. -H:TrackDynamicAccess=path=<cp-entry> reports all dynamic access calls made from the specified class-path entry
3. -H:TrackDynamicAccess=module=<module> reports all dynamic access calls made from the specified module
4. -H:TrackDynamicAccess=package=<package> reports all dynamic access calls made from the specified package
5. -H:TrackDynamicAccess=none disables all previous selections for dynamic access detection
6. -H:TrackDynamicAccess=to-console outputs all detected dynamic access calls to the console
7. -H:TrackDynamicAccess=no-dump disables the serialization of detected dynamic access calls
8. A comma-separated list of the previous cases. For example, -H:TrackDynamicAccess=path=<cp-entry>,module=<module>,package=<package>

Example of the option usage:

    native-image -cp lib/app.jar:lib/util.jar:lib/tck.jar -H:TrackDynamicAccess=path=lib/app.jar,path=lib/util.jar HelloWorld

    In this example, the phase will look for dynamic access calls in lib/app.jar and lib/util.jar, and will not detect any calls in lib/tck.jar.""",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TrackDynamicAccess,
                /*fieldName*/ "TrackDynamicAccess",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackJavaHomeAccess": {
            return OptionDescriptor.create(
                /*name*/ "TrackJavaHomeAccess",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track System.getProperty(\\\"java.home\\\") usage in reachable parts of the project.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TrackJavaHomeAccess,
                /*fieldName*/ "TrackJavaHomeAccess",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TrackJavaHomeAccessDetailed": {
            return OptionDescriptor.create(
                /*name*/ "TrackJavaHomeAccessDetailed",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Output all System.getProperty(\\\"java.home\\\") calls in reachable parts of the project.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.TrackJavaHomeAccessDetailed,
                /*fieldName*/ "TrackJavaHomeAccessDetailed",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UnlockExperimentalVMOptions": {
            return OptionDescriptor.create(
                /*name*/ "UnlockExperimentalVMOptions",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable and disable normal processing of flags relating to experimental options.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UnlockExperimentalVMOptions,
                /*fieldName*/ "UnlockExperimentalVMOptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseBaseLayerInclusionPolicy": {
            return OptionDescriptor.create(
                /*name*/ "UseBaseLayerInclusionPolicy",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force include include all public types and methods that can be reached using normal Java access rules.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseBaseLayerInclusionPolicy,
                /*fieldName*/ "UseBaseLayerInclusionPolicy",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseCalleeSavedRegisters": {
            return OptionDescriptor.create(
                /*name*/ "UseCalleeSavedRegisters",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Use callee saved registers to reduce spilling for low-frequency calls to stubs (if callee saved registers are supported by the architecture)",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseCalleeSavedRegisters,
                /*fieldName*/ "UseCalleeSavedRegisters",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseContainerSupport": {
            return OptionDescriptor.create(
                /*name*/ "UseContainerSupport",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable detection and runtime container configuration support.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseContainerSupport,
                /*fieldName*/ "UseContainerSupport",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseDirectCallTrampolinesALot": {
            return OptionDescriptor.create(
                /*name*/ "UseDirectCallTrampolinesALot",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Force many trampolines to be needed for inter-method calls. Normally trampolines are only used when a method destination is outside the range of a pc-relative branch instruction.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseDirectCallTrampolinesALot,
                /*fieldName*/ "UseDirectCallTrampolinesALot",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseImagebuildDebugSections": {
            return OptionDescriptor.create(
                /*name*/ "UseImagebuildDebugSections",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Emit debuginfo debug.svm.imagebuild.* sections with detailed image-build options.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseImagebuildDebugSections,
                /*fieldName*/ "UseImagebuildDebugSections",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseLibC": {
            return OptionDescriptor.create(
                /*name*/ "UseLibC",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Selects the libc implementation to use. Available implementations: glibc, musl, bionic",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseLibC,
                /*fieldName*/ "UseLibC",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseNullRegion": {
            return OptionDescriptor.create(
                /*name*/ "UseNullRegion",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a null region is present between the heap base and the image heap.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseNullRegion,
                /*fieldName*/ "UseNullRegion",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseOldMethodHandleIntrinsics": {
            return OptionDescriptor.create(
                /*name*/ "UseOldMethodHandleIntrinsics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseOldMethodHandleIntrinsics,
                /*fieldName*/ "UseOldMethodHandleIntrinsics",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        case "UseSharedLayerGraphs": {
            return OptionDescriptor.create(
                /*name*/ "UseSharedLayerGraphs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Persist and reload all graphs across layers. If false, graphs defined in the base layer can be reparsed by the current layer and inlined before analysis, but will not be inlined after analysis has completed via our other inlining infrastructure",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseSharedLayerGraphs,
                /*fieldName*/ "UseSharedLayerGraphs",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSharedLayerStrengthenedGraphs": {
            return OptionDescriptor.create(
                /*name*/ "UseSharedLayerStrengthenedGraphs",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Persist and reload strengthened graphs across layers. If false, inlining after analysis will be disabled",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseSharedLayerStrengthenedGraphs,
                /*fieldName*/ "UseSharedLayerStrengthenedGraphs",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "UseSystemLocale": {
            return OptionDescriptor.create(
                /*name*/ "UseSystemLocale",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if the system locale should be used at run-time. If this is disabled, the locale 'en-US' will be used instead.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.UseSystemLocale,
                /*fieldName*/ "UseSystemLocale",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VectorAPISupport": {
            return OptionDescriptor.create(
                /*name*/ "VectorAPISupport",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Support for intrinsics from the Java Vector API",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.VectorAPISupport,
                /*fieldName*/ "VectorAPISupport",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyFrameAccess": {
            return OptionDescriptor.create(
                /*name*/ "VerifyFrameAccess",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if frame accesses are verified at run-time.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.VerifyFrameAccess,
                /*fieldName*/ "VerifyFrameAccess",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyFrameAnchors": {
            return OptionDescriptor.create(
                /*name*/ "VerifyFrameAnchors",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if frame anchors are verified at run-time.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.VerifyFrameAnchors,
                /*fieldName*/ "VerifyFrameAnchors",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyNamingConventions": {
            return OptionDescriptor.create(
                /*name*/ "VerifyNamingConventions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify naming conventions during image construction.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.VerifyNamingConventions,
                /*fieldName*/ "VerifyNamingConventions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "VerifyTypes": {
            return OptionDescriptor.create(
                /*name*/ "VerifyTypes",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Verify type states computed by the static analysis at run time. This is useful when diagnosing problems in the static analysis, but reduces peak performance significantly.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.VerifyTypes,
                /*fieldName*/ "VerifyTypes",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapNativeMemory": {
            return OptionDescriptor.create(
                /*name*/ "ZapNativeMemory",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fill unused and freed native memory with sentinel values. Needs NMT.",
                /*container*/ getContainer(),
                /*option*/ SubstrateOptions.ZapNativeMemory,
                /*fieldName*/ "ZapNativeMemory",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 168;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AOTInline");
                    case 1: return get("AOTTrivialInline");
                    case 2: return get("APIFunctionPrefix");
                    case 3: return get("AbortOnNameConflict");
                    case 4: return get("ActiveProcessorCount");
                    case 5: return get("AdditionalHeaderBytes");
                    case 6: return get("AllocateInstancePrefetchLines");
                    case 7: return get("AllocatePrefetchDistance");
                    case 8: return get("AllocatePrefetchInstr");
                    case 9: return get("AllocatePrefetchLines");
                    case 10: return get("AllocatePrefetchStepSize");
                    case 11: return get("AllowDeprecatedBuilderClassesOnImageClasspath");
                    case 12: return get("AllowUnsafeAllocationOfAllInstantiatedTypes");
                    case 13: return get("AllowVMInternalThreads");
                    case 14: return get("ApplicationLayerInitializedClasses");
                    case 15: return get("ApplicationLayerOnlySingletons");
                    case 16: return get("AsyncSignalSafeDiagnostics");
                    case 17: return get("BuildOutputBreakdowns");
                    case 18: return get("BuildOutputColorful");
                    case 19: return get("BuildOutputGCWarnings");
                    case 20: return get("BuildOutputJSONFile");
                    case 21: return get("BuildOutputLinks");
                    case 22: return get("BuildOutputPrefix");
                    case 23: return get("BuildOutputProgress");
                    case 24: return get("BuildOutputRecommendations");
                    case 25: return get("BuildOutputSilent");
                    case 26: return get("CCompilerOption");
                    case 27: return get("CCompilerPath");
                    case 28: return get("CLibraryPath");
                    case 29: return get("CheckBootModuleDependencies");
                    case 30: return get("CheckIsolateThreadAtEntry");
                    case 31: return get("CheckToolchain");
                    case 32: return get("Class");
                    case 33: return get("ClosedTypeWorld");
                    case 34: return get("ClosedTypeWorldHubLayout");
                    case 35: return get("Color");
                    case 36: return get("CompilationIsolateAddressSpaceSize");
                    case 37: return get("CompilationIsolateOptions");
                    case 38: return get("CompilerBackend");
                    case 39: return get("ConfigureReflectionMetadata");
                    case 40: return get("ContendedPaddingWidth");
                    case 41: return get("DeadlockWatchdogExitOnTimeout");
                    case 42: return get("DeadlockWatchdogInterval");
                    case 43: return get("DebugCodeInfoMaxDepth");
                    case 44: return get("DebugCodeInfoUseSourceMappings");
                    case 45: return get("DebugInfoSourceCacheRoot");
                    case 46: return get("DeleteLocalSymbols");
                    case 47: return get("DetectUserDirectoriesInImageHeap");
                    case 48: return get("DiagnosticBufferSize");
                    case 49: return get("DiagnosticDetails");
                    case 50: return get("DisableSubstitution");
                    case 51: return get("DisableTypeIdResultVerification");
                    case 52: return get("DisableURLProtocols");
                    case 53: return get("DumpHeapAndExit");
                    case 54: return get("DumpTargetInfo");
                    case 55: return get("EnableAllSecurityServices");
                    case 56: return get("EnableSignalHandling");
                    case 57: return get("EnableURLProtocols");
                    case 58: return get("EnableWildcardExpansion");
                    case 59: return get("EntryPointNamePrefix");
                    case 60: return get("FallbackThreshold");
                    case 61: return get("FlightRecorder");
                    case 62: return get("FlightRecorderLogging");
                    case 63: return get("FlightRecorderOptions");
                    case 64: return get("FoldSecurityManagerGetter");
                    case 65: return get("ForeignAPISupport");
                    case 66: return get("GenerateBuildArtifactsFile");
                    case 67: return get("GenerateDebugInfo");
                    case 68: return get("HeapDumpDefaultFilenamePrefix");
                    case 69: return get("HeapDumpOnOutOfMemoryError");
                    case 70: return get("HeapDumpPath");
                    case 71: return get("IgnorePreserveForClasses");
                    case 72: return get("ImageBuildID");
                    case 73: return get("ImageSymbolsPrefix");
                    case 74: return get("IncludeDebugHelperMethods");
                    case 75: return get("IncludeMethodData");
                    case 76: return get("IncludeNodeSourcePositions");
                    case 77: return get("InstallExitHandlers");
                    case 78: return get("InternalSymbolsAreGlobal");
                    case 79: return get("InternalThreadStackSize");
                    case 80: return get("JNI");
                    case 81: return get("JNIEnhancedErrorCodes");
                    case 82: return get("JNIExportSymbols");
                    case 83: return get("JNIVerboseLookupErrors");
                    case 84: return get("JVMTI");
                    case 85: return get("JVMTIAgentLib");
                    case 86: return get("JVMTIAgentPath");
                    case 87: return get("LayerCreate");
                    case 88: return get("LayerOptionVerification");
                    case 89: return get("LayerOptionVerificationVerbose");
                    case 90: return get("LayerUse");
                    case 91: return get("LibGraalClassLoader");
                    case 92: return get("LinkerRPath");
                    case 93: return get("LoggingHashCodeInjection");
                    case 94: return get("MaxDirectMemorySize");
                    case 95: return get("MaxInvokesInTrivialMethod");
                    case 96: return get("MaxNodesAfterTrivialInlining");
                    case 97: return get("MaxNodesInTrivialLeafMethod");
                    case 98: return get("MaxNodesInTrivialMethod");
                    case 99: return get("MaxUnrolledObjectZeroingStores");
                    case 100: return get("Method");
                    case 101: return get("MissingRegistrationReportingMode");
                    case 102: return get("MissingRegistrationWarnContextLines");
                    case 103: return get("Module");
                    case 104: return get("MremapImageHeap");
                    case 105: return get("MultiThreaded");
                    case 106: return get("Name");
                    case 107: return get("NeverInline");
                    case 108: return get("NoDirectRelocationsInText");
                    case 109: return get("OmitInlinedMethodDebugLineInfo");
                    case 110: return get("Optimize");
                    case 111: return get("ParseOnce");
                    case 112: return get("ParseOnceJIT");
                    case 113: return get("ParseRuntimeOptions");
                    case 114: return get("PinnedObjectAddressing");
                    case 115: return get("Preserve");
                    case 116: return get("PreserveFramePointer");
                    case 117: return get("PrintClosedArenaUponThrow");
                    case 118: return get("PrintVMInfoAndExit");
                    case 119: return get("ReduceImplicitExceptionStackTraceInformation");
                    case 120: return get("RelativeCodePointers");
                    case 121: return get("RemoveUnusedSymbols");
                    case 122: return get("ReportAnalysisForbiddenType");
                    case 123: return get("RunMainInNewThread");
                    case 124: return get("SharedArenaSupport");
                    case 125: return get("SharedLibrary");
                    case 126: return get("SourceLevelDebug");
                    case 127: return get("SourceLevelDebugFilter");
                    case 128: return get("SpawnIsolates");
                    case 129: return get("StackSize");
                    case 130: return get("StackTrace");
                    case 131: return get("StartFlightRecording");
                    case 132: return get("StaticExecutable");
                    case 133: return get("StaticExecutableWithDynamicLibC");
                    case 134: return get("StaticLibStdCpp");
                    case 135: return get("StrictQueryCodeCompilation");
                    case 136: return get("StripDebugInfo");
                    case 137: return get("SupportedGCs");
                    case 138: return get("TargetPlatform");
                    case 139: return get("TearDownWarningSeconds");
                    case 140: return get("ThrowLinkAtBuildTimeIOExceptions");
                    case 141: return get("ThrowMissingRegistrationErrors");
                    case 142: return get("ThrowMissingRegistrationErrorsPaths");
                    case 143: return get("TraceClassInitialization");
                    case 144: return get("TraceNativeToolUsage");
                    case 145: return get("TraceObjectInstantiation");
                    case 146: return get("TraceVMOperations");
                    case 147: return get("TrackDynamicAccess");
                    case 148: return get("TrackJavaHomeAccess");
                    case 149: return get("TrackJavaHomeAccessDetailed");
                    case 150: return get("UnlockExperimentalVMOptions");
                    case 151: return get("UseBaseLayerInclusionPolicy");
                    case 152: return get("UseCalleeSavedRegisters");
                    case 153: return get("UseContainerSupport");
                    case 154: return get("UseDirectCallTrampolinesALot");
                    case 155: return get("UseImagebuildDebugSections");
                    case 156: return get("UseLibC");
                    case 157: return get("UseNullRegion");
                    case 158: return get("UseOldMethodHandleIntrinsics");
                    case 159: return get("UseSharedLayerGraphs");
                    case 160: return get("UseSharedLayerStrengthenedGraphs");
                    case 161: return get("UseSystemLocale");
                    case 162: return get("VectorAPISupport");
                    case 163: return get("VerifyFrameAccess");
                    case 164: return get("VerifyFrameAnchors");
                    case 165: return get("VerifyNamingConventions");
                    case 166: return get("VerifyTypes");
                    case 167: return get("ZapNativeMemory");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
