/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.GlobalFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.common.JVMCIError;

public class ArrayElementsTypeFlow
extends TypeFlow<AnalysisType>
implements GlobalFlow {
    private final AnalysisObject object;

    public ArrayElementsTypeFlow(AnalysisObject sourceObject) {
        super(sourceObject.type(), sourceObject.type().getComponentType());
        this.object = sourceObject;
    }

    @Override
    public TypeFlow<AnalysisType> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        throw JVMCIError.shouldNotReachHere((String)"The mixed elements flow should not be cloned. Use Load/StoreFlows.");
    }

    @Override
    public boolean canSaturate(PointsToAnalysis bb) {
        return !bb.isClosed(this.declaredType);
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        if (bb.isClosed(this.declaredType)) {
            this.declaredType.getTypeFlow(bb, true).addUse(bb, this);
        } else {
            super.onInputSaturated(bb, input);
        }
    }

    @Override
    protected TypeState processInputState(PointsToAnalysis bb, TypeState update) {
        if (this.declaredType.equals(bb.getObjectType())) {
            return update;
        }
        return TypeState.forIntersection(bb, update, this.declaredType.getAssignableTypes(true));
    }

    public AnalysisObject object() {
        return this.object;
    }

    @Override
    public String toString() {
        return "MixedElementsFlow<" + ((AnalysisType)this.source).getName() + "\n" + this.getStateDescription() + ">";
    }
}

