/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.BaseLayerElement;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;

public class BaseLayerMethod
extends BaseLayerElement
implements ResolvedJavaMethod {
    private final int id;
    private final ResolvedJavaType declaringClass;
    private final String name;
    private final boolean isVarArgs;
    private final boolean isBridge;
    private final ResolvedSignature<AnalysisType> signature;
    private final boolean canBeStaticallyBound;
    private final boolean isConstructor;
    private final int modifiers;
    private final boolean isSynthetic;
    private final byte[] code;
    private final int codeSize;
    private final MethodHandleAccessProvider.IntrinsicMethod methodHandleIntrinsic;

    public BaseLayerMethod(int id, AnalysisType declaringClass, String name, boolean isVarArgs, boolean isBridge, ResolvedSignature<AnalysisType> signature, boolean canBeStaticallyBound, boolean isConstructor, int modifiers, boolean isSynthetic, byte[] code, int codeSize, MethodHandleAccessProvider.IntrinsicMethod methodHandleIntrinsic, Annotation[] annotations) {
        super(annotations);
        this.id = id;
        this.declaringClass = declaringClass.getWrapped();
        this.name = name;
        this.isVarArgs = isVarArgs;
        this.isBridge = isBridge;
        this.signature = signature;
        this.canBeStaticallyBound = canBeStaticallyBound;
        this.isConstructor = isConstructor;
        this.modifiers = modifiers;
        this.isSynthetic = isSynthetic;
        this.code = code;
        this.codeSize = codeSize;
        this.methodHandleIntrinsic = methodHandleIntrinsic;
    }

    public int getBaseLayerId() {
        return this.id;
    }

    public MethodHandleAccessProvider.IntrinsicMethod getMethodHandleIntrinsic() {
        return this.methodHandleIntrinsic;
    }

    public byte[] getCode() {
        return this.code;
    }

    public int getCodeSize() {
        return this.codeSize;
    }

    public String getName() {
        return this.name;
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.declaringClass;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public int getMaxLocals() {
        throw this.unimplemented();
    }

    public int getMaxStackSize() {
        throw this.unimplemented();
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isBridge() {
        return this.isBridge;
    }

    public boolean isDefault() {
        throw this.unimplemented();
    }

    public boolean isDeclared() {
        throw this.unimplemented();
    }

    public boolean isClassInitializer() {
        throw this.unimplemented();
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean canBeStaticallyBound() {
        return this.canBeStaticallyBound;
    }

    public ExceptionHandler[] getExceptionHandlers() {
        return new ExceptionHandler[0];
    }

    public StackTraceElement asStackTraceElement(int bci) {
        return new StackTraceElement(this.declaringClass.toClassName(), this.name, this.declaringClass.getSourceFileName(), -1);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        throw this.unimplemented();
    }

    public void reprofile() {
        throw this.unimplemented();
    }

    public ConstantPool getConstantPool() {
        throw this.unimplemented();
    }

    public Annotation[][] getParameterAnnotations() {
        throw this.unimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw this.unimplemented();
    }

    public boolean canBeInlined() {
        throw this.unimplemented();
    }

    public boolean hasNeverInlineDirective() {
        throw this.unimplemented();
    }

    public boolean shouldBeInlined() {
        throw this.unimplemented();
    }

    public LineNumberTable getLineNumberTable() {
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw this.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw this.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw this.unimplemented();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw this.unimplemented();
    }

    public Annotation[] getAnnotations() {
        throw this.unimplemented();
    }

    public Annotation[] getDeclaredAnnotations() {
        throw this.unimplemented();
    }

    private RuntimeException unimplemented() {
        return GraalError.unimplemented((String)("This method is incomplete and should not be used. Base layer method: " + this.format("%H.%n(%p)")));
    }

    public int getModifiers() {
        return this.modifiers;
    }
}

