/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.BaseLayerElement;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.annotation.Annotation;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class BaseLayerType
extends BaseLayerElement
implements ResolvedJavaType,
OriginalClassProvider {
    public static final String BASE_LAYER_SUFFIX = "_BaseLayer;";
    private final String name;
    private final int baseLayerId;
    private final int modifiers;
    private final boolean isInterface;
    private final boolean isEnum;
    private final boolean isInitialized;
    private final boolean isLinked;
    private final String sourceFileName;
    private final ResolvedJavaType enclosingType;
    private final ResolvedJavaType componentType;
    private final ResolvedJavaType superClass;
    private final ResolvedJavaType[] interfaces;
    private final ResolvedJavaType objectType;
    private ResolvedJavaField[] instanceFields;
    private ResolvedJavaField[] instanceFieldsWithSuper;

    public BaseLayerType(String name, int baseLayerId, int modifiers, boolean isInterface, boolean isEnum, boolean isInitialized, boolean isLinked, String sourceFileName, ResolvedJavaType enclosingType, ResolvedJavaType componentType, ResolvedJavaType superClass, ResolvedJavaType[] interfaces, ResolvedJavaType objectType, Annotation[] annotations) {
        super(annotations);
        this.name = name.substring(0, name.length() - 1) + BASE_LAYER_SUFFIX;
        this.baseLayerId = baseLayerId;
        this.modifiers = modifiers;
        this.isInterface = isInterface;
        this.isEnum = isEnum;
        this.isInitialized = isInitialized;
        this.isLinked = isLinked;
        this.sourceFileName = sourceFileName;
        this.enclosingType = enclosingType;
        this.componentType = componentType;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.objectType = objectType;
    }

    public void setInstanceFields(ResolvedJavaField[] instanceFields) {
        this.instanceFields = instanceFields;
    }

    public void setInstanceFieldsWithSuper(ResolvedJavaField[] instanceFieldsWithSuper) {
        this.instanceFieldsWithSuper = instanceFieldsWithSuper;
    }

    public boolean isArray() {
        return this.name.charAt(0) == '[';
    }

    public boolean hasFinalizer() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isInstanceClass() {
        return !this.isArray() && !this.isInterface();
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public boolean hasDefaultMethods() {
        return false;
    }

    public boolean declaresDefaultMethods() {
        return false;
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        return other.equals((Object)this.objectType) || other.equals((Object)this);
    }

    public boolean isInstance(JavaConstant obj) {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaType getSuperclass() {
        return this.superClass;
    }

    public ResolvedJavaType[] getInterfaces() {
        return this.interfaces;
    }

    public ResolvedJavaType getSingleImplementor() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        if (otherType.equals((Object)this)) {
            return this;
        }
        return this.objectType;
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public String getName() {
        return this.name;
    }

    public ResolvedJavaType getComponentType() {
        return this.componentType;
    }

    public ResolvedJavaType getArrayClass() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return null;
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaMethod[] getDeclaredMethods(boolean forceLink) {
        return new ResolvedJavaMethod[0];
    }

    public List<ResolvedJavaMethod> getAllMethods(boolean forceLink) {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        return includeSuperclasses ? this.instanceFieldsWithSuper : this.instanceFields;
    }

    public ResolvedJavaField[] getStaticFields() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public String getSourceFileName() {
        return this.sourceFileName;
    }

    public boolean isLocal() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public boolean isMember() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaType getEnclosingType() {
        return this.enclosingType;
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public ResolvedJavaMethod getClassInitializer() {
        return null;
    }

    public boolean isCloneableWithAllocation() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public Annotation[] getAnnotations() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    public Annotation[] getDeclaredAnnotations() {
        throw AnalysisError.shouldNotReachHere("This type is incomplete and should not be used.");
    }

    @Override
    public ResolvedJavaType unwrapTowardsOriginalType() {
        return this.objectType;
    }

    public int getBaseLayerId() {
        return this.baseLayerId;
    }
}

