/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import java.util.function.BooleanSupplier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class BuildPhaseProvider {
    private boolean featureRegistrationFinished;
    private boolean setupFinished;
    private boolean analysisStarted;
    private boolean analysisFinished;
    private boolean hostedUniverseBuilt;
    private boolean readyForCompilation;
    private boolean compileQueueFinished;
    private boolean compilationFinished;
    private boolean heapLayoutFinished;

    public static void init() {
        ImageSingletons.add(BuildPhaseProvider.class, (Object)new BuildPhaseProvider());
    }

    static BuildPhaseProvider singleton() {
        return (BuildPhaseProvider)ImageSingletons.lookup(BuildPhaseProvider.class);
    }

    BuildPhaseProvider() {
    }

    public static void markFeatureRegistrationFinished() {
        BuildPhaseProvider.singleton().featureRegistrationFinished = true;
    }

    public static boolean isFeatureRegistrationFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().featureRegistrationFinished;
    }

    public static void markSetupFinished() {
        BuildPhaseProvider.singleton().setupFinished = true;
    }

    public static boolean isSetupFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().setupFinished;
    }

    public static void markAnalysisStarted() {
        BuildPhaseProvider.singleton().analysisStarted = true;
    }

    public static boolean isAnalysisStarted() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().analysisStarted;
    }

    public static void markAnalysisFinished() {
        BuildPhaseProvider.singleton().analysisFinished = true;
    }

    public static boolean isAnalysisFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().analysisFinished;
    }

    public static void markHostedUniverseBuilt() {
        BuildPhaseProvider.singleton().hostedUniverseBuilt = true;
    }

    public static boolean isHostedUniverseBuilt() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().hostedUniverseBuilt;
    }

    public static void markReadyForCompilation() {
        BuildPhaseProvider.singleton().readyForCompilation = true;
    }

    public static boolean isReadyForCompilation() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().readyForCompilation;
    }

    public static void markCompileQueueFinished() {
        BuildPhaseProvider.singleton().compileQueueFinished = true;
    }

    public static boolean isCompileQueueFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().compileQueueFinished;
    }

    public static void markCompilationFinished() {
        BuildPhaseProvider.singleton().compilationFinished = true;
    }

    public static boolean isCompilationFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().compilationFinished;
    }

    public static void markHeapLayoutFinished() {
        BuildPhaseProvider.singleton().heapLayoutFinished = true;
    }

    public static boolean isHeapLayoutFinished() {
        return ImageSingletons.contains(BuildPhaseProvider.class) && BuildPhaseProvider.singleton().heapLayoutFinished;
    }

    public static class AfterHeapLayout
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isHeapLayoutFinished();
        }
    }

    public static class AfterCompilation
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isCompilationFinished();
        }
    }

    public static class CompileQueueFinished
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isCompileQueueFinished();
        }
    }

    public static class ReadyForCompilation
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isReadyForCompilation();
        }
    }

    public static class AfterHostedUniverse
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isHostedUniverseBuilt();
        }
    }

    public static class AfterAnalysis
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return BuildPhaseProvider.isAnalysisFinished();
        }
    }
}

