/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.heap.HeapSizeVerifier;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.NotifyGCRuntimeOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.word.Word;
import org.graalvm.collections.EconomicMap;

public class SubstrateGCOptions {
    private static final int K = 1024;
    public static final RuntimeOptionKey<Long> MinHeapSize = new NotifyGCRuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser}){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                HeapSizeVerifier.verifyMinHeapSizeAgainstMaxAddressSpaceSize(Word.unsigned((long)newValue));
            }
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final RuntimeOptionKey<Long> MaxHeapSize = new NotifyGCRuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser}){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                HeapSizeVerifier.verifyMaxHeapSizeAgainstMaxAddressSpaceSize(Word.unsigned((long)newValue));
            }
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final RuntimeOptionKey<Long> MaxNewSize = new NotifyGCRuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser}){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Long oldValue, Long newValue) {
            if (!SubstrateUtil.HOSTED) {
                HeapSizeVerifier.verifyMaxNewSizeAgainstMaxAddressSpaceSize(Word.unsigned((long)newValue));
            }
            super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
        }
    };
    public static final RuntimeOptionKey<Long> ReservedAddressSpaceSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    public static final RuntimeOptionKey<Boolean> ExitOnOutOfMemoryError = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
    public static final RuntimeOptionKey<Boolean> ReportFatalErrorOnOutOfMemoryError = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> DisableExplicitGC = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
    public static final RuntimeOptionKey<Boolean> PrintGC = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final RuntimeOptionKey<Boolean> VerboseGC = new NotifyGCRuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    public static final HostedOptionKey<Boolean> VerifyHeap = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> TreatRuntimeCodeInfoReferencesAsWeak = new HostedOptionKey<Boolean>(true);

    public static class TlabOptions {
        public static final HostedOptionKey<Boolean> UseTLAB = new HostedOptionKey<Boolean>(true);
        public static final RuntimeOptionKey<Boolean> ResizeTLAB = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.IsolateCreationOnly);
        public static final RuntimeOptionKey<Long> MinTLABSize = new RuntimeOptionKey<Long>(Long.valueOf(2048L), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
        public static final RuntimeOptionKey<Long> TLABSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
    }
}

