/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateDiagnostics;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.c.libc.MuslLibC;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.RuntimeCompilation;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.jdk.VectorAPIEnabled;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.APIOptionGroup;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.GCOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.LayerVerifiedOption;
import com.oracle.svm.core.option.OptionMigrationMessage;
import com.oracle.svm.core.option.ReplacingLocatableMultiOptionValue;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.pltgot.PLTGOTConfiguration;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ModuleSupport;
import com.oracle.svm.util.ReflectionUtil;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.common.SpectrePHTMitigations;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.amd64.AMD64;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class SubstrateOptions {
    static final HostedOptionKey<Boolean> ParseOnce = new HostedOptionKey<Boolean>(true);
    static final HostedOptionKey<Boolean> ParseOnceJIT = new HostedOptionKey<Boolean>(true);
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> SourceLevelDebug = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> SourceLevelDebugFilter = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
    public static final HostedOptionKey<String> ImageBuildID = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Module = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Class = new HostedOptionKey<String>("");
    public static final HostedOptionKey<String> Method = new HostedOptionKey<String>("main");
    @APIOption(name={"-o"}, valueSeparator={32})
    public static final HostedOptionKey<String> Name = new HostedOptionKey<String>("");
    @APIOption(name={"shared"})
    public static final HostedOptionKey<Boolean> SharedLibrary = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> UseSharedLayerGraphs = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (!newValue.booleanValue()) {
                UseSharedLayerStrengthenedGraphs.update(values, false);
            }
        }
    };
    public static final HostedOptionKey<Boolean> UseSharedLayerStrengthenedGraphs = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
            if (newValue.booleanValue()) {
                UserError.guarantee((Boolean)UseSharedLayerStrengthenedGraphs.getValueOrDefault((UnmodifiableEconomicMap)values), "UseSharedLayerStrengthenedGraph is a subset of UseSharedLayerGraphs, so the former cannot be enabled alone.", new Object[0]);
            } else {
                NeverInline.update(values, "SubstrateStringConcatHelper.simpleConcat");
            }
        }
    };
    @APIOption(name={"static"})
    public static final HostedOptionKey<Boolean> StaticExecutable = new HostedOptionKey<Boolean>(false, key -> {
        if (!((Boolean)key.getValue()).booleanValue()) {
            return;
        }
        if (!Platform.includedIn(Platform.LINUX.class)) {
            throw UserError.invalidOptionValue(key, (Boolean)key.getValue(), "Building static executable images is currently only supported on Linux. Remove the '--static' option or build on a Linux machine");
        }
        if (!LibCBase.targetLibCIs(MuslLibC.class)) {
            throw UserError.invalidOptionValue(key, (Boolean)key.getValue(), "Building static executable images is only supported with musl libc. Remove the '--static' option or add the '--libc=musl' option.");
        }
    });
    public static final String LAYER_OPTION_PREFIX = "-H:Layer";
    public static final String LAYER_CREATE_OPTION = "-H:LayerCreate";
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> LayerCreate = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
    @BundleMember(role=BundleMember.Role.Input)
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> LayerUse = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.build());
    public static final HostedOptionKey<Boolean> LayerOptionVerification = new HostedOptionKey<Boolean>(true);
    public static final HostedOptionKey<Boolean> LayerOptionVerificationVerbose = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ApplicationLayerOnlySingletons = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ApplicationLayerInitializedClasses = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
    @APIOption(name={"libc"})
    public static final HostedOptionKey<String> UseLibC = new HostedOptionKey<String>(null){

        public String getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
            if (!values.containsKey((Object)this)) {
                return Platform.includedIn(Platform.ANDROID.class) ? "bionic" : System.getProperty("substratevm.HostLibC", "glibc");
            }
            return (String)values.get((Object)this);
        }

        public String getValue(OptionValues values) {
            return this.getValueOrDefault(values.getMap());
        }
    };
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    @APIOption(name={"target"})
    public static final HostedOptionKey<String> TargetPlatform = new HostedOptionKey<String>(""){

        protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
            String updatedNewValue = newValue.equals("macos") ? "darwin" : newValue;
            super.onValueUpdate(values, (Object)oldValue, (Object)updatedNewValue);
        }
    };
    @APIOption(name={"static-nolibc"})
    public static final HostedOptionKey<Boolean> StaticExecutableWithDynamicLibC = new HostedOptionKey<Boolean>(false);
    public static final HostedOptionKey<Boolean> StaticLibStdCpp = new HostedOptionKey<Boolean>(false);
    public static final int ForceFallback = 10;
    public static final int Automatic = 5;
    public static final int NoFallback = 0;
    public static final String OptionNameForceFallback = "force-fallback";
    public static final String OptionNameAutoFallback = "auto-fallback";
    public static final String OptionNameNoFallback = "no-fallback";
    @APIOption.List(value={@APIOption(name={"force-fallback"}, fixedValue={"10"}, customHelp="force building of fallback image"), @APIOption(name={"auto-fallback"}, fixedValue={"5"}, customHelp="build stand-alone image if possible"), @APIOption(name={"no-fallback"}, fixedValue={"0"}, customHelp="build stand-alone image or report failure")})
    public static final HostedOptionKey<Integer> FallbackThreshold = new HostedOptionKey<Integer>(5);
    public static final String IMAGE_CLASSPATH_PREFIX = "-imagecp";
    public static final String IMAGE_MODULEPATH_PREFIX = "-imagemp";
    public static final String KEEP_ALIVE_PREFIX = "-keepalive";
    private static ValueUpdateHandler<OptimizationLevel> optimizeValueUpdateHandler;
    public static OptionEnabledHandler<Boolean> imageLayerEnabledHandler;
    public static OptionEnabledHandler<Boolean> imageLayerCreateEnabledHandler;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    @APIOption(name={"-O"}, valueSeparator={0})
    public static final HostedOptionKey<String> Optimize;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> IncludeNodeSourcePositions;
    @BundleMember(role=BundleMember.Role.Input)
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> CLibraryPath;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> LinkerRPath;
    public static final HostedOptionKey<ReplacingLocatableMultiOptionValue.DelimitedString> SupportedGCs;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> UseContainerSupport;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final RuntimeOptionKey<Long> StackSize;
    public static final HostedOptionKey<Long> InternalThreadStackSize;
    private static int maxJavaStackTraceDepth;
    public static final RuntimeOptionKey<Long> MaxDirectMemorySize;
    public static final HostedOptionKey<Boolean> VerifyNamingConventions;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> DisableSubstitution;
    public static final HostedOptionKey<Boolean> MultiThreaded;
    public static final HostedOptionKey<Boolean> NoDirectRelocationsInText;
    public static final HostedOptionKey<Boolean> SpawnIsolates;
    public static final HostedOptionKey<Boolean> CheckIsolateThreadAtEntry;
    public static final HostedOptionKey<Boolean> TraceVMOperations;
    private static final String DEPRECATION_MESSAGE_TCI = "This option is not required anymore with the strict image heap enabled by default.";
    @APIOption(name={"trace-class-initialization"}, deprecated="This option is not required anymore with the strict image heap enabled by default.")
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> TraceClassInitialization;
    @APIOption(name={"trace-object-instantiation"})
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> TraceObjectInstantiation;
    public static final HostedOptionKey<Boolean> TraceNativeToolUsage;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<String> EntryPointNamePrefix;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<String> APIFunctionPrefix;
    @APIOption.List(value={@APIOption(name={"enable-http"}, fixedValue={"http"}, customHelp="enable http support in the generated image"), @APIOption(name={"enable-https"}, fixedValue={"https"}, customHelp="enable https support in the generated image"), @APIOption(name={"enable-url-protocols"})})
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> EnableURLProtocols;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> DisableURLProtocols;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    @APIOption(name={"enable-all-security-services"})
    public static final HostedOptionKey<Boolean> EnableAllSecurityServices;
    public static final HostedOptionKey<Boolean> JNI;
    public static final HostedOptionKey<Boolean> JNIVerboseLookupErrors;
    public static final HostedOptionKey<Boolean> JNIExportSymbols;
    public static final HostedOptionKey<Boolean> JNIEnhancedErrorCodes;
    public static final HostedOptionKey<Boolean> JVMTI;
    public static final RuntimeOptionKey<String> JVMTIAgentLib;
    public static final RuntimeOptionKey<String> JVMTIAgentPath;
    public static final String BUILD_ARTIFACTS_FILE_NAME = "build-artifacts.json";
    public static final HostedOptionKey<Boolean> GenerateBuildArtifactsFile;
    @APIOption(name={"color"})
    public static final HostedOptionKey<String> Color;
    @APIOption(name={"silent"})
    public static final HostedOptionKey<Boolean> BuildOutputSilent;
    public static final HostedOptionKey<Boolean> BuildOutputPrefix;
    public static final HostedOptionKey<Boolean> BuildOutputColorful;
    public static final HostedOptionKey<Boolean> BuildOutputLinks;
    public static final HostedOptionKey<Boolean> BuildOutputProgress;
    public static final HostedOptionKey<Boolean> BuildOutputBreakdowns;
    public static final HostedOptionKey<Boolean> BuildOutputRecommendations;
    public static final HostedOptionKey<Boolean> BuildOutputGCWarnings;
    @BundleMember(role=BundleMember.Role.Output)
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> BuildOutputJSONFile;
    public static final String NATIVE_IMAGE_OPTIONS_ENV_VAR = "NATIVE_IMAGE_OPTIONS";
    public static final String BUILD_MEMORY_USAGE_REASON_TEXT_PROPERTY = "svm.build.memoryUsageReasonText";
    public static final HostedOptionKey<Integer> AllocatePrefetchLines;
    public static final HostedOptionKey<Integer> AllocateInstancePrefetchLines;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Integer> AllocatePrefetchInstr;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Integer> AllocatePrefetchDistance;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Integer> AllocatePrefetchStepSize;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Integer> ContendedPaddingWidth;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Integer> AdditionalHeaderBytes;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> ZapNativeMemory;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final RuntimeOptionKey<Long> TearDownWarningSeconds;
    public static final HostedOptionKey<Integer> MaxUnrolledObjectZeroingStores;
    static final HostedOptionKey<Boolean> StackTrace;
    public static final HostedOptionKey<Boolean> ParseRuntimeOptions;
    public static final HostedOptionKey<Boolean> EnableWildcardExpansion;
    static final HostedOptionKey<Boolean> AOTInline;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> AOTTrivialInline;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Removed, severity=LayerVerifiedOption.Severity.Error, positional=false)
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> NeverInline;
    public static final HostedOptionKey<Integer> MaxNodesInTrivialMethod;
    public static final HostedOptionKey<Integer> MaxInvokesInTrivialMethod;
    public static final HostedOptionKey<Integer> MaxNodesInTrivialLeafMethod;
    public static final HostedOptionKey<Integer> MaxNodesAfterTrivialInlining;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> PreserveFramePointer;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> UseCalleeSavedRegisters;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ReportAnalysisForbiddenType;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<String> CompilerBackend;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> RemoveUnusedSymbols;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> DeleteLocalSymbols;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> InternalSymbolsAreGlobal;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<String> ImageSymbolsPrefix;
    public static final HostedOptionKey<Boolean> FoldSecurityManagerGetter;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    @APIOption(name={"native-compiler-path"})
    public static final HostedOptionKey<String> CCompilerPath;
    @APIOption(name={"native-compiler-options"})
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> CCompilerOption;
    public static final HostedOptionKey<Boolean> StrictQueryCodeCompilation;
    @APIOption(name={"native-image-info"})
    public static final HostedOptionKey<Boolean> DumpTargetInfo;
    public static final HostedOptionKey<Boolean> CheckToolchain;
    public static final HostedOptionKey<Boolean> DetectUserDirectoriesInImageHeap;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> UseNullRegion;
    public static final HostedOptionKey<Integer> DeadlockWatchdogInterval;
    public static final HostedOptionKey<Boolean> DeadlockWatchdogExitOnTimeout;
    public static final HostedOptionKey<Boolean> AllowVMInternalThreads;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> IncludeDebugHelperMethods;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    @APIOption(name={"-g"}, fixedValue={"2"}, customHelp="generate debugging information")
    public static final HostedOptionKey<Integer> GenerateDebugInfo;
    static final HostedOptionKey<String> DebugInfoSourceCacheRoot;
    public static final HostedOptionKey<Integer> CheckBootModuleDependencies;
    public static final HostedOptionKey<Boolean> StripDebugInfo;
    public static final HostedOptionKey<Boolean> OmitInlinedMethodDebugLineInfo;
    public static final HostedOptionKey<Integer> DebugCodeInfoMaxDepth;
    public static final HostedOptionKey<Boolean> DebugCodeInfoUseSourceMappings;
    public static final HostedOptionKey<Boolean> UseImagebuildDebugSections;
    @APIOption(name={"install-exit-handlers"}, deprecated="--install-exit-handlers is enabled by default for executables and it can likely be removed. To use this option for the shared libraries, please use -H:+InstallExitHandlers.")
    protected static final HostedOptionKey<Boolean> InstallExitHandlers;
    public static final RuntimeOptionKey<String> CompilationIsolateOptions;
    public static final RuntimeOptionKey<Long> CompilationIsolateAddressSpaceSize;
    public static final RuntimeOptionKey<Integer> ActiveProcessorCount;
    public static final HostedOptionKey<Boolean> DisableTypeIdResultVerification;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final RuntimeOptionKey<Boolean> EnableSignalHandling;
    @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
    public static final HostedOptionKey<Boolean> UseSystemLocale;
    public static final RuntimeOptionKey<Boolean> HeapDumpOnOutOfMemoryError;
    public static final RuntimeOptionKey<String> HeapDumpPath;
    public static final HostedOptionKey<String> HeapDumpDefaultFilenamePrefix;
    public static final RuntimeOptionKey<Boolean> DumpHeapAndExit;
    public static final RuntimeOptionKey<Boolean> PrintVMInfoAndExit;
    public static final RuntimeOptionKey<Boolean> FlightRecorder;
    public static final RuntimeOptionKey<String> StartFlightRecording;
    public static final RuntimeOptionKey<String> FlightRecorderLogging;
    public static final RuntimeOptionKey<String> FlightRecorderOptions;
    public static final RuntimeOptionKey<String> DiagnosticDetails;
    public static final HostedOptionKey<Boolean> AsyncSignalSafeDiagnostics;
    public static final HostedOptionKey<Integer> DiagnosticBufferSize;
    public static final HostedOptionKey<Boolean> VerifyFrameAnchors;
    public static final HostedOptionKey<Boolean> VerifyFrameAccess;
    @APIOption(name={"configure-reflection-metadata"}, deprecated="This option has no function anymore.")
    public static final HostedOptionKey<Boolean> ConfigureReflectionMetadata;
    public static final HostedOptionKey<Boolean> IncludeMethodData;
    public static final HostedOptionKey<Boolean> VerifyTypes;
    public static final HostedOptionKey<Boolean> UseDirectCallTrampolinesALot;
    public static final HostedOptionKey<Boolean> RunMainInNewThread;
    public static final HostedOptionKey<Boolean> AllowDeprecatedBuilderClassesOnImageClasspath;
    @APIOption(name={"exact-reachability-metadata"}, defaultValue={""})
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ThrowMissingRegistrationErrors;
    @APIOption(name={"exact-reachability-metadata-path"})
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> ThrowMissingRegistrationErrorsPaths;
    public static final RuntimeOptionKey<ReportingMode> MissingRegistrationReportingMode;
    public static final RuntimeOptionKey<Integer> MissingRegistrationWarnContextLines;
    public static final HostedOptionKey<Boolean> ThrowLinkAtBuildTimeIOExceptions;
    public static final HostedOptionKey<Boolean> PinnedObjectAddressing;
    public static final HostedOptionKey<Boolean> UnlockExperimentalVMOptions;
    public static final HostedOptionKey<Boolean> UseOldMethodHandleIntrinsics;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> Preserve;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> IgnorePreserveForClasses;
    public static final HostedOptionKey<Boolean> UseBaseLayerInclusionPolicy;
    public static final HostedOptionKey<Boolean> ForeignAPISupport;
    public static final HostedOptionKey<Boolean> VectorAPISupport;
    public static final HostedOptionKey<Boolean> SharedArenaSupport;
    public static final HostedOptionKey<Boolean> ClosedTypeWorld;
    public static final HostedOptionKey<Boolean> ClosedTypeWorldHubLayout;
    public static final HostedOptionKey<Boolean> AbortOnNameConflict;
    public static final HostedOptionKey<Boolean> LoggingHashCodeInjection;
    public static final HostedOptionKey<Boolean> ReduceImplicitExceptionStackTraceInformation;
    public static final HostedOptionKey<Boolean> AllowUnsafeAllocationOfAllInstantiatedTypes;
    public static final HostedOptionKey<Boolean> MremapImageHeap;
    public static final HostedOptionKey<String> LibGraalClassLoader;
    public static final HostedOptionKey<Boolean> PrintClosedArenaUponThrow;
    public static final HostedOptionKey<Boolean> RelativeCodePointers;
    public static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings> TrackDynamicAccess;
    public static final HostedOptionKey<Boolean> TrackJavaHomeAccess;
    public static final HostedOptionKey<Boolean> TrackJavaHomeAccessDetailed;

    @Fold
    public static boolean getSourceLevelDebug() {
        return SourceLevelDebug.getValue();
    }

    @Fold
    public static Predicate<String> getSourceLevelDebugFilter() {
        return SubstrateOptions.makeFilter(SourceLevelDebugFilter.getValue().values());
    }

    @Fold
    public static UUID getImageBuildID() {
        return UUID.fromString(ImageBuildID.getValue());
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private static Predicate<String> makeFilter(List<String> definedFilters) {
        if (definedFilters.isEmpty()) {
            return javaName -> true;
        }
        return javaName -> {
            for (String wildCard : definedFilters) {
                if (!javaName.startsWith(wildCard)) continue;
                return true;
            }
            return false;
        };
    }

    public static void configureOs(EconomicMap<OptionKey<?>, Object> values) {
        SubstrateOptions.enable((OptionKey<Boolean>)GraalOptions.ReduceCodeSize, values);
        SubstrateOptions.enable(ReduceImplicitExceptionStackTraceInformation, values);
        SubstrateOptions.enable((OptionKey<Boolean>)GraalOptions.OptimizeLongJumps, values);
        SubstrateOptions.disable((OptionKey<Boolean>)GraalOptions.LoopPeeling, values);
        SubstrateOptions.disable((OptionKey<Boolean>)GraalOptions.LoopUnswitch, values);
        SubstrateOptions.disable((OptionKey<Boolean>)GraalOptions.FullUnroll, values);
        SubstrateOptions.disable((OptionKey<Boolean>)GraalOptions.PartialUnroll, values);
        GraalOptions.LoopHeaderAlignment.update(values, (Object)0);
        GraalOptions.IsolatedLoopHeaderAlignment.update(values, (Object)0);
        SubstrateOptions.disable((OptionKey<Boolean>)GraalOptions.PartialEscapeAnalysis, values);
        SubstrateOptions.disable((OptionKey<Boolean>)GraalOptions.OptimizeDiv, values);
        GraalOptions.ConditionalEliminationMaxIterations.update(values, (Object)10);
        SubstrateOptions.disable((OptionKey<Boolean>)DeadCodeEliminationPhase.Options.ReduceDCE, values);
    }

    public static void disable(OptionKey<Boolean> key, EconomicMap<OptionKey<?>, Object> values) {
        key.update(values, (Object)false);
    }

    public static void enable(OptionKey<Boolean> key, EconomicMap<OptionKey<?>, Object> values) {
        key.update(values, (Object)true);
    }

    private static OptimizationLevel parseOptimizationLevel(String value) {
        int intLevel;
        if (value.equals("b")) {
            return OptimizationLevel.BUILD_TIME;
        }
        if (value.equals("s")) {
            return OptimizationLevel.SIZE;
        }
        try {
            intLevel = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            intLevel = -1;
        }
        if (intLevel == 0) {
            return OptimizationLevel.O0;
        }
        if (intLevel == 1) {
            return OptimizationLevel.O1;
        }
        if (intLevel == 2) {
            return OptimizationLevel.O2;
        }
        if (intLevel > 2) {
            return OptimizationLevel.O3;
        }
        throw UserError.invalidOptionValue(Optimize, value, "Accepted values are 'b' or numeric value >= 0");
    }

    @Fold
    public static OptimizationLevel optimizationLevel() {
        return SubstrateOptions.parseOptimizationLevel(Optimize.getValue());
    }

    public static boolean useEconomyCompilerConfig(OptionValues options) {
        return "b".equals(Optimize.getValue(options));
    }

    public static boolean useCodeSizeCompilerConfig(OptionValues options) {
        return "s".equals(Optimize.getValue(options));
    }

    @Fold
    public static boolean useEconomyCompilerConfig() {
        return SubstrateOptions.useEconomyCompilerConfig(HostedOptionValues.singleton());
    }

    @Fold
    public static boolean useCodeSizeCompilerConfig() {
        return SubstrateOptions.useCodeSizeCompilerConfig(HostedOptionValues.singleton());
    }

    @Fold
    public static boolean isMaximumOptimizationLevel() {
        return SubstrateOptions.optimizationLevel() == OptimizationLevel.O3;
    }

    public static void setOptimizeValueUpdateHandler(ValueUpdateHandler<OptimizationLevel> updateHandler) {
        optimizeValueUpdateHandler = updateHandler;
    }

    public static void setImageLayerEnabledHandler(OptionEnabledHandler<Boolean> updateHandler) {
        imageLayerEnabledHandler = updateHandler;
    }

    public static void setImageLayerCreateEnabledHandler(OptionEnabledHandler<Boolean> updateHandler) {
        imageLayerCreateEnabledHandler = updateHandler;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Path getImagePath(OptionValues optionValues) {
        VMError.guarantee(optionValues != null);
        if (!ConcealedOptions.Path.hasBeenSet(optionValues)) {
            VMError.shouldNotReachHere("Image builder requires %s", SubstrateOptionsParser.commandArgument(ConcealedOptions.Path, "<builder output directory>"));
        }
        return Path.of((String)ConcealedOptions.Path.getValue(optionValues), new String[0]);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Path getImagePath() {
        return SubstrateOptions.getImagePath(HostedOptionValues.singleton());
    }

    @Fold
    public static boolean useSerialGC() {
        return !SupportedGCs.hasBeenSet() || SupportedGCs.getValue().contains(GCOptionValue.SERIAL.getValue());
    }

    @Fold
    public static boolean useParallelGC() {
        return SupportedGCs.getValue().contains(GCOptionValue.PARALLEL.getValue());
    }

    @Fold
    public static boolean useEpsilonGC() {
        return SupportedGCs.getValue().contains(GCOptionValue.EPSILON.getValue());
    }

    @Fold
    public static boolean useG1GC() {
        return SupportedGCs.getValue().contains(GCOptionValue.G1.getValue());
    }

    @Fold
    public static boolean useSerialOrParallelGC() {
        return SubstrateOptions.useSerialGC() || SubstrateOptions.useParallelGC();
    }

    @Fold
    public static boolean useSerialOrParallelOrEpsilonGC() {
        return SubstrateOptions.useSerialOrParallelGC() || SubstrateOptions.useEpsilonGC();
    }

    public static int maxJavaStackTraceDepth() {
        return maxJavaStackTraceDepth;
    }

    public static void updateMaxJavaStackTraceDepth(EconomicMap<OptionKey<?>, Object> runtimeValues, int newValue) {
        ConcealedOptions.MaxJavaStackTraceDepth.update(runtimeValues, newValue);
    }

    public static boolean hasColorsEnabled(OptionValues values) {
        if (Color.hasBeenSet(values)) {
            String value;
            return switch (value = (String)Color.getValue(values)) {
                case "always" -> true;
                case "auto" -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError((Object)"'auto' value should have been resolved in the driver");
                    }
                    yield false;
                }
                case "never" -> false;
                default -> throw UserError.invalidOptionValue(Color, value, "Only 'always', 'never', and 'auto' are accepted values");
            };
        }
        return false;
    }

    @Fold
    public static int getAllocatePrefetchStyle() {
        Integer style = ConcealedOptions.AllocatePrefetchStyle.getValue();
        if (style != null) {
            return style;
        }
        return SubstrateOptions.useSerialGC() ? 0 : 1;
    }

    private static void validateAdditionalHeaderBytes(HostedOptionKey<Integer> optionKey) {
        int value = optionKey.getValue();
        if (value < 0 || value % 4 != 0) {
            throw UserError.invalidOptionValue(optionKey, value, "The value must be 0 or a positive multiple of 4.");
        }
    }

    private static void validateZapNativeMemory(HostedOptionKey<Boolean> optionKey) {
        boolean value = optionKey.getValue();
        if (value && !VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            throw UserError.abort("The option '" + optionKey.getName() + "' can only be enabled if NMT is enabled as well ('--enable-monitoring=nmt').", new Object[0]);
        }
    }

    public static long getTearDownWarningNanos() {
        if (TearDownWarningSeconds.hasBeenSet() && DeprecatedOptions.TearDownWarningNanos.hasBeenSet()) {
            throw new IllegalArgumentException("Can't set both TearDownWarningSeconds and TearDownWarningNanos at the same time. Use TearDownWarningSeconds.");
        }
        if (DeprecatedOptions.TearDownWarningNanos.hasBeenSet()) {
            return DeprecatedOptions.TearDownWarningNanos.getValue();
        }
        return TearDownWarningSeconds.getValue() * 1000000000L;
    }

    public static long getTearDownFailureNanos() {
        return DeprecatedOptions.TearDownFailureNanos.getValue();
    }

    @Fold
    public static boolean hasFramePointer() {
        return PreserveFramePointer.getValue() != false || Platform.includedIn(Platform.AARCH64.class) || Platform.includedIn(Platform.RISCV64.class);
    }

    @Fold
    public static boolean useLLVMBackend() {
        return "llvm".equals(CompilerBackend.getValue());
    }

    @Fold
    public static boolean useLIRBackend() {
        return "lir".equals(CompilerBackend.getValue());
    }

    @Fold
    public static int codeAlignment() {
        int value = ConcealedOptions.CodeAlignment.getValue();
        if (value > 0) {
            return value;
        }
        if (ConfigurationValues.getTarget().arch instanceof AMD64 && SubstrateOptions.optimizationLevel() != OptimizationLevel.SIZE) {
            return 32;
        }
        return 16;
    }

    private static void validateGenerateDebugInfo(HostedOptionKey<Integer> optionKey) {
        if (OS.getCurrent() == OS.DARWIN && optionKey.hasBeenSet() && optionKey.getValue() > 0) {
            LogUtils.warning((String)"Using %s is limited and experimental on macOS", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(optionKey, optionKey.getValue().toString())});
        }
    }

    public static boolean useDebugInfoGeneration() {
        return SubstrateOptions.useLIRBackend() && GenerateDebugInfo.getValue() > 0;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Path getDebugInfoSourceCacheRoot() {
        try {
            return SubstrateOptions.getImagePath().resolve(DebugInfoSourceCacheRoot.getValue());
        }
        catch (InvalidPathException ipe) {
            throw UserError.invalidOptionValue(DebugInfoSourceCacheRoot, DebugInfoSourceCacheRoot.getValue(), "The path is invalid");
        }
    }

    private static void validateStripDebugInfo(HostedOptionKey<Boolean> optionKey) {
        Boolean optionValue = optionKey.getValue();
        if (OS.getCurrent() == OS.DARWIN && optionKey.hasBeenSet() && optionKey.getValue().booleanValue()) {
            throw UserError.invalidOptionValue(optionKey, optionValue, "The option is not supported on macOS");
        }
        if (OS.getCurrent() == OS.WINDOWS && optionKey.hasBeenSet() && !optionKey.getValue().booleanValue()) {
            throw UserError.invalidOptionValue(optionKey, optionValue, "The option is not supported on Windows (debug info is always generated in a separate file)");
        }
    }

    @Fold
    public static boolean supportCompileInIsolates() {
        UserError.guarantee(ConcealedOptions.SupportCompileInIsolates.getValue() == false || SpawnIsolates.getValue() != false, "Option %s must be enabled to support isolated compilations through option %s", SpawnIsolates.getName(), ConcealedOptions.SupportCompileInIsolates.getName());
        return ConcealedOptions.SupportCompileInIsolates.getValue();
    }

    public static boolean shouldCompileInIsolates() {
        return SubstrateOptions.supportCompileInIsolates() && ConcealedOptions.CompileInIsolates.getValue() != false;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static String reportsPath() {
        Path reportsPath = ((ReportingSupport)ImageSingletons.lookup(ReportingSupport.class)).reportsPath;
        if (reportsPath.isAbsolute()) {
            return reportsPath.toString();
        }
        return SubstrateOptions.getImagePath().resolve(reportsPath).toString();
    }

    @Fold
    public static int getPageSize() {
        int value = ConcealedOptions.PageSize.getValue();
        if (value == 0) {
            return Math.max(65536, Unsafe.getUnsafe().pageSize());
        }
        assert (value > 0) : value;
        return value;
    }

    @Fold
    public static boolean isForeignAPIEnabled() {
        return ForeignAPISupport.getValue();
    }

    @Fold
    public static boolean useClosedTypeWorldHubLayout() {
        return ClosedTypeWorldHubLayout.getValue();
    }

    @Fold
    public static boolean useClosedTypeWorld() {
        return ClosedTypeWorld.getValue();
    }

    @Fold
    public static boolean printClosedArenaUponThrow() {
        return PrintClosedArenaUponThrow.getValue();
    }

    @Fold
    public static boolean useRelativeCodePointers() {
        return RelativeCodePointers.getValue();
    }

    private static void validateRelativeCodePointers(HostedOptionKey<Boolean> optionKey) {
        if (optionKey.getValue().booleanValue()) {
            String enabledOption = SubstrateOptionsParser.commandArgument(optionKey, "+");
            UserError.guarantee(Platform.includedIn(InternalPlatform.PLATFORM_JNI.class) || Platform.includedIn(InternalPlatform.NATIVE_ONLY.class), "%s is supported only with hardware target platforms.", enabledOption);
            UserError.guarantee(!ImageLayerBuildingSupport.buildingImageLayer(), "%s is currently not supported with layered images.", enabledOption);
            UserError.guarantee(!SubstrateOptions.useLLVMBackend(), "%s is currently not supported with the LLVM backend.", enabledOption);
            UserError.guarantee(!PLTGOTConfiguration.isEnabled(), "%s cannot be used together with PLT/GOT.", enabledOption);
        }
    }

    public static boolean hasDumpRuntimeCompiledMethodsSupport() {
        return !Platform.includedIn(InternalPlatform.WINDOWS_BASE.class) && ConcealedOptions.DumpRuntimeCompiledMethods.getValue() != false;
    }

    static {
        Optimize = new HostedOptionKey<String>("2"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                OptimizationLevel newLevel = SubstrateOptions.parseOptimizationLevel(newValue);
                if (newLevel == OptimizationLevel.O0) {
                    GraalOptions.TrackNodeSourcePosition.update(values, (Object)true);
                    IncludeNodeSourcePositions.update(values, true);
                    SourceLevelDebug.update(values, true);
                    AOTTrivialInline.update(values, false);
                }
                ReduceImplicitExceptionStackTraceInformation.update(values, newLevel == OptimizationLevel.O3);
                GraalOptions.OptimizeLongJumps.update(values, (Object)(!newLevel.isOneOf(OptimizationLevel.O0, OptimizationLevel.BUILD_TIME) ? 1 : 0));
                if (newLevel == OptimizationLevel.SIZE) {
                    SubstrateOptions.configureOs(values);
                }
                if (optimizeValueUpdateHandler != null) {
                    optimizeValueUpdateHandler.onValueUpdate(values, newLevel);
                }
            }
        };
        IncludeNodeSourcePositions = new HostedOptionKey<Boolean>(false);
        CLibraryPath = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter());
        LinkerRPath = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        SupportedGCs = new HostedOptionKey<ReplacingLocatableMultiOptionValue.DelimitedString>(ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter(GCOptionValue.SERIAL.getValue())){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, ReplacingLocatableMultiOptionValue.DelimitedString oldValue, ReplacingLocatableMultiOptionValue.DelimitedString newValue) {
                if (newValue.contains(GCOptionValue.G1.getValue())) {
                    SpawnIsolates.update(values, true);
                    AllowVMInternalThreads.update(values, true);
                    ConcealedOptions.UseDedicatedVMOperationThread.update(values, true);
                    ConcealedOptions.SupportCompileInIsolates.update(values, false);
                }
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
            }
        };
        UseContainerSupport = new HostedOptionKey<Boolean>(true);
        StackSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        InternalThreadStackSize = new HostedOptionKey<Long>(0L);
        maxJavaStackTraceDepth = 1024;
        MaxDirectMemorySize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        VerifyNamingConventions = new HostedOptionKey<Boolean>(false);
        DisableSubstitution = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        MultiThreaded = new HostedOptionKey<Boolean>(true);
        NoDirectRelocationsInText = new HostedOptionKey<Boolean>(true);
        SpawnIsolates = new HostedOptionKey<Boolean>(true);
        CheckIsolateThreadAtEntry = new HostedOptionKey<Boolean>(false);
        TraceVMOperations = new HostedOptionKey<Boolean>(false);
        TraceClassInitialization = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        TraceObjectInstantiation = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        TraceNativeToolUsage = new HostedOptionKey<Boolean>(false);
        EntryPointNamePrefix = new HostedOptionKey<String>("");
        APIFunctionPrefix = new HostedOptionKey<String>("graal_");
        EnableURLProtocols = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        DisableURLProtocols = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        EnableAllSecurityServices = new HostedOptionKey<Boolean>(false);
        JNI = new HostedOptionKey<Boolean>(true);
        JNIVerboseLookupErrors = new HostedOptionKey<Boolean>(false);
        JNIExportSymbols = new HostedOptionKey<Boolean>(true);
        JNIEnhancedErrorCodes = new HostedOptionKey<Boolean>(false);
        JVMTI = new HostedOptionKey<Boolean>(false);
        JVMTIAgentLib = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        JVMTIAgentPath = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        GenerateBuildArtifactsFile = new HostedOptionKey<Boolean>(false);
        Color = new HostedOptionKey<String>("auto");
        BuildOutputSilent = new HostedOptionKey<Boolean>(false);
        BuildOutputPrefix = new HostedOptionKey<Boolean>(false);
        BuildOutputColorful = new HostedOptionKey<Boolean>(false);
        BuildOutputLinks = new HostedOptionKey<Boolean>(false);
        BuildOutputProgress = new HostedOptionKey<Boolean>(false);
        BuildOutputBreakdowns = new HostedOptionKey<Boolean>(true);
        BuildOutputRecommendations = new HostedOptionKey<Boolean>(true);
        BuildOutputGCWarnings = new HostedOptionKey<Boolean>(true);
        BuildOutputJSONFile = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.build());
        AllocatePrefetchLines = new HostedOptionKey<Integer>(4);
        AllocateInstancePrefetchLines = new HostedOptionKey<Integer>(1);
        AllocatePrefetchInstr = new HostedOptionKey<Integer>(0);
        AllocatePrefetchDistance = new HostedOptionKey<Integer>(192);
        AllocatePrefetchStepSize = new HostedOptionKey<Integer>(64);
        ContendedPaddingWidth = new HostedOptionKey<Integer>(128);
        AdditionalHeaderBytes = new HostedOptionKey<Integer>(0, SubstrateOptions::validateAdditionalHeaderBytes);
        ZapNativeMemory = new HostedOptionKey<Boolean>(false, SubstrateOptions::validateZapNativeMemory);
        TearDownWarningSeconds = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        MaxUnrolledObjectZeroingStores = new HostedOptionKey<Integer>(8);
        StackTrace = new HostedOptionKey<Boolean>(true);
        ParseRuntimeOptions = new HostedOptionKey<Boolean>(true);
        EnableWildcardExpansion = new HostedOptionKey<Boolean>(true);
        AOTInline = new HostedOptionKey<Boolean>(true);
        AOTTrivialInline = new HostedOptionKey<Boolean>(true);
        NeverInline = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        MaxNodesInTrivialMethod = new HostedOptionKey<Integer>(20);
        MaxInvokesInTrivialMethod = new HostedOptionKey<Integer>(1);
        MaxNodesInTrivialLeafMethod = new HostedOptionKey<Integer>(40);
        MaxNodesAfterTrivialInlining = new HostedOptionKey<Integer>(Integer.MAX_VALUE);
        PreserveFramePointer = new HostedOptionKey<Boolean>(false);
        UseCalleeSavedRegisters = new HostedOptionKey<Boolean>(true);
        ReportAnalysisForbiddenType = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        CompilerBackend = new HostedOptionKey<String>("lir"){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                if ("llvm".equals(newValue)) {
                    boolean isLLVMBackendMissing;
                    if (ModuleSupport.modulePathBuild) {
                        isLLVMBackendMissing = ModuleLayer.boot().findModule("org.graalvm.nativeimage.llvm").isEmpty();
                    } else {
                        boolean bl = isLLVMBackendMissing = ReflectionUtil.lookupClass((boolean)true, (String)"com.oracle.svm.core.graal.llvm.LLVMFeature") == null;
                    }
                    if (isLLVMBackendMissing) {
                        throw UserError.invalidOptionValue(CompilerBackend, newValue, "The LLVM backend for GraalVM Native Image is missing and needs to be built from source. For instructions, please see https://github.com/oracle/graal/blob/master/docs/reference-manual/native-image/LLVMBackend.md.");
                    }
                    GraalOptions.EmitStringSubstitutions.update(values, (Object)false);
                    RemoveUnusedSymbols.update(values, false);
                    InternalSymbolsAreGlobal.update(values, true);
                    SpectrePHTMitigations.Options.SpectrePHTBarriers.update(values, (Object)SpectrePHTMitigations.None);
                }
            }
        };
        RemoveUnusedSymbols = new HostedOptionKey<Boolean>(true);
        DeleteLocalSymbols = new HostedOptionKey<Boolean>(true);
        InternalSymbolsAreGlobal = new HostedOptionKey<Boolean>(false);
        ImageSymbolsPrefix = new HostedOptionKey<String>("");
        FoldSecurityManagerGetter = new HostedOptionKey<Boolean>(true);
        CCompilerPath = new HostedOptionKey<Object>(null);
        CCompilerOption = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        StrictQueryCodeCompilation = new HostedOptionKey<Boolean>(true);
        DumpTargetInfo = new HostedOptionKey<Boolean>(false);
        CheckToolchain = new HostedOptionKey<Boolean>(true);
        DetectUserDirectoriesInImageHeap = new HostedOptionKey<Boolean>(false);
        UseNullRegion = new HostedOptionKey<Boolean>(true);
        DeadlockWatchdogInterval = new HostedOptionKey<Integer>(10);
        DeadlockWatchdogExitOnTimeout = new HostedOptionKey<Boolean>(true);
        AllowVMInternalThreads = new HostedOptionKey<Boolean>(true);
        IncludeDebugHelperMethods = new HostedOptionKey<Boolean>(false);
        GenerateDebugInfo = new HostedOptionKey<Integer>(Integer.valueOf(0), SubstrateOptions::validateGenerateDebugInfo){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                if (OS.WINDOWS.isCurrent()) {
                    DeleteLocalSymbols.update(values, newValue == 0);
                }
            }
        };
        DebugInfoSourceCacheRoot = new HostedOptionKey<String>("sources");
        CheckBootModuleDependencies = new HostedOptionKey<Integer>(ModuleSupport.modulePathBuild ? 1 : 0);
        StripDebugInfo = new HostedOptionKey<Boolean>(OS.getCurrent() != OS.DARWIN, SubstrateOptions::validateStripDebugInfo);
        OmitInlinedMethodDebugLineInfo = new HostedOptionKey<Boolean>(false);
        DebugCodeInfoMaxDepth = new HostedOptionKey<Integer>(Integer.MAX_VALUE);
        DebugCodeInfoUseSourceMappings = new HostedOptionKey<Boolean>(false);
        UseImagebuildDebugSections = new HostedOptionKey<Boolean>(true);
        InstallExitHandlers = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (values.containsKey((Object)this)) {
                    return (Boolean)values.get((Object)this);
                }
                return ImageInfo.isExecutable();
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        CompilationIsolateOptions = new RuntimeOptionKey<Object>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        CompilationIsolateAddressSpaceSize = new RuntimeOptionKey<Long>(Long.valueOf(0L), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        ActiveProcessorCount = new RuntimeOptionKey<Integer>(Integer.valueOf(-1), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser, RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        DisableTypeIdResultVerification = new HostedOptionKey<Boolean>(true);
        EnableSignalHandling = new RuntimeOptionKey<Boolean>(null, new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable}){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (values.containsKey((Object)this)) {
                    return (Boolean)values.get((Object)this);
                }
                return ImageInfo.isExecutable();
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        UseSystemLocale = new HostedOptionKey<Boolean>(true);
        HeapDumpOnOutOfMemoryError = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        HeapDumpPath = new RuntimeOptionKey<String>("", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        HeapDumpDefaultFilenamePrefix = new HostedOptionKey<String>("svm-heapdump-");
        DumpHeapAndExit = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        PrintVMInfoAndExit = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        FlightRecorder = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        StartFlightRecording = new RuntimeOptionKey<String>("", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        FlightRecorderLogging = new RuntimeOptionKey<String>("all=warning", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        FlightRecorderOptions = new RuntimeOptionKey<String>("", RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);
        DiagnosticDetails = new RuntimeOptionKey<String>("", new RuntimeOptionKey.RuntimeOptionKeyFlag[]{RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates}){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, String oldValue, String newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                SubstrateDiagnostics.updateInitialInvocationCounts(newValue);
            }
        };
        AsyncSignalSafeDiagnostics = new HostedOptionKey<Boolean>(false);
        DiagnosticBufferSize = new HostedOptionKey<Integer>(30);
        VerifyFrameAnchors = new HostedOptionKey<Boolean>(false);
        VerifyFrameAccess = new HostedOptionKey<Boolean>(false);
        ConfigureReflectionMetadata = new HostedOptionKey<Boolean>(true);
        IncludeMethodData = new HostedOptionKey<Boolean>(false);
        VerifyTypes = new HostedOptionKey<Boolean>(false);
        UseDirectCallTrampolinesALot = new HostedOptionKey<Boolean>(false);
        RunMainInNewThread = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this) && Platform.includedIn(Platform.LINUX.class) && LibCBase.targetLibCIs(MuslLibC.class)) {
                    return true;
                }
                return (Boolean)values.get((Object)this, this.getDefaultValue());
            }
        };
        AllowDeprecatedBuilderClassesOnImageClasspath = new HostedOptionKey<Boolean>(false);
        ThrowMissingRegistrationErrors = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        ThrowMissingRegistrationErrorsPaths = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        MissingRegistrationReportingMode = new RuntimeOptionKey<ReportingMode>(ReportingMode.Throw, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        MissingRegistrationWarnContextLines = new RuntimeOptionKey<Integer>(Integer.valueOf(8), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
        ThrowLinkAtBuildTimeIOExceptions = new HostedOptionKey<Boolean>(false);
        PinnedObjectAddressing = new HostedOptionKey<Boolean>(true);
        UnlockExperimentalVMOptions = new HostedOptionKey<Boolean>(false);
        UseOldMethodHandleIntrinsics = new HostedOptionKey<Boolean>(false);
        Preserve = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.build());
        IgnorePreserveForClasses = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        UseBaseLayerInclusionPolicy = new HostedOptionKey<Boolean>(false);
        ForeignAPISupport = new HostedOptionKey<Boolean>(true);
        VectorAPISupport = new HostedOptionKey<Boolean>(false);
        SharedArenaSupport = new HostedOptionKey<Boolean>(false, key -> {
            if (((Boolean)key.getValue()).booleanValue()) {
                UserError.guarantee(!RuntimeCompilation.isEnabled(), "Arena.ofShared is not supported with runtime compilations. Replace usages of Arena.ofShared with Arena.ofAuto and disable shared arena support.", new Object[0]);
                UserError.guarantee(!VectorAPIEnabled.getValue(), "Support for Arena.ofShared is not available with Vector API support. Either disable Vector API support using %s or replace usages of Arena.ofShared with Arena.ofAuto and disable shared arena support.", SubstrateOptionsParser.commandArgument(VectorAPISupport, "-"));
            }
        });
        ClosedTypeWorld = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                ClosedTypeWorldHubLayout.update(values, newValue);
            }
        };
        ClosedTypeWorldHubLayout = new HostedOptionKey<Boolean>(true);
        AbortOnNameConflict = new HostedOptionKey<Boolean>(false);
        LoggingHashCodeInjection = new HostedOptionKey<Boolean>(false);
        ReduceImplicitExceptionStackTraceInformation = new HostedOptionKey<Boolean>(false);
        AllowUnsafeAllocationOfAllInstantiatedTypes = new HostedOptionKey<Object>(null);
        MremapImageHeap = new HostedOptionKey<Boolean>(true, key -> {
            if (key.hasBeenSet() && !Platform.includedIn(Platform.LINUX.class)) {
                throw UserError.invalidOptionValue(key, (Boolean)key.getValue(), "Mapping the image heap with mremap() is only supported on Linux.");
            }
        });
        LibGraalClassLoader = new HostedOptionKey<String>("");
        PrintClosedArenaUponThrow = new HostedOptionKey<Boolean>(false);
        RelativeCodePointers = new HostedOptionKey<Boolean>(false, SubstrateOptions::validateRelativeCodePointers);
        TrackDynamicAccess = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Strings>(AccumulatingLocatableMultiOptionValue.Strings.buildWithCommaDelimiter());
        TrackJavaHomeAccess = new HostedOptionKey<Boolean>(false);
        TrackJavaHomeAccessDetailed = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    TrackJavaHomeAccess.update(values, true);
                }
            }
        };
    }

    public static enum OptimizationLevel {
        O0("No optimizations", "0"),
        O1("Basic optimizations", "1"),
        O2("Advanced optimizations", "2"),
        O3("All optimizations for best performance", "3"),
        BUILD_TIME("Optimize for fastest build time", "b"),
        SIZE("Optimize for size", "s");

        private final String description;
        private final String optionSwitch;

        private OptimizationLevel(String description, String optionSwitch) {
            this.description = description;
            this.optionSwitch = optionSwitch;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOptionSwitch() {
            return this.optionSwitch;
        }

        public boolean isOneOf(OptimizationLevel ... levels) {
            if (levels != null) {
                for (OptimizationLevel level : levels) {
                    if (!level.equals((Object)this)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static interface ValueUpdateHandler<T> {
        public void onValueUpdate(EconomicMap<OptionKey<?>, Object> var1, T var2);
    }

    public static interface OptionEnabledHandler<T> {
        public void onOptionEnabled(EconomicMap<OptionKey<?>, Object> var1);
    }

    public static class ConcealedOptions {
        public static final HostedOptionKey<Boolean> SupportCompileInIsolates = new HostedOptionKey<Boolean>(null){

            public Boolean getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return (Boolean)SpawnIsolates.getValueOrDefault(values);
                }
                return (Boolean)super.getValueOrDefault(values);
            }

            public Boolean getValue(OptionValues values) {
                return this.getValueOrDefault(values.getMap());
            }
        };
        public static final RuntimeOptionKey<Boolean> CompileInIsolates = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        public static final HostedOptionKey<Boolean> UseDedicatedVMOperationThread = new HostedOptionKey<Boolean>(false);
        public static final RuntimeOptionKey<Boolean> AutomaticReferenceHandling = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
        public static final RuntimeOptionKey<Boolean> UsePerfData = new RuntimeOptionKey<Boolean>(Boolean.valueOf(true), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
        public static final RuntimeOptionKey<Integer> MaxJavaStackTraceDepth = new RuntimeOptionKey<Integer>(Integer.valueOf(maxJavaStackTraceDepth), new RuntimeOptionKey.RuntimeOptionKeyFlag[0]){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Integer oldValue, Integer newValue) {
                super.onValueUpdate(values, (Object)oldValue, (Object)newValue);
                maxJavaStackTraceDepth = newValue;
            }
        };
        @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
        protected static final HostedOptionKey<Integer> PageSize = new HostedOptionKey<Integer>(0);
        @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
        public static final RuntimeOptionKey<Long> MaxRAM = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RegisterForIsolateArgumentParser);
        @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
        public static final HostedOptionKey<Integer> AllocatePrefetchStyle = new HostedOptionKey<Object>(null);
        @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
        public static final HostedOptionKey<Integer> CodeAlignment = new HostedOptionKey<Integer>(0);
        @OptionMigrationMessage(value="Use the '-o' option instead.")
        public static final HostedOptionKey<String> Path = new HostedOptionKey<Object>(null);
        public static final RuntimeOptionKey<Boolean> DumpRuntimeCompiledMethods = new RuntimeOptionKey<Boolean>(Boolean.valueOf(false), key -> {
            if (key.hasBeenSet() && Platform.includedIn(InternalPlatform.WINDOWS_BASE.class)) {
                throw UserError.invalidOptionValue(key, (Boolean)key.getValue(), "Dumping runtime compiled code is not supported on Windows.");
            }
        }, new RuntimeOptionKey.RuntimeOptionKeyFlag[0]);
    }

    public static class DeprecatedOptions {
        @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
        @APIOption(name={"serial"}, group=GCGroup.class, customHelp="Serial garbage collector")
        public static final HostedOptionKey<Boolean> UseSerialGC = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SupportedGCs.update(values, ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter(GCOptionValue.SERIAL.getValue()));
                } else if (!values.containsKey(SupportedGCs) || ((ReplacingLocatableMultiOptionValue.DelimitedString)values.get(SupportedGCs)).contains(GCOptionValue.SERIAL.getValue())) {
                    SupportedGCs.update(values, ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter());
                }
            }
        };
        @LayerVerifiedOption(kind=LayerVerifiedOption.Kind.Changed, severity=LayerVerifiedOption.Severity.Error)
        @APIOption(name={"epsilon"}, group=GCGroup.class, customHelp="Epsilon garbage collector")
        public static final HostedOptionKey<Boolean> UseEpsilonGC = new HostedOptionKey<Boolean>(Boolean.valueOf(false)){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SupportedGCs.update(values, ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter(GCOptionValue.EPSILON.getValue()));
                } else if (((AccumulatingLocatableMultiOptionValue.Strings)values.get(SupportedGCs)).contains(GCOptionValue.EPSILON.getValue())) {
                    SupportedGCs.update(values, ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter());
                }
            }
        };
        public static final String TEAR_DOWN_WARNING_NANOS_ERROR = "Can't set both TearDownWarningSeconds and TearDownWarningNanos at the same time. Use TearDownWarningSeconds.";
        public static final RuntimeOptionKey<Long> TearDownWarningNanos = new RuntimeOptionKey<Long>(Long.valueOf(0L), key -> UserError.guarantee(!key.hasBeenSet() || !TearDownWarningSeconds.hasBeenSet(), TEAR_DOWN_WARNING_NANOS_ERROR, new Object[0]), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        public static final RuntimeOptionKey<Long> TearDownFailureNanos = new RuntimeOptionKey<Long>(Long.valueOf(0L), RuntimeOptionKey.RuntimeOptionKeyFlag.RelevantForCompilationIsolates);
        @APIOption(name={"parallel"}, group=GCGroup.class, customHelp="Parallel garbage collector")
        public static final HostedOptionKey<Boolean> UseParallelGC = new HostedOptionKey<Boolean>(Boolean.FALSE, DeprecatedOptions::requireMultiThreading){

            protected void onValueUpdate(EconomicMap<OptionKey<?>, Object> values, Boolean oldValue, Boolean newValue) {
                if (newValue.booleanValue()) {
                    SupportedGCs.update(values, ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter(GCOptionValue.PARALLEL.getValue()));
                } else if (((AccumulatingLocatableMultiOptionValue.Strings)values.get(SupportedGCs)).contains(GCOptionValue.PARALLEL.getValue())) {
                    SupportedGCs.update(values, ReplacingLocatableMultiOptionValue.DelimitedString.buildWithCommaDelimiter());
                }
            }
        };
        public static final RuntimeOptionKey<Integer> ParallelGCThreads = new RuntimeOptionKey<Integer>(Integer.valueOf(0), RuntimeOptionKey.RuntimeOptionKeyFlag.Immutable);

        private static void requireMultiThreading(HostedOptionKey<Boolean> optionKey) {
            if (optionKey.getValue().booleanValue() && !MultiThreaded.getValue().booleanValue()) {
                throw new InterruptImageBuilding(String.format("The option %s requires the option %s to be set.", SubstrateOptionsParser.commandArgument(optionKey, "+"), SubstrateOptionsParser.commandArgument(MultiThreaded, "+")));
            }
        }
    }

    public static class ReportingSupport {
        Path reportsPath;

        public ReportingSupport(Path reportingPath) {
            this.reportsPath = reportingPath;
        }
    }

    public static enum ReportingMode {
        Warn,
        Throw,
        ExitTest,
        Exit;

    }

    public static class TruffleStableOptions {
        public static final HostedOptionKey<Boolean> CopyLanguageResources = new HostedOptionKey<Boolean>(false);
        public static final HostedOptionKey<Boolean> IncludeLanguageResources = new HostedOptionKey<Boolean>(true);
    }

    public static final class GCGroup
    implements APIOptionGroup {
        @Override
        public String name() {
            return "gc";
        }

        @Override
        public String helpText() {
            return "Select native-image garbage collector implementation.";
        }

        @Override
        public HostedOptionKey<ReplacingLocatableMultiOptionValue.DelimitedString> multiValueOption() {
            return SupportedGCs;
        }
    }
}

