/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.enums;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public abstract class CEnumRuntimeData {
    private static final NullPointerException CACHED_NULL_EXCEPTION = new NullPointerException("null enum object cannot be converted to C enum integer (typically for automatic conversions on return to C code)");
    private final long[] javaToC;
    private final int bytesInC;
    private final boolean isCEnumTypeUnsigned;

    protected CEnumRuntimeData(long[] javaToC, int bytesInC, boolean isCEnumTypeUnsigned) {
        this.javaToC = javaToC;
        this.bytesInC = bytesInC;
        this.isCEnumTypeUnsigned = isCEnumTypeUnsigned;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final boolean enumToBoolean(Enum<?> value) {
        return this.enumToLong(value) != 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final byte enumToByte(Enum<?> value) {
        return (byte)this.enumToLong(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final short enumToShort(Enum<?> value) {
        return (short)this.enumToLong(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final char enumToChar(Enum<?> value) {
        return (char)UninterruptibleUtils.CodeUtil.zeroExtend(this.enumToLong(value), this.bytesInC * 8);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final int enumToInt(Enum<?> value) {
        return (int)this.enumToLong(value);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final long enumToLong(Enum<?> value) {
        if (value == null) {
            throw CACHED_NULL_EXCEPTION;
        }
        return this.javaToC[value.ordinal()];
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final SignedWord enumToSignedWord(Enum<?> value) {
        long result = this.enumToLong(value);
        return Word.signed((long)result);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final UnsignedWord enumToUnsignedWord(Enum<?> value) {
        long result = UninterruptibleUtils.CodeUtil.zeroExtend(this.enumToLong(value), this.bytesInC * 8);
        return Word.unsigned((long)result);
    }

    public final Enum<?> longToEnum(long rawValue) {
        long lookupValue = this.isCEnumTypeUnsigned ? UninterruptibleUtils.CodeUtil.zeroExtend(rawValue, this.bytesInC * 8) : UninterruptibleUtils.CodeUtil.signExtend(rawValue, this.bytesInC * 8);
        return this.lookupEnum(lookupValue);
    }

    protected abstract Enum<?> lookupEnum(long var1);
}

