/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.SubstrateGCOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.CollectionPolicy;
import com.oracle.svm.core.genscavenge.GCAccounting;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapParameters;
import com.oracle.svm.core.genscavenge.SerialGCOptions;
import com.oracle.svm.core.heap.GCCause;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

final class BasicCollectionPolicies {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    static int getMaxSurvivorSpaces(Integer userValue) {
        assert (userValue == null || userValue >= 0);
        return 0;
    }

    private BasicCollectionPolicies() {
    }

    public static final class BySpaceAndTime
    extends BasicPolicy {
        @Override
        public boolean shouldCollectCompletely(boolean followingIncrementalCollection) {
            if (!followingIncrementalCollection && CollectionPolicy.shouldCollectYoungGenSeparately(false)) {
                return false;
            }
            return this.estimateUsedHeapAtNextIncrementalCollection().aboveThan(this.getMaximumHeapSize()) || GCImpl.getChunkBytes().aboveThan(this.getMinimumHeapSize()) && BySpaceAndTime.enoughTimeSpentOnIncrementalGCs();
        }

        private UnsignedWord estimateUsedHeapAtNextIncrementalCollection() {
            UnsignedWord currentYoungBytes = HeapImpl.getHeapImpl().getYoungGeneration().getChunkBytes();
            UnsignedWord maxYoungBytes = this.getMaximumYoungGenerationSize();
            UnsignedWord oldBytes = GCImpl.getAccounting().getOldGenerationAfterChunkBytes();
            return currentYoungBytes.add(maxYoungBytes).add(oldBytes);
        }

        private static boolean enoughTimeSpentOnIncrementalGCs() {
            int incrementalWeight = SerialGCOptions.PercentTimeInIncrementalCollection.getValue();
            assert (incrementalWeight >= 0 && incrementalWeight <= 100) : "BySpaceAndTimePercentTimeInIncrementalCollection should be in the range [0..100].";
            GCAccounting accounting = GCImpl.getAccounting();
            long actualIncrementalNanos = accounting.getIncrementalCollectionTotalNanos();
            long completeNanos = accounting.getCompleteCollectionTotalNanos();
            long totalNanos = actualIncrementalNanos + completeNanos;
            long expectedIncrementalNanos = TimeUtils.weightedNanos(incrementalWeight, totalNanos);
            return TimeUtils.nanoTimeLessThan(expectedIncrementalNanos, actualIncrementalNanos);
        }

        @Override
        public String getName() {
            return "by space and time";
        }
    }

    public static final class NeverCollect
    extends BasicPolicy {
        @Override
        public boolean shouldCollectOnAllocation() {
            throw VMError.shouldNotReachHere("Caller is supposed to be aware of never-collect policy");
        }

        @Override
        public boolean shouldCollectCompletely(boolean followingIncrementalCollection) {
            throw VMError.shouldNotReachHere("Collection must not be initiated in the first place");
        }

        @Override
        public String getName() {
            return "never collect";
        }
    }

    public static final class OnlyCompletely
    extends BasicPolicy {
        @Override
        public boolean shouldCollectCompletely(boolean followingIncrementalCollection) {
            return followingIncrementalCollection || !CollectionPolicy.shouldCollectYoungGenSeparately(false);
        }

        @Override
        public String getName() {
            return "only completely";
        }
    }

    public static final class OnlyIncrementally
    extends BasicPolicy {
        @Override
        public boolean shouldCollectCompletely(boolean followingIncrementalCollection) {
            return false;
        }

        @Override
        public String getName() {
            return "only incrementally";
        }
    }

    public static abstract class BasicPolicy
    implements CollectionPolicy {
        protected static UnsignedWord m(long bytes) {
            assert (0L <= bytes);
            return Word.unsigned((long)bytes).multiply(1024).multiply(1024);
        }

        @Override
        public boolean shouldCollectOnAllocation() {
            UnsignedWord youngUsed = HeapImpl.getAccounting().getYoungUsedBytes();
            return youngUsed.aboveOrEqual(this.getMaximumYoungGenerationSize());
        }

        @Override
        public boolean shouldCollectOnHint(boolean fullGC) {
            return false;
        }

        @Override
        public UnsignedWord getCurrentHeapCapacity() {
            return this.getMaximumHeapSize();
        }

        @Override
        public void ensureSizeParametersInitialized() {
        }

        @Override
        public void updateSizeParameters() {
        }

        @Override
        public UnsignedWord getInitialEdenSize() {
            return UNDEFINED;
        }

        @Override
        public UnsignedWord getMaximumEdenSize() {
            return this.getMaximumYoungGenerationSize();
        }

        @Override
        public final UnsignedWord getMaximumHeapSize() {
            long runtimeValue = SubstrateGCOptions.MaxHeapSize.getValue();
            if (runtimeValue != 0L) {
                return Word.unsigned((long)runtimeValue);
            }
            UnsignedWord addressSpaceSize = CommittedMemoryProvider.get().getCollectedHeapAddressSpaceSize();
            int maximumHeapSizePercent = HeapParameters.getMaximumHeapSizePercent();
            UnsignedWord result = PhysicalMemory.size().unsignedDivide(100).multiply(maximumHeapSizePercent);
            return UnsignedUtils.min(result, addressSpaceSize);
        }

        @Override
        public final UnsignedWord getMaximumYoungGenerationSize() {
            UnsignedWord maxSize;
            long runtimeValue = SubstrateGCOptions.MaxNewSize.getValue();
            if (runtimeValue != 0L) {
                return Word.unsigned((long)runtimeValue);
            }
            UnsignedWord maxHeapSize = this.getMaximumHeapSize();
            UnsignedWord youngSizeAsFraction = maxHeapSize.unsignedDivide(100).multiply(HeapParameters.getMaximumYoungGenerationSizePercent());
            UnsignedWord youngSize = youngSizeAsFraction.belowOrEqual(maxSize = BasicPolicy.m(256L)) ? youngSizeAsFraction : maxSize;
            return youngSize;
        }

        @Override
        public final UnsignedWord getMinimumHeapSize() {
            long runtimeValue = SubstrateGCOptions.MinHeapSize.getValue();
            if (runtimeValue != 0L) {
                return Word.unsigned((long)runtimeValue);
            }
            UnsignedWord result = this.getMaximumYoungGenerationSize().multiply(2);
            if (result.aboveThan(this.getMaximumHeapSize())) {
                result = this.getMaximumHeapSize();
            }
            return result;
        }

        @Override
        public UnsignedWord getInitialSurvivorSize() {
            return UNDEFINED;
        }

        @Override
        public UnsignedWord getMaximumSurvivorSize() {
            return (UnsignedWord)Word.zero();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public UnsignedWord getSurvivorSpacesCapacity() {
            return (UnsignedWord)Word.zero();
        }

        @Override
        public UnsignedWord getYoungGenerationCapacity() {
            return this.getMaximumYoungGenerationSize();
        }

        @Override
        public UnsignedWord getInitialOldSize() {
            return UNDEFINED;
        }

        @Override
        public UnsignedWord getOldGenerationCapacity() {
            UnsignedWord heapCapacity = this.getCurrentHeapCapacity();
            UnsignedWord youngCapacity = this.getYoungGenerationCapacity();
            if (youngCapacity.aboveThan(heapCapacity)) {
                return (UnsignedWord)Word.zero();
            }
            return heapCapacity.subtract(youngCapacity);
        }

        @Override
        public UnsignedWord getMaximumOldSize() {
            return this.getOldGenerationCapacity();
        }

        @Override
        public final UnsignedWord getMaximumFreeAlignedChunksSize() {
            return this.getMaximumYoungGenerationSize();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int getTenuringAge() {
            return 1;
        }

        @Override
        public void onCollectionBegin(boolean completeCollection, long requestingNanoTime) {
        }

        @Override
        public void onCollectionEnd(boolean completeCollection, GCCause cause) {
        }
    }
}

