/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.NeverInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.identityhashcode.IdentityHashCodeSupport;
import com.oracle.svm.core.util.VMError;
import java.util.function.IntUnaryOperator;
import jdk.graal.compiler.api.directives.GraalDirectives;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawFieldAddress;
import org.graalvm.nativeimage.c.struct.RawFieldOffset;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;

public final class HeapChunk {
    public static final LocationIdentity CHUNK_HEADER_TOP_IDENTITY = NamedLocationIdentity.mutable((String)"ChunkHeader.top");

    private HeapChunk() {
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void initialize(Header<?> chunk, Pointer objectsStart, UnsignedWord endOffset) {
        HeapChunk.setEndOffset(chunk, endOffset);
        HeapChunk.setTopPointer(chunk, objectsStart);
        HeapChunk.setSpace(chunk, null);
        HeapChunk.setNext(chunk, (Header)Word.nullPointer());
        HeapChunk.setPrevious(chunk, (Header)Word.nullPointer());
        HeapChunk.setIdentityHashSalt(chunk, GCImpl.getGCImpl().getCollectionEpoch());
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getTopOffset(Header<?> that) {
        assert (HeapChunk.getTopPointer(that).isNonNull()) : "Not safe: top currently points to NULL.";
        return that.getTopOffset(CHUNK_HEADER_TOP_IDENTITY);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getTopPointer(Header<?> that) {
        return HeapChunk.asPointer(that).add(that.getTopOffset(CHUNK_HEADER_TOP_IDENTITY));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setTopPointer(Header<?> that, Pointer newTop) {
        that.setTopOffset((UnsignedWord)newTop.subtract((UnsignedWord)HeapChunk.asPointer(that)), CHUNK_HEADER_TOP_IDENTITY);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setTopPointerCarefully(Header<?> that, Pointer newTop) {
        assert (HeapChunk.getTopPointer(that).isNonNull()) : "Not safe: top currently points to NULL.";
        assert (HeapChunk.getTopPointer(that).belowOrEqual((UnsignedWord)newTop)) : "newTop too low.";
        assert (newTop.belowOrEqual((UnsignedWord)HeapChunk.getEndPointer(that))) : "newTop too high.";
        HeapChunk.setTopPointer(that, newTop);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getEndOffset(Header<?> that) {
        return that.getEndOffset();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getEndPointer(Header<?> that) {
        return HeapChunk.asPointer(that).add(HeapChunk.getEndOffset(that));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setEndOffset(Header<?> that, UnsignedWord newEnd) {
        that.setEndOffset(newEnd);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Space getSpace(Header<?> that) {
        return that.getSpace();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setSpace(Header<?> that, Space newSpace) {
        assert (newSpace == null || that.getSpace() == null) : "heap chunk must be removed from its current space before it can be registered with a new space";
        that.setSpace(newSpace);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> T getPrevious(Header<T> that) {
        return (T)((Header)HeapChunk.pointerFromOffset(that, (ComparableWord)that.getOffsetToPreviousChunk()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> void setPrevious(Header<T> that, T newPrevious) {
        that.setOffsetToPreviousChunk(HeapChunk.offsetFromPointer(that, newPrevious));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> T getNext(Header<T> that) {
        return (T)((Header)HeapChunk.pointerFromOffset(that, (ComparableWord)that.getOffsetToNextChunk()));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static <T extends Header<T>> void setNext(Header<T> that, T newNext) {
        that.setOffsetToNextChunk(HeapChunk.offsetFromPointer(that, newNext));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getIdentityHashSalt(Header<?> that) {
        return that.getIdentityHashSalt(IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION).rawValue();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setIdentityHashSalt(Header<?> that, UnsignedWord value) {
        that.setIdentityHashSalt(value, IdentityHashCodeSupport.IDENTITY_HASHCODE_SALT_LOCATION);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static <T extends PointerBase> T pointerFromOffset(Header<?> that, ComparableWord offset) {
        PointerBase pointer = Word.nullPointer();
        if (offset.notEqual((ComparableWord)Word.zero())) {
            pointer = (PointerBase)((SignedWord)that).add((SignedWord)offset);
        }
        return (T)pointer;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static SignedWord offsetFromPointer(Header<?> that, PointerBase pointer) {
        SignedWord offset = (SignedWord)Word.zero();
        if (pointer.isNonNull()) {
            offset = ((SignedWord)pointer).subtract((SignedWord)that);
        }
        return offset;
    }

    @NeverInline(value="Not performance critical")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).")
    public static void walkObjectsFrom(Header<?> that, Pointer start, ObjectVisitor visitor) {
        HeapChunk.walkObjectsFromInline(that, start, visitor);
    }

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Forced inlining (StoredContinuation objects must not move).", callerMustBe=true)
    public static void walkObjectsFromInline(Header<?> that, Pointer start, ObjectVisitor visitor) {
        Pointer p = start;
        while (p.belowThan((UnsignedWord)HeapChunk.getTopPointer(that))) {
            Object obj = p.toObjectNonNull();
            HeapChunk.callVisitor(visitor, obj);
            p = p.add(LayoutEncoding.getSizeFromObjectInlineInGC(obj));
        }
    }

    @AlwaysInline(value="de-virtualize calls to ObjectReferenceVisitor")
    @Uninterruptible(reason="Bridge between uninterruptible and potentially interruptible code.", mayBeInlined=true, calleeMustBe=false)
    private static void callVisitor(ObjectVisitor visitor, Object obj) {
        visitor.visitObject(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord availableObjectMemory(Header<?> that) {
        return that.getEndOffset().subtract(that.getTopOffset(CHUNK_HEADER_TOP_IDENTITY));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer asPointer(Header<?> that) {
        return (Pointer)that;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Header<?> getEnclosingHeapChunk(Object obj) {
        if (!GraalDirectives.inIntrinsic()) assert (!ObjectHeaderImpl.isPointerToForwardedObject((Pointer)Word.objectToUntrackedPointer((Object)obj))) : "Forwarded objects must be a pointer and not an object";
        if (ObjectHeaderImpl.isAlignedObject(obj)) {
            return AlignedHeapChunk.getEnclosingChunk(obj);
        }
        if (!GraalDirectives.inIntrinsic()) assert (ObjectHeaderImpl.isUnalignedObject(obj));
        return UnalignedHeapChunk.getEnclosingChunk(obj);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Header<?> getEnclosingHeapChunk(Pointer ptrToObj, UnsignedWord header) {
        if (ObjectHeaderImpl.isAlignedHeader(header)) {
            return AlignedHeapChunk.getEnclosingChunkFromObjectPointer(ptrToObj);
        }
        return UnalignedHeapChunk.getEnclosingChunkFromObjectPointer(ptrToObj);
    }

    @RawStructure
    public static interface Header<T extends Header<T>>
    extends HeaderPadding {
        @RawField
        public UnsignedWord getTopOffset(LocationIdentity var1);

        @RawField
        public void setTopOffset(UnsignedWord var1, LocationIdentity var2);

        @RawFieldOffset
        public static int offsetOfTopOffset() {
            throw VMError.shouldNotReachHereAtRuntime();
        }

        @RawField
        @UniqueLocationIdentity
        public UnsignedWord getEndOffset();

        @RawField
        @UniqueLocationIdentity
        public void setEndOffset(UnsignedWord var1);

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public Space getSpace();

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public void setSpace(Space var1);

        @RawField
        @UniqueLocationIdentity
        public SignedWord getOffsetToPreviousChunk();

        @RawField
        @UniqueLocationIdentity
        public void setOffsetToPreviousChunk(SignedWord var1);

        @RawField
        @UniqueLocationIdentity
        public SignedWord getOffsetToNextChunk();

        @RawField
        @UniqueLocationIdentity
        public void setOffsetToNextChunk(SignedWord var1);

        @RawField
        public UnsignedWord getIdentityHashSalt(LocationIdentity var1);

        @RawField
        public void setIdentityHashSalt(UnsignedWord var1, LocationIdentity var2);

        @RawField
        public int getPinnedObjectCount();

        @RawFieldAddress
        public Pointer addressOfPinnedObjectCount();
    }

    @RawStructure(sizeProvider=HeaderPaddingSizeProvider.class)
    private static interface HeaderPadding
    extends PointerBase {
    }

    static class HeaderPaddingSizeProvider
    implements IntUnaryOperator {
        HeaderPaddingSizeProvider() {
        }

        @Override
        public int applyAsInt(int operand) {
            assert (operand == 0) : "padding structure does not declare any fields";
            return SerialAndEpsilonGCOptions.HeapChunkHeaderPadding.getValue();
        }
    }
}

