/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.SerialAndEpsilonGCOptions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jdk.graal.compiler.options.OptionDescriptor;
import jdk.graal.compiler.options.OptionDescriptors;
import jdk.graal.compiler.options.OptionStability;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionsContainer;

public class SerialAndEpsilonGCOptions_OptionDescriptors
implements OptionDescriptors {
    private OptionsContainer cachedContainer;

    public OptionsContainer getContainer() {
        if (this.cachedContainer == null) {
            this.cachedContainer = new OptionsContainer.Default(SerialAndEpsilonGCOptions.class);
        }
        return this.cachedContainer;
    }

    public OptionDescriptor get(String value) {
        switch (this.getContainer().unprefixed(value)) {
            case "AlignedHeapChunkSize": {
                return OptionDescriptor.create((String)"AlignedHeapChunkSize", (OptionType)OptionType.Expert, Long.class, (String)"The size of an aligned chunk. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.AlignedHeapChunkSize, (String)"AlignedHeapChunkSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "HeapChunkHeaderPadding": {
                return OptionDescriptor.create((String)"HeapChunkHeaderPadding", (OptionType)OptionType.Debug, Integer.class, (String)"Number of bytes at the beginning of each heap chunk that are not used for payload data, i.e., can be freely used as metadata by the heap chunk provider. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.HeapChunkHeaderPadding, (String)"HeapChunkHeaderPadding", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "InitialTLABSize": {
                return OptionDescriptor.create((String)"InitialTLABSize", (OptionType)OptionType.Expert, Long.class, (String)"Starting TLAB size (in bytes); zero means set ergonomically.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.InitialTLABSize, (String)"InitialTLABSize", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "LargeArrayThreshold": {
                return OptionDescriptor.create((String)"LargeArrayThreshold", (OptionType)OptionType.Expert, Long.class, (String)"The size at or above which an array will be allocated in its own unaligned chunk. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.LargeArrayThreshold, (String)"LargeArrayThreshold", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaximumHeapSizePercent": {
                return OptionDescriptor.create((String)"MaximumHeapSizePercent", (OptionType)OptionType.User, Integer.class, (String)"The maximum heap size as percent of physical memory. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.MaximumHeapSizePercent, (String)"MaximumHeapSizePercent", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "MaximumYoungGenerationSizePercent": {
                return OptionDescriptor.create((String)"MaximumYoungGenerationSizePercent", (OptionType)OptionType.User, Integer.class, (String)"The maximum size of the young generation as a percentage of the maximum heap size. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.MaximumYoungGenerationSizePercent, (String)"MaximumYoungGenerationSizePercent", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "PrintTLAB": {
                return OptionDescriptor.create((String)"PrintTLAB", (OptionType)OptionType.Expert, Boolean.class, (String)"Print information about TLABs. Printed when The TLABs are retired before a GC, and during the resizing of the TLABs. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.PrintTLAB, (String)"PrintTLAB", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ZapChunks": {
                return OptionDescriptor.create((String)"ZapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Fill unused memory chunks with a sentinel value. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.ZapChunks, (String)"ZapChunks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ZapConsumedHeapChunks": {
                return OptionDescriptor.create((String)"ZapConsumedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"After use, Fill memory chunks with a sentinel value. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.ZapConsumedHeapChunks, (String)"ZapConsumedHeapChunks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
            case "ZapProducedHeapChunks": {
                return OptionDescriptor.create((String)"ZapProducedHeapChunks", (OptionType)OptionType.Debug, Boolean.class, (String)"Before use, fill memory chunks with a sentinel value. Serial, parallel and epsilon GC only.", (Object)this.getContainer(), SerialAndEpsilonGCOptions.ZapProducedHeapChunks, (String)"ZapProducedHeapChunks", (OptionStability)OptionStability.EXPERIMENTAL, (boolean)false, (String)"");
            }
        }
        return null;
    }

    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < 10;
            }

            @Override
            public OptionDescriptor next() {
                switch (this.i++) {
                    case 0: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("AlignedHeapChunkSize");
                    }
                    case 1: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("HeapChunkHeaderPadding");
                    }
                    case 2: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("InitialTLABSize");
                    }
                    case 3: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("LargeArrayThreshold");
                    }
                    case 4: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("MaximumHeapSizePercent");
                    }
                    case 5: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("MaximumYoungGenerationSizePercent");
                    }
                    case 6: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("PrintTLAB");
                    }
                    case 7: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("ZapChunks");
                    }
                    case 8: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("ZapConsumedHeapChunks");
                    }
                    case 9: {
                        return SerialAndEpsilonGCOptions_OptionDescriptors.this.get("ZapProducedHeapChunks");
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }
}

