/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import com.oracle.svm.core.genscavenge.remset.BrickTable;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.hub.LayoutEncoding;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class PlanningVisitor
implements AlignedHeapChunk.Visitor {
    private AlignedHeapChunk.AlignedHeader allocChunk;
    private Pointer allocPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public PlanningVisitor() {
    }

    public void init(Space space) {
        this.allocChunk = space.getFirstAlignedHeapChunk();
        this.allocPointer = AlignedHeapChunk.getObjectsStart(this.allocChunk);
    }

    @Override
    public boolean visitChunk(AlignedHeapChunk.AlignedHeader chunk) {
        boolean sweeping = chunk.getShouldSweepInsteadOfCompact();
        Pointer initialTop = HeapChunk.getTopPointer(chunk);
        Pointer objSeq = AlignedHeapChunk.getObjectsStart(chunk);
        UnsignedWord gapSize = (UnsignedWord)Word.zero();
        UnsignedWord objSeqSize = (UnsignedWord)Word.zero();
        UnsignedWord brickIndex = (UnsignedWord)Word.zero();
        ObjectMoveInfo.setNewAddress(objSeq, objSeq);
        ObjectMoveInfo.setObjectSeqSize(objSeq, (UnsignedWord)Word.zero());
        ObjectMoveInfo.setNextObjectSeqOffset(objSeq, (UnsignedWord)Word.zero());
        BrickTable.setEntry(chunk, brickIndex, objSeq);
        Pointer p = objSeq;
        while (p.belowThan((UnsignedWord)initialTop)) {
            UnsignedWord objSize;
            ObjectHeader oh = Heap.getHeap().getObjectHeader();
            Word header = oh.readHeaderFromPointer(p);
            if (ObjectHeaderImpl.isForwardedHeader((UnsignedWord)header)) {
                assert (!sweeping && ConfigurationValues.getObjectLayout().isIdentityHashFieldOptional());
                Object forwardedObj = ObjectHeaderImpl.getObjectHeaderImpl().getForwardedObject(p, (UnsignedWord)header);
                objSize = LayoutEncoding.getSizeFromObjectWithoutOptionalIdHashFieldInGC(forwardedObj);
            } else {
                objSize = LayoutEncoding.getSizeFromObjectInlineInGC(p.toObjectNonNull());
            }
            if (ObjectHeaderImpl.isMarkedHeader((UnsignedWord)header)) {
                ObjectHeaderImpl.unsetMarkedAndKeepRememberedSetBit(p.toObjectNonNull());
                assert (sweeping || !ConfigurationValues.getObjectLayout().isIdentityHashFieldOptional() || !ObjectHeaderImpl.hasIdentityHashFromAddressInline(header));
                if (gapSize.notEqual(0)) {
                    ObjectMoveInfo.setNextObjectSeqOffset(objSeq, (UnsignedWord)p.subtract((UnsignedWord)objSeq));
                    objSeq = p;
                    ObjectMoveInfo.setNextObjectSeqOffset(objSeq, (UnsignedWord)Word.zero());
                    gapSize = (UnsignedWord)Word.zero();
                }
                objSeqSize = objSeqSize.add(objSize);
            } else {
                if (objSeqSize.notEqual(0)) {
                    Pointer newAddress = sweeping ? objSeq : this.allocate(objSeqSize);
                    ObjectMoveInfo.setNewAddress(objSeq, newAddress);
                    ObjectMoveInfo.setObjectSeqSize(objSeq, objSeqSize);
                    objSeqSize = (UnsignedWord)Word.zero();
                    UnsignedWord currentBrick = BrickTable.getIndex(chunk, p);
                    while (brickIndex.belowThan(currentBrick)) {
                        brickIndex = brickIndex.add(1);
                        BrickTable.setEntry(chunk, brickIndex, objSeq);
                    }
                }
                gapSize = gapSize.add(objSize);
            }
            p = p.add(objSize);
        }
        assert (gapSize.equal(0) || objSeqSize.equal(0));
        if (gapSize.notEqual(0)) {
            UnsignedWord newTopOffset = chunk.getTopOffset(HeapChunk.CHUNK_HEADER_TOP_IDENTITY).subtract(gapSize);
            chunk.setTopOffset(newTopOffset, HeapChunk.CHUNK_HEADER_TOP_IDENTITY);
        } else if (objSeqSize.notEqual(0)) {
            Pointer newAddress = sweeping ? objSeq : this.allocate(objSeqSize);
            ObjectMoveInfo.setNewAddress(objSeq, newAddress);
            ObjectMoveInfo.setObjectSeqSize(objSeq, objSeqSize);
        }
        if (sweeping) {
            this.allocChunk = chunk;
            this.allocPointer = HeapChunk.getTopPointer(chunk);
        }
        brickIndex = brickIndex.add(1);
        while (brickIndex.belowThan(BrickTable.getLength())) {
            BrickTable.setEntry(chunk, brickIndex, objSeq);
            brickIndex = brickIndex.add(1);
        }
        return true;
    }

    private Pointer allocate(UnsignedWord size) {
        Pointer p = this.allocPointer;
        this.allocPointer = this.allocPointer.add(size);
        if (this.allocPointer.aboveThan((UnsignedWord)AlignedHeapChunk.getObjectsEnd(this.allocChunk))) {
            this.allocChunk = HeapChunk.getNext(this.allocChunk);
            assert (this.allocChunk.isNonNull());
            assert (!this.allocChunk.getShouldSweepInsteadOfCompact());
            p = AlignedHeapChunk.getObjectsStart(this.allocChunk);
            this.allocPointer = p.add(size);
        }
        return p;
    }
}

