/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.compacting;

import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.FillerObjectUtil;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.compacting.ObjectMoveInfo;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;

public final class SweepingVisitor
implements ObjectMoveInfo.Visitor {
    @Override
    public boolean visit(Pointer objSeq, UnsignedWord size, Pointer newAddress, Pointer nextObjSeq) {
        assert (objSeq.equal((UnsignedWord)newAddress));
        if (nextObjSeq.isNonNull()) {
            Pointer gapStart = objSeq.add(size);
            assert (gapStart.belowThan((UnsignedWord)nextObjSeq));
            FillerObjectUtil.writeFillerObjectAt(gapStart, (UnsignedWord)nextObjSeq.subtract((UnsignedWord)gapStart), true);
        } else {
            AlignedHeapChunk.AlignedHeader chunk = AlignedHeapChunk.getEnclosingChunkFromObjectPointer(objSeq);
            assert (objSeq.add(size).equal((UnsignedWord)HeapChunk.getTopPointer(chunk)));
        }
        return true;
    }
}

