/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.amd64;

import com.oracle.svm.core.graal.amd64.SubstrateAMD64Backend;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractStateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo
public class AMD64CopyLongsNode
extends AbstractStateSplit
implements LIRLowerable {
    public static final NodeClass<AMD64CopyLongsNode> TYPE = NodeClass.create(AMD64CopyLongsNode.class);
    @Node.Input
    private ValueNode src;
    @Node.Input
    private ValueNode dst;
    @Node.Input
    private ValueNode len;
    private final boolean forward;

    protected AMD64CopyLongsNode(ValueNode src, ValueNode dst, ValueNode len, boolean forward) {
        super(TYPE, StampFactory.forVoid());
        this.src = src;
        this.dst = dst;
        this.len = len;
        this.forward = forward;
    }

    public static AMD64CopyLongsNode forward(ValueNode src, ValueNode dst, ValueNode len) {
        return new AMD64CopyLongsNode(src, dst, len, true);
    }

    public static AMD64CopyLongsNode backward(ValueNode src, ValueNode dst, ValueNode len) {
        return new AMD64CopyLongsNode(src, dst, len, false);
    }

    public void generate(NodeLIRBuilderTool gen) {
        SubstrateAMD64Backend.SubstrateAMD64LIRGenerator tool = (SubstrateAMD64Backend.SubstrateAMD64LIRGenerator)gen.getLIRGeneratorTool();
        tool.emitCopyLongs(null, gen.operand((Node)this.src), gen.operand((Node)this.dst), gen.operand((Node)this.len), this.forward);
    }
}

