/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.handles;

import com.oracle.svm.core.handles.PrimitiveArrayView;
import com.oracle.svm.core.handles.PrimitiveArrayViewSupport;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.word.PointerBase;

final class PinnedPrimitiveArrayViewSupportImpl
implements PrimitiveArrayViewSupport {
    PinnedPrimitiveArrayViewSupportImpl() {
    }

    @Override
    public PrimitiveArrayView createForReading(Object object) {
        return new PinnedPrimitiveElementArrayReferenceImpl(object);
    }

    @Override
    public PrimitiveArrayView createForReadingAndWriting(Object object) {
        return new PinnedPrimitiveElementArrayReferenceImpl(object);
    }

    static final class PinnedPrimitiveElementArrayReferenceImpl
    implements PrimitiveArrayView {
        private final PinnedObject pinnedObject;

        PinnedPrimitiveElementArrayReferenceImpl(Object object) {
            this.pinnedObject = PinnedObject.create((Object)object);
        }

        @Override
        public void close() {
            this.pinnedObject.close();
        }

        @Override
        public void untrack() {
            this.pinnedObject.close();
        }

        @Override
        public <T extends PointerBase> T addressOfArrayElement(int index) {
            return (T)this.pinnedObject.addressOfArrayElement(index);
        }

        @Override
        public boolean isCopy() {
            return false;
        }

        @Override
        public void syncToHeap() {
        }
    }
}

